/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import graphql.language.ObjectTypeDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveReturnStage
extends AbstractStage {
    public ReactiveReturnStage(Schema schema, TypeMapper typeMapper) {
        super(schema, typeMapper);
    }

    @Override
    public List<CodeBlock> assemble(ClientDetails client, MethodDetails method) {
        ObjectTypeDefinition typeDefinition = this.getTypeDefinition(method);
        ArrayList<CodeBlock> ret = new ArrayList<CodeBlock>(Arrays.asList(CodeBlock.of((String)"return $T.from(thing)", (Object[])new Object[]{method.isSubscription() ? Flux.class : Mono.class}), CodeBlock.of((String)"map($T::getData)", (Object[])new Object[]{ClassName.get(Response.class)}), CodeBlock.of((String)"map($T::$L)", (Object[])new Object[]{this.typeMapper.getType(typeDefinition.getName()), StringUtils.camelCase("get", method.getField())})));
        if (!this.returnsPublisher(method)) {
            ret.add(CodeBlock.of((String)"blockOptional()", (Object[])new Object[0]));
            if (!this.returnsOptional(method)) {
                ret.add(CodeBlock.of((String)"orElse(null)", (Object[])new Object[0]));
            }
        } else if (this.returnsClass(method, Flux.class) && !method.isSubscription()) {
            ret.add(CodeBlock.of((String)"flatMapIterable($T.identity())", (Object[])new Object[]{Function.class}));
        }
        return Collections.singletonList(CodeBlock.join(ret, (String)"\n\t."));
    }

    private boolean returnsPublisher(MethodDetails details) {
        return this.returnsClass(details, Mono.class) || this.returnsClass(details, Flux.class);
    }

    private boolean returnsClass(MethodDetails details, Class<?> clazz) {
        return details.getReturnType() instanceof ParameterizedTypeName && ((ParameterizedTypeName)details.getReturnType()).rawType.equals((Object)ClassName.get(clazz));
    }

    private boolean returnsOptional(MethodDetails details) {
        return this.returnsClass(details, Optional.class);
    }
}

