/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.query.filters;

import com.jacobmountain.graphql.client.query.QueryContext;
import com.jacobmountain.graphql.client.query.filters.FieldFilter;
import com.jacobmountain.graphql.client.utils.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldDuplicationFilter
implements FieldFilter {
    private static final Logger log = LoggerFactory.getLogger(FieldDuplicationFilter.class);
    private final Map<String, Set<String>> visited = new HashMap<String, Set<String>>();

    @Override
    public boolean shouldAddField(QueryContext context) {
        String path = this.generatePath(context);
        Set strings = this.visited.computeIfAbsent(path, key -> new HashSet());
        return strings.add(context.getFieldDefinition().getName());
    }

    private String generatePath(QueryContext context) {
        ArrayList<String> path = new ArrayList<String>();
        for (QueryContext parent = context; parent != null; parent = parent.getParent()) {
            path.add(0, parent.getFieldDefinition().getName());
        }
        path.set(path.size() - 1, Schema.unwrap(context.getType()));
        return String.join((CharSequence)".", path);
    }
}

