/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.visitor;

import com.jacobmountain.graphql.client.annotations.GraphQLArgument;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import javax.lang.model.element.Modifier;

public class Parameter {
    private TypeName type;
    private String name;
    private GraphQLArgument annotation;
    private boolean nullable;

    public ParameterSpec toSpec() {
        return ParameterSpec.builder((TypeName)this.type, (String)this.name, (Modifier[])new Modifier[0]).build();
    }

    public String getField() {
        return this.annotation == null ? this.name : this.annotation.value();
    }

    public GraphQLArgument getAnnotation() {
        return this.annotation;
    }

    Parameter(TypeName type, String name, GraphQLArgument annotation, boolean nullable) {
        this.type = type;
        this.name = name;
        this.annotation = annotation;
        this.nullable = nullable;
    }

    public static ParameterBuilder builder() {
        return new ParameterBuilder();
    }

    public TypeName getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setType(TypeName type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAnnotation(GraphQLArgument annotation) {
        this.annotation = annotation;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        TypeName this$type = this.getType();
        TypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        GraphQLArgument this$annotation = this.getAnnotation();
        GraphQLArgument other$annotation = other.getAnnotation();
        return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Parameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNullable() ? 79 : 97);
        TypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        GraphQLArgument $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
        return result;
    }

    public String toString() {
        return "Parameter(type=" + this.getType() + ", name=" + this.getName() + ", annotation=" + this.getAnnotation() + ", nullable=" + this.isNullable() + ")";
    }

    public static class ParameterBuilder {
        private TypeName type;
        private String name;
        private GraphQLArgument annotation;
        private boolean nullable;

        ParameterBuilder() {
        }

        public ParameterBuilder type(TypeName type) {
            this.type = type;
            return this;
        }

        public ParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ParameterBuilder annotation(GraphQLArgument annotation) {
            this.annotation = annotation;
            return this;
        }

        public ParameterBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Parameter build() {
            return new Parameter(this.type, this.name, this.annotation, this.nullable);
        }

        public String toString() {
            return "Parameter.ParameterBuilder(type=" + this.type + ", name=" + this.name + ", annotation=" + this.annotation + ", nullable=" + this.nullable + ")";
        }
    }
}

