/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.query.QueryGenerator;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.visitor.GraphQLFieldSelection;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.jacobmountain.graphql.client.visitor.Parameter;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import graphql.language.ObjectTypeDefinition;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractQueryStage
extends AbstractStage {
    protected final TypeName query;
    protected final TypeName mutation;
    protected final TypeName subscription;
    private final QueryGenerator queryGenerator;

    public AbstractQueryStage(QueryGenerator queryGenerator, Schema schema, TypeMapper typeMapper, String dtoPackageName) {
        super(schema, typeMapper);
        this.query = ClassName.get((String)dtoPackageName, (String)schema.getQueryTypeName(), (String[])new String[0]);
        this.mutation = (TypeName)schema.getMutationTypeName().map(it -> ClassName.get((String)dtoPackageName, (String)it, (String[])new String[0])).orElse(ClassName.get(Void.class));
        this.subscription = (TypeName)schema.getSubscriptionTypeName().map(it -> ClassName.get((String)dtoPackageName, (String)it, (String[])new String[0])).orElse(ClassName.get(Void.class));
        this.queryGenerator = queryGenerator;
    }

    @Override
    public List<String> getTypeArguments() {
        return Collections.singletonList("Error");
    }

    protected TypeName getReturnTypeName(MethodDetails details) {
        ObjectTypeDefinition typeDefinition = this.getTypeDefinition(details);
        return ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])new TypeName[]{this.typeMapper.getType(typeDefinition.getName()), TypeVariableName.get((String)"Error")});
    }

    protected String getMethod(MethodDetails details) {
        String method = "query";
        if (details.isMutation()) {
            method = "mutate";
        } else if (details.isSubscription()) {
            method = "subscribe";
        }
        return method;
    }

    protected CodeBlock generateQueryCode(String request, MethodDetails method) {
        QueryGenerator.QueryBuilder builder;
        Set<String> params = method.getParameters().stream().map(Parameter::getField).collect(Collectors.toSet());
        if (method.isQuery()) {
            builder = this.queryGenerator.query();
        } else if (method.isMutation()) {
            builder = this.queryGenerator.mutation();
        } else if (method.isSubscription()) {
            builder = this.queryGenerator.subscription();
        } else {
            throw new IllegalStateException();
        }
        String query = builder.select(method.getSelection().stream().map(GraphQLFieldSelection::new).collect(Collectors.toList())).maxDepth(method.getMaxDepth()).build(request, method.getField(), params);
        return CodeBlock.of((String)"(\"$L\", $L)", (Object[])new Object[]{query, method.hasParameters() ? "args" : "null"});
    }
}

