/*
 * Decompiled with CFR 0.152.
 */
package com.jacobmountain.graphql.client.modules;

import com.jacobmountain.graphql.client.TypeMapper;
import com.jacobmountain.graphql.client.dto.Response;
import com.jacobmountain.graphql.client.modules.AbstractStage;
import com.jacobmountain.graphql.client.modules.ClientDetails;
import com.jacobmountain.graphql.client.utils.Schema;
import com.jacobmountain.graphql.client.utils.StringUtils;
import com.jacobmountain.graphql.client.visitor.MethodDetails;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import graphql.language.ObjectTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveReturnStage
extends AbstractStage {
    public static final ClassName RESPONSE_CLASS_NAME = ClassName.get(Response.class);

    public ReactiveReturnStage(Schema schema, TypeMapper typeMapper) {
        super(schema, typeMapper);
    }

    @Override
    public List<CodeBlock> assemble(ClientDetails client, MethodDetails method) {
        if (ClassName.VOID.equals((Object)method.getReturnType())) {
            if (!method.isMutation()) {
                throw new IllegalArgumentException("void return type on a non mutation method");
            }
            return Collections.singletonList(CodeBlock.of((String)"$T.from(thing).block()", (Object[])new Object[]{method.isSubscription() ? Flux.class : Mono.class}));
        }
        ObjectTypeDefinition typeDefinition = this.getTypeDefinition(method);
        ArrayList<CodeBlock> ret = new ArrayList<CodeBlock>();
        ret.add(CodeBlock.of((String)"return $T.from(thing)", (Object[])new Object[]{method.isSubscription() ? Flux.class : Mono.class}));
        ret.add(CodeBlock.of((String)"map($T::getData)", (Object[])new Object[]{RESPONSE_CLASS_NAME}));
        ret.add(CodeBlock.of((String)"filter(data -> $T.nonNull(data.$L()))", (Object[])new Object[]{Objects.class, StringUtils.camelCase("get", method.getField())}));
        ret.add(CodeBlock.of((String)"map($T::$L)", (Object[])new Object[]{this.typeMapper.getType(typeDefinition.getName()), StringUtils.camelCase("get", method.getField())}));
        this.unwrapReturnType(method).ifPresent(ret::add);
        return Collections.singletonList(CodeBlock.join(ret, (String)"\n\t."));
    }

    private Optional<CodeBlock> unwrapReturnType(MethodDetails method) {
        if (method.returnsClass(Mono.class, Void.class)) {
            return Optional.of(CodeBlock.of((String)"then()", (Object[])new Object[0]));
        }
        if (method.returnsClass(Flux.class, new Class[0]) && !method.isSubscription()) {
            return Optional.of(CodeBlock.of((String)"flatMapIterable($T.identity())", (Object[])new Object[]{Function.class}));
        }
        if (method.returnsClass(Optional.class, new Class[0])) {
            return Optional.of(CodeBlock.of((String)"blockOptional()", (Object[])new Object[0]));
        }
        if (method.returnsClass(Mono.class, new Class[0]) || method.returnsClass(Flux.class, new Class[0]) || method.returnsClass(Publisher.class, new Class[0])) {
            return Optional.empty();
        }
        return Optional.of(CodeBlock.of((String)"block()", (Object[])new Object[0]));
    }
}

