/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.database;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.ValueEventListener;
import com.jdroid.java.collections.Lists;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.database.FirebaseCompletionListener;
import com.jdroid.java.firebase.database.FirebaseValueEventListener;
import com.jdroid.java.firebase.database.auth.FirebaseAuthenticationStrategy;
import com.jdroid.java.repository.Pair;
import com.jdroid.java.repository.PairRepository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;

public abstract class PairFirebaseRepository
implements PairRepository {
    private static final Logger LOGGER = LoggerUtils.getLogger(PairFirebaseRepository.class);
    private FirebaseAuthenticationStrategy firebaseAuthenticationStrategy = this.createFirebaseAuthenticationStrategy();

    protected FirebaseAuthenticationStrategy createFirebaseAuthenticationStrategy() {
        return null;
    }

    protected abstract String getFirebaseUrl();

    protected abstract String getPath();

    protected Firebase createFirebase() {
        Firebase firebase = new Firebase(this.getFirebaseUrl());
        if (this.firebaseAuthenticationStrategy != null && firebase.getAuth() == null) {
            this.firebaseAuthenticationStrategy.authenticate(firebase);
        }
        firebase = firebase.child(this.getPath());
        return firebase;
    }

    public Pair get(String id) {
        Firebase firebase = this.createFirebase();
        firebase = firebase.child(id);
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        String result = (String)listener.getDataSnapshot().getValue(String.class);
        Pair pair = null;
        if (result != null) {
            pair = new Pair();
            pair.setId(id);
            pair.setValue(result);
            LOGGER.debug("Retrieved object from database with path [ " + this.getPath() + "]. [ " + result + " ]");
        } else {
            LOGGER.debug("Object not found on database with path [ " + this.getPath() + " ] and id [ " + id + " ]");
        }
        return pair;
    }

    public void add(Pair item) {
        Firebase firebase = this.createFirebase();
        firebase = firebase.child(item.getId());
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.setValue((Object)item.getValue(), (Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug("Stored object in database: " + item);
    }

    public void addAll(Collection<Pair> items) {
        for (Pair each : items) {
            this.add(each);
        }
    }

    public void update(Pair item) {
        if (item.getId() == null) {
            throw new UnexpectedException("Item with null id can not be updated");
        }
        Firebase firebase = this.createFirebase();
        firebase = firebase.child(item.getId());
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.setValue((Object)item.getValue(), (Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug("Updated object in database: " + item);
    }

    public List<Pair> getByField(String fieldName, Object ... values) {
        throw new UnsupportedOperationException();
    }

    public Pair getItemByField(String fieldName, Object ... values) {
        throw new UnsupportedOperationException();
    }

    public List<Pair> getAll() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        ArrayList results = Lists.newArrayList();
        for (DataSnapshot eachSnapshot : listener.getDataSnapshot().getChildren()) {
            Pair pair = new Pair();
            pair.setId(eachSnapshot.getKey());
            pair.setValue((String)eachSnapshot.getValue(String.class));
            results.add(pair);
        }
        LOGGER.debug("Retrieved all objects [" + results.size() + "] from path: " + this.getPath());
        return results;
    }

    public List<Pair> getByIds(List<String> ids) {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        ArrayList results = Lists.newArrayList();
        for (DataSnapshot eachSnapshot : listener.getDataSnapshot().getChildren()) {
            Pair pair = new Pair();
            pair.setId(eachSnapshot.getKey());
            pair.setValue((String)eachSnapshot.getValue(String.class));
            if (!ids.contains(pair.getId())) continue;
            results.add(pair);
        }
        LOGGER.debug("Retrieved all objects [" + results.size() + "] from path: " + this.getPath() + " and ids: " + ids);
        return results;
    }

    public void remove(Pair item) {
        this.remove(item.getId());
    }

    public void removeAll() {
        this.innerRemove(null);
    }

    public void removeAll(Collection<Pair> items) {
        for (Pair each : items) {
            this.remove(each);
        }
    }

    public void remove(String id) {
        if (id != null) {
            this.innerRemove(id);
        }
    }

    private void innerRemove(String id) {
        Firebase firebase = this.createFirebase();
        if (id != null) {
            firebase = firebase.child(id);
        }
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.removeValue((Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug("Deleted object in database: with id: " + id);
    }

    public Boolean isEmpty() {
        return this.getSize() == 0L;
    }

    public Long getSize() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        return listener.getDataSnapshot().getChildrenCount();
    }

    public void replaceAll(Collection<Pair> items) {
        for (Pair each : items) {
            this.update(each);
        }
    }

    public Pair getUniqueInstance() {
        List<Pair> results = this.getAll();
        if (!results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }
}

