/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.database;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.Query;
import com.firebase.client.ValueEventListener;
import com.jdroid.java.domain.Entity;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.database.FirebaseCompletionListener;
import com.jdroid.java.firebase.database.FirebaseValueEventListener;
import com.jdroid.java.firebase.database.auth.FirebaseAuthenticationStrategy;
import com.jdroid.java.repository.Repository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 ?*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\n\u0010 \u001a\u0004\u0018\u00010\nH\u0014J\u0018\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001d\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J/\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010&\u001a\u00020\u00102\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100$H\u0016J+\u0010-\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020\u00102\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0(\"\u00020)H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0016J\u000f\u00101\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0012\u00103\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u00104\u001a\u000205H\u0016J\u0017\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u00107\u001a\u000208H\u0002\u00a2\u0006\u0002\u00109J\u0015\u0010:\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010;\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010<\u001a\u00020\u0016H\u0016J\u0016\u0010<\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0016\u0010=\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0015\u0010>\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006@"}, d2={"Lcom/jdroid/java/firebase/database/FirebaseDatabaseRepository;", "T", "Lcom/jdroid/java/domain/Entity;", "Lcom/jdroid/java/repository/Repository;", "()V", "entityClass", "Ljava/lang/Class;", "getEntityClass", "()Ljava/lang/Class;", "firebaseAuthenticationStrategy", "Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy;", "getFirebaseAuthenticationStrategy", "()Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy;", "firebaseAuthenticationStrategy$delegate", "Lkotlin/Lazy;", "firebaseUrl", "", "getFirebaseUrl", "()Ljava/lang/String;", "path", "getPath", "add", "", "item", "(Lcom/jdroid/java/domain/Entity;)V", "addAll", "items", "", "addIdField", "id", "createFirebase", "Lcom/firebase/client/Firebase;", "createFirebaseAuthenticationStrategy", "get", "(Ljava/lang/String;)Lcom/jdroid/java/domain/Entity;", "getAll", "", "getByField", "fieldName", "values", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/List;", "getByIds", "ids", "getItemByField", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/jdroid/java/domain/Entity;", "getSize", "", "getUniqueInstance", "()Lcom/jdroid/java/domain/Entity;", "innerRemove", "isEmpty", "", "loadItem", "dataSnapshot", "Lcom/firebase/client/DataSnapshot;", "(Lcom/firebase/client/DataSnapshot;)Lcom/jdroid/java/domain/Entity;", "onItemLoaded", "remove", "removeAll", "replaceAll", "update", "Companion", "jdroid-java-firebase-database"})
public abstract class FirebaseDatabaseRepository<T extends Entity>
implements Repository<T> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy firebaseAuthenticationStrategy$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FirebaseAuthenticationStrategy>(this){
        final /* synthetic */ FirebaseDatabaseRepository this$0;

        @Nullable
        public final FirebaseAuthenticationStrategy invoke() {
            return this.this$0.createFirebaseAuthenticationStrategy();
        }
        {
            this.this$0 = firebaseDatabaseRepository;
            super(0);
        }
    }));
    private static final Logger LOGGER;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FirebaseDatabaseRepository.class), "firebaseAuthenticationStrategy", "getFirebaseAuthenticationStrategy()Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy;"))};
        Companion = new Companion(null);
        LOGGER = LoggerUtils.getLogger(FirebaseDatabaseRepository.class);
    }

    private final FirebaseAuthenticationStrategy getFirebaseAuthenticationStrategy() {
        Lazy lazy = this.firebaseAuthenticationStrategy$delegate;
        FirebaseDatabaseRepository firebaseDatabaseRepository = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (FirebaseAuthenticationStrategy)lazy.getValue();
    }

    @NotNull
    protected abstract String getFirebaseUrl();

    @NotNull
    protected abstract String getPath();

    @NotNull
    protected abstract Class<T> getEntityClass();

    @Nullable
    protected FirebaseAuthenticationStrategy createFirebaseAuthenticationStrategy() {
        return null;
    }

    @NotNull
    protected Firebase createFirebase() {
        Firebase firebase = new Firebase(this.getFirebaseUrl());
        if (firebase.getAuth() == null) {
            FirebaseAuthenticationStrategy firebaseAuthenticationStrategy2 = this.getFirebaseAuthenticationStrategy();
            if (firebaseAuthenticationStrategy2 != null) {
                firebaseAuthenticationStrategy2.authenticate(firebase);
            }
        }
        Firebase firebase2 = firebase.child(this.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(path)");
        firebase = firebase2;
        return firebase;
    }

    @Nullable
    public T get(@NotNull String id) {
        T item;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Firebase firebase = this.createFirebase();
        Firebase firebase2 = firebase.child(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(id)");
        firebase = firebase2;
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        if ((item = this.loadItem(dataSnapshot)) != null) {
            LOGGER.debug('[' + this.getPath() + "] Retrieved object from database: [" + item + ']');
        } else {
            LOGGER.debug('[' + this.getPath() + "] Object not found on database with id [" + id + ']');
        }
        return item;
    }

    public void add(@NotNull T item) {
        Firebase firebase;
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        Firebase firebase2 = this.createFirebase();
        if (item.getId() != null) {
            String string = item.getId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Firebase firebase3 = firebase2.child(string);
            firebase = firebase3;
            Intrinsics.checkExpressionValueIsNotNull((Object)firebase3, (String)"firebase.child(item.getId()!!)");
        } else {
            Firebase firebase4 = firebase2.push();
            firebase = firebase4;
            Intrinsics.checkExpressionValueIsNotNull((Object)firebase4, (String)"firebase.push()");
        }
        firebase2 = firebase;
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase2.setValue(item, (Firebase.CompletionListener)listener);
        listener.waitOperation();
        if (item.getId() == null) {
            String string = firebase2.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firebase.key");
            this.addIdField(string);
        }
        String string = firebase2.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"firebase.key");
        item.setId(string);
        LOGGER.debug('[' + this.getPath() + "] Stored object in database: " + item);
    }

    private final void addIdField(String id) {
        Firebase firebase = this.createFirebase();
        Firebase firebase2 = firebase.child(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(id)");
        firebase = firebase2;
        HashMap map = new HashMap();
        ((Map)map).put("id", id);
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.updateChildren((Map)map, (Firebase.CompletionListener)listener);
        listener.waitOperation();
    }

    public void addAll(@NotNull Collection<? extends T> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        for (Entity each : items) {
            this.add(each);
        }
    }

    public void update(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        if (item.getId() == null) {
            throw (Throwable)new UnexpectedException("Item with null id can not be updated");
        }
        Firebase firebase = this.createFirebase();
        String string = item.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Firebase firebase2 = firebase.child(string);
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase2.setValue(item, (Firebase.CompletionListener)listener);
        listener.waitOperation();
        Firebase firebase3 = firebase2;
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase3, (String)"firebase");
        String string2 = firebase3.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"firebase.key");
        item.setId(string2);
        LOGGER.debug('[' + this.getPath() + "] Updated object in database: " + item);
    }

    @NotNull
    public List<T> getByField(@NotNull String fieldName, Object ... values) {
        Query query;
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        Firebase firebase = this.createFirebase();
        Query query2 = firebase.orderByChild(fieldName);
        if (values.length > 1) {
            throw (Throwable)new UnexpectedException("Just one value is supported");
        }
        Object value = values[0];
        Object object = value;
        if (object instanceof String) {
            query = query2.equalTo((String)value);
        } else if (object instanceof Long) {
            query = query2.equalTo((double)((Number)value).longValue());
        } else if (object instanceof Double) {
            query = query2.equalTo(((Number)value).doubleValue());
        } else if (object instanceof Integer) {
            query = query2.equalTo((double)((Number)value).intValue());
        } else if (object instanceof Boolean) {
            query = query2.equalTo(((Boolean)value).booleanValue());
        } else {
            throw (Throwable)new UnexpectedException("Value type not supported");
        }
        query2 = query;
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        query2.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        boolean bl = false;
        List results = new ArrayList();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Iterator iterator = dataSnapshot.getChildren().iterator();
        while (iterator.hasNext()) {
            T t;
            DataSnapshot eachSnapshot;
            DataSnapshot dataSnapshot2 = eachSnapshot = (DataSnapshot)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSnapshot2, (String)"eachSnapshot");
            if (this.loadItem(dataSnapshot2) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            T it = t;
            boolean bl4 = false;
            results.add(it);
        }
        LOGGER.debug("[" + this.getPath() + "] Retrieved objects [" + results.size() + "] from database with field [" + fieldName + "], value [" + value + "]");
        return results;
    }

    @NotNull
    public List<T> getAll() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        boolean bl = false;
        List results = new ArrayList();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Iterator iterator = dataSnapshot.getChildren().iterator();
        while (iterator.hasNext()) {
            T t;
            DataSnapshot eachSnapshot;
            DataSnapshot dataSnapshot2 = eachSnapshot = (DataSnapshot)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSnapshot2, (String)"eachSnapshot");
            if (this.loadItem(dataSnapshot2) == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            T it = t;
            boolean bl4 = false;
            results.add(it);
        }
        LOGGER.debug("[" + this.getPath() + "] Retrieved all objects [" + results.size() + "]");
        return results;
    }

    @NotNull
    public List<T> getByIds(@NotNull List<String> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        boolean bl = false;
        List results = new ArrayList();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        Iterator iterator = dataSnapshot.getChildren().iterator();
        while (iterator.hasNext()) {
            DataSnapshot eachSnapshot;
            DataSnapshot dataSnapshot2 = eachSnapshot = (DataSnapshot)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSnapshot2, (String)"eachSnapshot");
            T each = this.loadItem(dataSnapshot2);
            if (each == null || !CollectionsKt.contains((Iterable)ids, (Object)each.getId())) continue;
            results.add(each);
        }
        LOGGER.debug("[" + this.getPath() + "] Retrieved all objects [" + results.size() + "] with ids: " + ids);
        return results;
    }

    private final T loadItem(DataSnapshot dataSnapshot) {
        Entity item = (Entity)dataSnapshot.getValue(this.getEntityClass());
        if (item != null) {
            this.onItemLoaded(item);
        }
        return (T)item;
    }

    protected void onItemLoaded(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
    }

    @Nullable
    public T getItemByField(@NotNull String fieldName, Object ... values) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        List<T> items = this.getByField(fieldName, Arrays.copyOf(values, values.length));
        Collection collection = items;
        boolean bl = false;
        return (T)(!collection.isEmpty() ? (Entity)items.get(0) : null);
    }

    public void remove(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        String string = item.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.remove(string);
    }

    public void removeAll() {
        this.innerRemove(null);
    }

    public void removeAll(@NotNull Collection<? extends T> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        for (Entity each : items) {
            this.remove(each);
        }
    }

    public void remove(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.innerRemove(id);
    }

    private final void innerRemove(String id) {
        Firebase firebase = this.createFirebase();
        if (id != null) {
            Firebase firebase2 = firebase.child(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(id)");
            firebase = firebase2;
        }
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.removeValue((Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug('[' + this.getPath() + "] Deleted object in database with id: " + id);
    }

    public boolean isEmpty() {
        return Long.valueOf(this.getSize()).equals(0);
    }

    public long getSize() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        return dataSnapshot.getChildrenCount();
    }

    public void replaceAll(@NotNull Collection<? extends T> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        this.removeAll();
        this.addAll(items);
    }

    @Nullable
    public T getUniqueInstance() {
        List<T> results = this.getAll();
        Collection collection = results;
        boolean bl = false;
        return (T)(!collection.isEmpty() ? (Entity)results.get(0) : null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jdroid/java/firebase/database/FirebaseDatabaseRepository$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jdroid-java-firebase-database"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

