/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.database;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.ValueEventListener;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.database.FirebaseCompletionListener;
import com.jdroid.java.firebase.database.FirebaseValueEventListener;
import com.jdroid.java.firebase.database.auth.FirebaseAuthenticationStrategy;
import com.jdroid.java.repository.Pair;
import com.jdroid.java.repository.PairRepository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0004H\u0014J\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J/\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u001a\u001a\u00020\u00062\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u0018H\u0016J+\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u00062\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\"\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010&\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020\fH\u0016J\u0016\u0010*\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\u0016\u0010+\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\u0010\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006."}, d2={"Lcom/jdroid/java/firebase/database/PairFirebaseRepository;", "Lcom/jdroid/java/repository/PairRepository;", "()V", "firebaseAuthenticationStrategy", "Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy;", "firebaseUrl", "", "getFirebaseUrl", "()Ljava/lang/String;", "path", "getPath", "add", "", "item", "Lcom/jdroid/java/repository/Pair;", "addAll", "items", "", "createFirebase", "Lcom/firebase/client/Firebase;", "createFirebaseAuthenticationStrategy", "get", "id", "getAll", "", "getByField", "fieldName", "values", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/util/List;", "getByIds", "ids", "getItemByField", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/jdroid/java/repository/Pair;", "getSize", "", "getUniqueInstance", "innerRemove", "isEmpty", "", "remove", "removeAll", "replaceAll", "update", "Companion", "jdroid-java-firebase-database"})
public abstract class PairFirebaseRepository
implements PairRepository {
    private final FirebaseAuthenticationStrategy firebaseAuthenticationStrategy = this.createFirebaseAuthenticationStrategy();
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    protected abstract String getFirebaseUrl();

    @NotNull
    protected abstract String getPath();

    @Nullable
    protected FirebaseAuthenticationStrategy createFirebaseAuthenticationStrategy() {
        return null;
    }

    @NotNull
    protected Firebase createFirebase() {
        Firebase firebase = new Firebase(this.getFirebaseUrl());
        if (this.firebaseAuthenticationStrategy != null && firebase.getAuth() == null) {
            this.firebaseAuthenticationStrategy.authenticate(firebase);
        }
        Firebase firebase2 = firebase.child(this.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(path)");
        firebase = firebase2;
        return firebase;
    }

    @Nullable
    public Pair get(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Firebase firebase = this.createFirebase();
        Firebase firebase2 = firebase.child(id);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(id)");
        firebase = firebase2;
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        String result = (String)dataSnapshot.getValue(String.class);
        Pair pair = null;
        if (result != null) {
            pair = new Pair();
            pair.setId(id);
            pair.setValue(result);
            LOGGER.debug("Retrieved object from database with path [ " + this.getPath() + "]. [ " + result + " ]");
        } else {
            LOGGER.debug("Object not found on database with path [ " + this.getPath() + " ] and id [ " + id + " ]");
        }
        return pair;
    }

    public void add(@NotNull Pair item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Firebase firebase = this.createFirebase();
        String string = item.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Firebase firebase2 = firebase.child(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(item.getId()!!)");
        firebase = firebase2;
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.setValue((Object)item.getValue(), (Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug("Stored object in database: " + item);
    }

    public void addAll(@NotNull Collection<Pair> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        for (Pair each : items) {
            this.add(each);
        }
    }

    public void update(@NotNull Pair item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (item.getId() == null) {
            throw (Throwable)new UnexpectedException("Item with null id can not be updated");
        }
        Firebase firebase = this.createFirebase();
        String string = item.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Firebase firebase2 = firebase.child(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(item.getId()!!)");
        firebase = firebase2;
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.setValue((Object)item.getValue(), (Firebase.CompletionListener)listener);
        listener.waitOperation();
        LOGGER.debug("Updated object in database: " + item);
    }

    @NotNull
    public List<Pair> getByField(@NotNull String fieldName, Object ... values) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Nullable
    public Pair getItemByField(@NotNull String fieldName, Object ... values) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public List<Pair> getAll() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        boolean bl = false;
        List results = new ArrayList();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        for (DataSnapshot eachSnapshot : dataSnapshot.getChildren()) {
            Pair pair = new Pair();
            DataSnapshot dataSnapshot2 = eachSnapshot;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSnapshot2, (String)"eachSnapshot");
            String string = dataSnapshot2.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"eachSnapshot.key");
            pair.setId(string);
            pair.setValue((String)eachSnapshot.getValue(String.class));
            results.add(pair);
        }
        LOGGER.debug("Retrieved all objects [" + results.size() + "] from path: " + this.getPath());
        return results;
    }

    @NotNull
    public List<Pair> getByIds(@NotNull List<String> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        boolean bl = false;
        List results = new ArrayList();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        for (DataSnapshot eachSnapshot : dataSnapshot.getChildren()) {
            Pair pair = new Pair();
            DataSnapshot dataSnapshot2 = eachSnapshot;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataSnapshot2, (String)"eachSnapshot");
            String string = dataSnapshot2.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"eachSnapshot.key");
            pair.setId(string);
            pair.setValue((String)eachSnapshot.getValue(String.class));
            if (!CollectionsKt.contains((Iterable)ids, (Object)pair.getId())) continue;
            results.add(pair);
        }
        LOGGER.debug("Retrieved all objects [" + results.size() + "] from path: " + this.getPath() + " and ids: " + ids);
        return results;
    }

    public void remove(@NotNull Pair item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        String string = item.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.remove(string);
    }

    public void removeAll() {
        this.innerRemove(null);
    }

    public void removeAll(@NotNull Collection<Pair> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        for (Pair each : items) {
            this.remove(each);
        }
    }

    public void remove(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.innerRemove(id);
    }

    private final void innerRemove(String id) {
        Firebase firebase = this.createFirebase();
        if (id != null) {
            Firebase firebase2 = firebase.child(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)firebase2, (String)"firebase.child(id)");
            firebase = firebase2;
        }
        FirebaseCompletionListener listener = new FirebaseCompletionListener();
        firebase.removeValue((Firebase.CompletionListener)listener);
        listener.waitOperation();
        StringBuilder stringBuilder = new StringBuilder().append("Deleted object in database: with id: ");
        String string = id;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        LOGGER.debug(stringBuilder.append(string).toString());
    }

    public boolean isEmpty() {
        return Long.valueOf(this.getSize()).equals(0);
    }

    public long getSize() {
        Firebase firebase = this.createFirebase();
        FirebaseValueEventListener listener = new FirebaseValueEventListener();
        firebase.addListenerForSingleValueEvent((ValueEventListener)listener);
        listener.waitOperation();
        DataSnapshot dataSnapshot = listener.getDataSnapshot();
        if (dataSnapshot == null) {
            Intrinsics.throwNpe();
        }
        return dataSnapshot.getChildrenCount();
    }

    public void replaceAll(@NotNull Collection<Pair> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        for (Pair each : items) {
            this.update(each);
        }
    }

    @Nullable
    public Pair getUniqueInstance() {
        List<Pair> results = this.getAll();
        Collection collection = results;
        boolean bl = false;
        return !collection.isEmpty() ? results.get(0) : null;
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerUtils.getLogger(PairFirebaseRepository.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jdroid/java/firebase/database/PairFirebaseRepository$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jdroid-java-firebase-database"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

