/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.java.firebase.database.auth;

import com.firebase.client.AuthData;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.FirebaseException;
import com.jdroid.java.exception.UnexpectedException;
import com.jdroid.java.firebase.database.FirebaseDatabaseRepository;
import com.jdroid.java.utils.LoggerUtils;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH$J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy;", "Lcom/firebase/client/Firebase$AuthResultHandler;", "()V", "<set-?>", "Ljava/util/concurrent/CountDownLatch;", "countDownLatch", "getCountDownLatch", "()Ljava/util/concurrent/CountDownLatch;", "authenticate", "", "firebase", "Lcom/firebase/client/Firebase;", "doAuthenticate", "doOnAuthenticated", "authData", "Lcom/firebase/client/AuthData;", "doOnAuthenticationError", "error", "Lcom/firebase/client/FirebaseError;", "onAuthenticated", "onAuthenticationError", "Companion", "jdroid-java-firebase-database"})
public abstract class FirebaseAuthenticationStrategy
implements Firebase.AuthResultHandler {
    @NotNull
    private CountDownLatch countDownLatch;
    private static final Logger LOGGER;
    public static final Companion Companion;

    @NotNull
    public final CountDownLatch getCountDownLatch() {
        CountDownLatch countDownLatch = this.countDownLatch;
        if (countDownLatch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countDownLatch");
        }
        return countDownLatch;
    }

    public final void authenticate(@NotNull Firebase firebase) {
        Intrinsics.checkParameterIsNotNull((Object)firebase, (String)"firebase");
        this.countDownLatch = new CountDownLatch(1);
        this.doAuthenticate(firebase);
        try {
            CountDownLatch countDownLatch = this.countDownLatch;
            if (countDownLatch == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"countDownLatch");
            }
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw (Throwable)new UnexpectedException((Throwable)e);
        }
    }

    protected abstract void doAuthenticate(@NotNull Firebase var1);

    protected final void doOnAuthenticationError(@NotNull FirebaseError error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        FirebaseException firebaseException = error.toException();
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseException, (String)"error.toException()");
        throw (Throwable)firebaseException;
    }

    protected final void doOnAuthenticated(@NotNull AuthData authData) {
        Intrinsics.checkParameterIsNotNull((Object)authData, (String)"authData");
    }

    public void onAuthenticationError(@NotNull FirebaseError error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        CountDownLatch countDownLatch = this.countDownLatch;
        if (countDownLatch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countDownLatch");
        }
        countDownLatch.countDown();
        this.doOnAuthenticationError(error);
    }

    public void onAuthenticated(@NotNull AuthData authData) {
        Intrinsics.checkParameterIsNotNull((Object)authData, (String)"authData");
        CountDownLatch countDownLatch = this.countDownLatch;
        if (countDownLatch == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"countDownLatch");
        }
        countDownLatch.countDown();
        LOGGER.info("Firebase authenticated. " + authData);
        this.doOnAuthenticated(authData);
    }

    static {
        Companion = new Companion(null);
        LOGGER = LoggerUtils.getLogger(FirebaseDatabaseRepository.class);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jdroid/java/firebase/database/auth/FirebaseAuthenticationStrategy$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "jdroid-java-firebase-database"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

