/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.generator;

import com.jfinal.kit.Kv;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.generator.TableMeta;
import com.jfinal.template.Engine;
import com.jfinal.template.source.ClassPathSourceFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;

public class MappingKitGenerator {
    protected String template = "/com/jfinal/plugin/activerecord/generator/mapping_kit_template.jf";
    protected String mappingKitPackageName;
    protected String mappingKitOutputDir;
    protected String mappingKitClassName = "_MappingKit";

    public MappingKitGenerator(String mappingKitPackageName, String mappingKitOutputDir) {
        this.mappingKitPackageName = mappingKitPackageName;
        this.mappingKitOutputDir = mappingKitOutputDir;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setMappingKitOutputDir(String mappingKitOutputDir) {
        if (StrKit.notBlank(mappingKitOutputDir)) {
            this.mappingKitOutputDir = mappingKitOutputDir;
        }
    }

    public void setMappingKitPackageName(String mappingKitPackageName) {
        if (StrKit.notBlank(mappingKitPackageName)) {
            this.mappingKitPackageName = mappingKitPackageName;
        }
    }

    public void setMappingKitClassName(String mappingKitClassName) {
        if (StrKit.notBlank(mappingKitClassName)) {
            this.mappingKitClassName = StrKit.firstCharToUpperCase(mappingKitClassName);
        }
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate MappingKit file ...");
        System.out.println("MappingKit Output Dir: " + this.mappingKitOutputDir);
        Engine engine = Engine.create("forMappingKit");
        engine.setSourceFactory(new ClassPathSourceFactory());
        engine.addSharedMethod(new StrKit());
        Kv data = Kv.by("mappingKitPackageName", this.mappingKitPackageName);
        data.set("mappingKitClassName", this.mappingKitClassName);
        data.set("tableMetas", tableMetas);
        String ret = engine.getTemplate(this.template).renderToString(data);
        this.writeToFile(ret);
    }

    protected void writeToFile(String ret) {
        OutputStreamWriter fw = null;
        try {
            File dir = new File(this.mappingKitOutputDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String target = this.mappingKitOutputDir + File.separator + this.mappingKitClassName + ".java";
            fw = new FileWriter(target);
            fw.write(ret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    LogKit.error(e.getMessage(), e);
                }
            }
        }
    }
}

