/*
 * Decompiled with CFR 0.152.
 */
package com.jnericks.testlib;

import com.google.common.reflect.TypeToken;
import com.jnericks.testlib.Dependency;
import com.jnericks.testlib.DoForDependencies;
import com.jnericks.testlib.DoForDependency;
import com.jnericks.testlib.TestUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SystemUnderTestFactory<TSut> {
    private final TypeToken<TSut> _typeToken;
    private volatile Constructor<?> _ctor;
    private List<Dependency> _dependencies;
    private TSut _sut;
    private Runnable _preProcessor = () -> {};
    private Consumer<TSut> _postProcessor = sut -> {};
    private Supplier<TSut> _sutFactory = () -> {
        try {
            return this._ctor.newInstance(this._dependencies.stream().map(Dependency::get).toArray());
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    };

    public SystemUnderTestFactory(Class<TSut> type) {
        Type[] parameterTypes;
        this._typeToken = TypeToken.of(type);
        this._dependencies = new ArrayList<Dependency>();
        this._ctor = TestUtils.getGreediestCtor(this._typeToken);
        for (Type t : parameterTypes = this._ctor.getGenericParameterTypes()) {
            TypeToken parameterTypeToken = TypeToken.of((Type)t);
            this._dependencies.add(new Dependency(parameterTypeToken));
        }
    }

    public void createSutUsing(Supplier<TSut> sutFactory) {
        this._sutFactory = sutFactory;
    }

    public void beforeSutCreated(Runnable preProcessor) {
        this._preProcessor = preProcessor;
    }

    public void afterSutCreated(Consumer<TSut> postProcessor) {
        this._postProcessor = postProcessor;
    }

    public void createSut() {
        if (this._sut != null) {
            return;
        }
        this._preProcessor.run();
        this._sut = this._sutFactory.get();
        this._postProcessor.accept(this._sut);
    }

    public TSut sut() {
        this.createSut();
        return this._sut;
    }

    public <TDependency> TDependency dependency(Class<TDependency> type) {
        for (Dependency d : this._dependencies) {
            if (!d.typeToken.isSubtypeOf(type)) continue;
            return (TDependency)d.get();
        }
        throw new UnsupportedOperationException(String.format("%s is not a dependency of %s", type.getSimpleName(), this._typeToken.getRawType().getSimpleName()));
    }

    public <TDependency> TDependency dependency(TypeToken<TDependency> typeToken) {
        for (Dependency d : this._dependencies) {
            if (!d.typeToken.equals(typeToken)) continue;
            return (TDependency)d.get();
        }
        throw new UnsupportedOperationException(String.format("%s is not a dependency of %s", typeToken.getRawType().getSimpleName(), this._typeToken.getRawType().getSimpleName()));
    }

    public <TDependency> DoForDependency<TDependency> forDependency(Class<TDependency> type) {
        return this.forDependency(TypeToken.of(type));
    }

    public <TDependency> DoForDependency<TDependency> forDependency(TypeToken<TDependency> typeToken) {
        List<Dependency> dependencies = this._dependencies.stream().filter(x -> x.typeToken.equals((Object)typeToken)).collect(Collectors.toList());
        if (dependencies.size() > 0) {
            return new DoForDependency(dependencies);
        }
        throw new UnsupportedOperationException(String.format("%s is not a dependency of %s", typeToken.getRawType().getSimpleName(), this._typeToken.getRawType().getSimpleName()));
    }

    public <TDependency> DoForDependencies<TDependency> forDependencies(Class<TDependency> type) {
        return this.forDependencies(TypeToken.of(type));
    }

    public <TDependency> DoForDependencies<TDependency> forDependencies(TypeToken<TDependency> typeToken) {
        List<Dependency> dependencies = this._dependencies.stream().filter(x -> x.typeToken.equals((Object)typeToken)).collect(Collectors.toList());
        if (dependencies.size() > 0) {
            return new DoForDependencies(dependencies);
        }
        throw new UnsupportedOperationException(String.format("%s is not a dependency of %s", typeToken.getRawType().getSimpleName(), this._typeToken.getRawType().getSimpleName()));
    }
}

