/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.crud;

import com.jpattern.logger.ILogger;
import com.jpattern.orm.crud.AColumnValueGenerator;
import com.jpattern.orm.crud.IOrmCRUDQuery;
import com.jpattern.orm.crud.IOrmCRUDQueryGenerator;
import com.jpattern.orm.crud.OrmCRUDQuery;
import com.jpattern.orm.dialect.IDialect;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.mapper.IClassMapper;
import java.util.ArrayList;
import java.util.List;

public class OrmCRUDQueryGenerator<T>
implements IOrmCRUDQueryGenerator<T> {
    private final IClassMapper<T> classMapper;
    private boolean generatedKey = false;
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
    private final IDialect dialect;

    public OrmCRUDQueryGenerator(IDialect dialect, IClassMapper<T> classMapper) {
        this.dialect = dialect;
        this.classMapper = classMapper;
    }

    @Override
    public IOrmCRUDQuery generate() {
        String deleteQuery = this.generateDeleteQuery();
        String loadQuery = this.generateLoadQuery();
        String saveQuery = this.generateSaveQuery();
        String updateQuery = this.generateUpdateQuery();
        String baseSelectClause = this.generateBaseSelectClause();
        String baseFromClause = this.generateBaseFromClause();
        return new OrmCRUDQuery(deleteQuery, loadQuery, saveQuery, updateQuery, baseSelectClause, baseFromClause, this.generatedKey);
    }

    private String generateBaseFromClause() {
        return this.classMapper.getTableMap().getTableNameWithSchema();
    }

    private String generateBaseSelectClause() {
        return this.columnToCommaSepareted(this.getColumnNames(this.classMapper, "?", this.classMapper.getAllColumnJavaNames()));
    }

    private String generateUpdateQuery() {
        StringBuilder builder = new StringBuilder("UPDATE ");
        builder.append(this.classMapper.getTableMap().getTableNameWithSchema());
        builder.append(" SET ");
        if (this.classMapper.getNotPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(this.columnToSetClause(this.getColumnNames(this.classMapper, "", this.classMapper.getNotPrimaryKeyColumnJavaNames())));
        }
        if (this.classMapper.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMapper, "", this.classMapper.getPrimaryKeyColumnJavaNames())));
        }
        String query = builder.toString();
        this.logger.info("generateUpdateQuery", "Generated UPDATE query for table [" + this.classMapper.getTableMap().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateSaveQuery() {
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        builder.append(this.classMapper.getTableMap().getTableNameWithSchema());
        builder.append(" (");
        builder.append(this.columnToCommaSepareted(this.getColumnNames(this.classMapper, "", this.classMapper.getAllColumnJavaNames())));
        builder.append(") VALUES (");
        builder.append(this.questionCommaSepareted(this.classMapper, this.getColumnNames(this.classMapper, "", this.classMapper.getAllColumnJavaNames())));
        builder.append(")");
        String query = builder.toString();
        this.logger.info("generateSaveQuery", "Generated INSERT query for table [" + this.classMapper.getTableMap().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateLoadQuery() {
        StringBuilder builder = new StringBuilder("SELECT * FROM ");
        builder.append(this.classMapper.getTableMap().getTableNameWithSchema());
        if (this.classMapper.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMapper, "", this.classMapper.getPrimaryKeyColumnJavaNames())));
        }
        String query = builder.toString();
        this.logger.info("generateLoadQuery", "Generated SELECT query for table [" + this.classMapper.getTableMap().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String generateDeleteQuery() {
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(this.classMapper.getTableMap().getTableNameWithSchema());
        if (this.classMapper.getPrimaryKeyColumnJavaNames().length > 0) {
            builder.append(" WHERE ");
            builder.append(this.columnToWhereClause(this.getColumnNames(this.classMapper, "", this.classMapper.getPrimaryKeyColumnJavaNames())));
        }
        String query = builder.toString();
        this.logger.info("generateDeleteQuery", "Generated DELETE query for table [" + this.classMapper.getTableMap().getTableNameWithSchema() + "]:\n" + query);
        return query;
    }

    private String questionCommaSepareted(IClassMapper<T> classMapper, List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                AColumnValueGenerator columnValueGenerator = classMapper.getTableMap().getGeneratorByColumnName(columnNames.get(i));
                this.generatedKey = this.generatedKey || columnValueGenerator.isAutoGenerated();
                builder.append(columnValueGenerator.insertQueryParameter(this.dialect, "?"));
                builder.append(", ");
            }
            AColumnValueGenerator columnValueGenerator = classMapper.getTableMap().getGeneratorByColumnName(columnNames.get(length - 1));
            this.generatedKey = this.generatedKey || columnValueGenerator.isAutoGenerated();
            builder.append(columnValueGenerator.insertQueryParameter(this.dialect, "?"));
        }
        return builder.toString();
    }

    private String columnToCommaSepareted(List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                builder.append(columnNames.get(i) + ", ");
            }
            builder.append(columnNames.get(length - 1));
        }
        return builder.toString();
    }

    private String columnToWhereClause(List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                builder.append(columnNames.get(i) + " = ? AND ");
            }
            builder.append(columnNames.get(length - 1) + " = ? ");
        }
        return builder.toString();
    }

    private String columnToSetClause(List<String> columnNames) {
        StringBuilder builder = new StringBuilder();
        int length = columnNames.size();
        if (length > 0) {
            for (int i = 0; i < length - 1; ++i) {
                builder.append(columnNames.get(i) + " = ? , ");
            }
            builder.append(columnNames.get(length - 1) + " = ? ");
        }
        return builder.toString();
    }

    private List<String> getColumnNames(IClassMapper<?> classMapper, String rowNamePrefix, String[] javaNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String javaName : javaNames) {
            result.add(rowNamePrefix + classMapper.getColumnWithJavaName(javaName).getName());
        }
        return result;
    }
}

