/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.mapper;

import com.jpattern.logger.ILogger;
import com.jpattern.orm.logger.OrmLogger;
import com.jpattern.orm.mapper.ClassMapper;
import com.jpattern.orm.mapper.Column;
import com.jpattern.orm.mapper.IClassMapper;
import com.jpattern.orm.mapper.IClassMapperBuilder;
import com.jpattern.orm.mapper.IColumn;
import com.jpattern.orm.mapper.ITableMap;
import com.jpattern.orm.util.FieldDefaultNaming;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassMapperBuilder<T>
implements IClassMapperBuilder<T> {
    private final Class<T> clazz;
    private ILogger logger = OrmLogger.getOrmLogger(this.getClass());
    private final ITableMap tableMap;

    public ClassMapperBuilder(Class<T> clazz, ITableMap tableMap) {
        this.clazz = clazz;
        this.tableMap = tableMap;
    }

    @Override
    public IClassMapper<T> generate() {
        this.logger.info("generate", "generate " + IClassMapper.class.getSimpleName() + " for Class " + this.clazz.getName());
        String tableName = this.tableMap.getTableNameWithSchema();
        String schemaName = this.tableMap.getSchemaName();
        this.logger.info("generate", "table name expected in relation with class " + this.clazz.getSimpleName() + ": " + tableName + " - schema: " + schemaName);
        Map<String, IColumn> fieldColumnMapping = this.mapField(schemaName, tableName);
        ClassMapper<T> classMapper = new ClassMapper<T>(this.clazz, this.tableMap, fieldColumnMapping);
        this.initializeColumnNames(classMapper, fieldColumnMapping);
        return classMapper;
    }

    private Map<String, IColumn> mapField(String schemaName, String tableName) {
        LinkedHashMap<String, IColumn> result = new LinkedHashMap<String, IColumn>();
        Column col = null;
        for (String fieldName : this.tableMap.getAllFieldNames()) {
            if (fieldName.length() > 0) {
                String columnName = this.tableMap.getDBColumnName(fieldName);
                this.logger.info("exploreAllColumns", "DB column [" + columnName + "]" + " will be associated with object field [" + fieldName + "]");
                col = new Column(columnName);
                col.setIdentifying(this.tableMap.getPrimaryKeyFieldNames().contains(fieldName));
                this.setGetterSetter(fieldName, col);
                result.put(fieldName, col);
                continue;
            }
            this.logger.warn("exploreAllColumns", "Class fiels [" + fieldName + "]" + " is NOT associated with a DB colunm!");
        }
        return result;
    }

    private void setGetterSetter(String javaPropertyName, Column col) {
        List<Method> methods = Arrays.asList(this.clazz.getMethods());
        List<Field> fields = Arrays.asList(this.clazz.getDeclaredFields());
        Field propertyField = null;
        Method getter = null;
        Method setter = null;
        String fieldName = "";
        String getterName = "";
        String setterName = "";
        for (Field field : fields) {
            if (!javaPropertyName.equals(field.getName())) continue;
            propertyField = field;
            fieldName = field.getName();
        }
        for (Method method : methods) {
            if (FieldDefaultNaming.getDefaultGetterName(javaPropertyName).equals(method.getName())) {
                getter = method;
                getterName = method.getName();
            }
            if (FieldDefaultNaming.getDefaultBooleanGetterName(javaPropertyName).equals(method.getName())) {
                getter = method;
                getterName = method.getName();
            }
            if (!FieldDefaultNaming.getDefaultSetterName(javaPropertyName).equals(method.getName())) continue;
            setter = method;
            setterName = method.getName();
        }
        this.logger.info("setGetterSetter", "property [" + fieldName + "] associated with column [" + col.getName() + "]");
        this.logger.info("setGetterSetter", "getter for property [" + fieldName + "]: [" + getterName + "]");
        this.logger.info("setGetterSetter", "setter for property [" + fieldName + "]: [" + setterName + "]");
        col.setField(propertyField);
        col.setSetter(setter);
        col.setGetter(getter);
    }

    private void initializeColumnNames(ClassMapper<T> generated, Map<String, IColumn> fieldColumnMapping) {
        this.logger.info("initializeColumnNames", "");
        ArrayList<String> allColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allNotGeneratedColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allGeneratedColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> allGeneratedColumnDBNamesList = new ArrayList<String>();
        ArrayList<String> primaryKeyColumnJavaNamesList = new ArrayList<String>();
        ArrayList<String> notPrimaryKeyColumnJavaList = new ArrayList<String>();
        for (Map.Entry<String, IColumn> entry : fieldColumnMapping.entrySet()) {
            String javaFieldName = entry.getKey();
            allColumnJavaNamesList.add(javaFieldName);
            if (entry.getValue().isIdentifying()) {
                primaryKeyColumnJavaNamesList.add(javaFieldName);
                this.logger.info("initializeColumnNames", "Field [" + javaFieldName + "] will be used as a Primary Key field");
            } else {
                notPrimaryKeyColumnJavaList.add(javaFieldName);
                this.logger.info("initializeColumnNames", "Field [" + javaFieldName + "] will be used as a normal field");
            }
            if (this.tableMap.getGeneratorByJavaFieldName(javaFieldName).isAutoGenerated()) {
                allGeneratedColumnJavaNamesList.add(javaFieldName);
                allGeneratedColumnDBNamesList.add(entry.getValue().getName());
                this.logger.info("initializeColumnNames", "Field [" + javaFieldName + "] is an autogenerated field");
                continue;
            }
            allNotGeneratedColumnJavaNamesList.add(javaFieldName);
        }
        generated.setAllColumnJavaNames(allColumnJavaNamesList.toArray(new String[0]));
        generated.setAllNotGeneratedColumnJavaNames(allNotGeneratedColumnJavaNamesList.toArray(new String[0]));
        generated.setAllGeneratedColumnJavaNames(allGeneratedColumnJavaNamesList.toArray(new String[0]));
        generated.setAllGeneratedColumnDBNames(allGeneratedColumnDBNamesList.toArray(new String[0]));
        generated.setNotPrimaryKeyColumnJavaNames(notPrimaryKeyColumnJavaList.toArray(new String[0]));
        generated.setPrimaryKeyColumnJavaNames(primaryKeyColumnJavaNamesList.toArray(new String[0]));
        generated.setNotPrimaryKeyColumnJavaNames(notPrimaryKeyColumnJavaList.toArray(new String[0]));
    }
}

