/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.query.ABaseOrmQuery;
import com.jpattern.orm.query.INameSolver;
import com.jpattern.orm.query.INameSolverConsumer;
import com.jpattern.orm.query.IOrmCustomQuery;
import com.jpattern.orm.query.ISelectClause;
import com.jpattern.orm.query.Join;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SelectClause;
import com.jpattern.orm.session.IResultSetReader;
import com.jpattern.orm.session.ISessionSqlPerformer;
import com.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class OrmCustomQuery
extends ABaseOrmQuery
implements IOrmCustomQuery,
INameSolverConsumer {
    private INameSolver nameSolver = new NullNameSolver();
    private final ISelectClause select;
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<?> clazz;
    private final Class<?>[] joinClasses;
    private final ISessionSqlPerformer session;
    private int queryTimeout = 0;
    private int maxRows = 0;

    public OrmCustomQuery(String selectClause, IOrmClassToolMap ormClassToolMap, ISessionSqlPerformer session, Class<?> clazz, Class<?> ... joinClasses) {
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.clazz = clazz;
        this.joinClasses = joinClasses;
        this.setJoin(new Join(ormClassToolMap));
        this.select = new SelectClause(selectClause);
    }

    @Override
    public void setNameSolver(INameSolver nameSolver) {
        this.nameSolver = nameSolver;
        this.where().setNameSolver(nameSolver);
        this.orderBy().setNameSolver(nameSolver);
        this.join().setNameSolver(nameSolver);
        this.select.setNameSolver(nameSolver);
    }

    @Override
    public List<Object[]> findList() {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForList(this.renderSql(), values.toArray());
    }

    @Override
    public Object[] findUnique() throws OrmNotUniqueResultException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForArray(this.renderSql(), values.toArray());
    }

    @Override
    protected void renderSelect(StringBuilder StringBuilder2) {
        this.select.renderSql(StringBuilder2);
    }

    @Override
    protected void renderFrom(StringBuilder StringBuilder2) {
        String alias = this.nameSolver.alias(this.clazz);
        StringBuilder2.append("FROM ");
        StringBuilder2.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMapper().getTableMap().getTableNameWithSchema());
        StringBuilder2.append(" ");
        StringBuilder2.append(alias);
        StringBuilder2.append(" ");
        this.join().renderSql(StringBuilder2);
        if (this.joinClasses != null && this.joinClasses.length > 0) {
            for (Class<?> joinClass : this.joinClasses) {
                StringBuilder2.append(", ");
                StringBuilder2.append(this.ormClassToolMap.getOrmClassTool(joinClass).getClassMapper().getTableMap().getTableNameWithSchema());
                StringBuilder2.append(" ");
                StringBuilder2.append(this.nameSolver.alias(joinClass));
            }
            StringBuilder2.append(" ");
        }
    }

    @Override
    protected void renderWhere(StringBuilder StringBuilder2) {
        this.where().renderSql(StringBuilder2);
    }

    @Override
    protected void renderOrderBy(StringBuilder StringBuilder2) {
        this.orderBy().renderSql(StringBuilder2);
    }

    @Override
    public <T> T find(IResultSetReader<T> rse) throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rse, values.toArray());
    }

    @Override
    public int findInt() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.renderSql(), values.toArray());
    }

    @Override
    public long findLong() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.renderSql(), values.toArray());
    }

    @Override
    public double findDouble() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForDouble(this.renderSql(), values.toArray());
    }

    @Override
    public float findFloat() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForFloat(this.renderSql(), values.toArray()).floatValue();
    }

    @Override
    public String findString() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForString(this.renderSql(), values.toArray());
    }

    @Override
    public boolean findBoolean() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBoolean(this.renderSql(), values.toArray());
    }

    @Override
    public BigDecimal findBigDecimal() throws OrmException {
        ArrayList<Object> values = new ArrayList<Object>();
        this.where().appendValues(values);
        ISqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBigDecimal(this.renderSql(), values.toArray());
    }

    @Override
    public final int getMaxRows() throws OrmException {
        return this.maxRows;
    }

    @Override
    public final IOrmCustomQuery setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final IOrmCustomQuery setMaxRows(int maxRows) throws OrmException {
        this.maxRows = maxRows;
        return this;
    }
}

