/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.session.IResultSetReader;
import com.jpattern.orm.session.ISqlPerformer;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ASqlPerformer
implements ISqlPerformer {
    @Override
    public final Integer queryForInt(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Integer> resultSetReader = new IResultSetReader<Integer>(){

            @Override
            public Integer read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    int result = resultSet.getInt(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Long queryForLong(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Long> resultSetReader = new IResultSetReader<Long>(){

            @Override
            public Long read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    long result = resultSet.getLong(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Double queryForDouble(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Double> resultSetReader = new IResultSetReader<Double>(){

            @Override
            public Double read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    double result = resultSet.getDouble(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Float queryForFloat(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Float> resultSetReader = new IResultSetReader<Float>(){

            @Override
            public Float read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    float result = resultSet.getFloat(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return Float.valueOf(result);
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final String queryForString(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<String> resultSetReader = new IResultSetReader<String>(){

            @Override
            public String read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    String result = resultSet.getString(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Boolean queryForBoolean(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Boolean> resultSetReader = new IResultSetReader<Boolean>(){

            @Override
            public Boolean read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    boolean result = resultSet.getBoolean(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final BigDecimal queryForBigDecimal(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<BigDecimal> resultSetReader = new IResultSetReader<BigDecimal>(){

            @Override
            public BigDecimal read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    BigDecimal result = resultSet.getBigDecimal(1);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final Object[] queryForArray(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        IResultSetReader<Object[]> resultSetReader = new IResultSetReader<Object[]>(){

            @Override
            public Object[] read(ResultSet resultSet) throws SQLException {
                int columnNumber = resultSet.getMetaData().getColumnCount();
                if (resultSet.next()) {
                    Object[] result = new Object[columnNumber];
                    for (int i = 0; i < columnNumber; ++i) {
                        result[i] = resultSet.getObject(i + 1);
                    }
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultException("The query execution returned a number of rows higher than 1");
                    }
                    return result;
                }
                return null;
            }
        };
        return this.query(sql, resultSetReader, values);
    }

    @Override
    public final List<Object[]> queryForList(String sql, Object ... values) throws OrmException {
        IResultSetReader<List<Object[]>> resultSetReader = new IResultSetReader<List<Object[]>>(){

            @Override
            public List<Object[]> read(ResultSet resultSet) throws SQLException {
                int columnNumber = resultSet.getMetaData().getColumnCount();
                ArrayList<Object[]> resultList = new ArrayList<Object[]>();
                while (resultSet.next()) {
                    Object[] objectArray = new Object[columnNumber];
                    for (int i = 0; i < columnNumber; ++i) {
                        objectArray[i] = resultSet.getObject(i + 1);
                    }
                    resultList.add(objectArray);
                }
                return resultList;
            }
        };
        return this.query(sql, resultSetReader, values);
    }
}

