/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.mapper.DBTableMapBuilder;
import com.jpattern.orm.mapper.ITableMap;
import com.jpattern.orm.session.ISession;
import com.jpattern.orm.session.ISessionProvider;
import com.jpattern.orm.session.datasource.DataSourceSession;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceSessionProvider
implements ISessionProvider {
    private final DataSource dataSource;

    public DataSourceSessionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public ISession getSession(IOrmClassToolMap ormClassToolMap) {
        return new DataSourceSession(this.dataSource, ormClassToolMap);
    }

    @Override
    public void updateTableMap(ITableMap tableMap, boolean enableDBScan) throws SQLException {
        new DBTableMapBuilder(this.dataSource, tableMap, enableDBScan).updateTableMap();
    }
}

