/*
 * Decompiled with CFR 0.152.
 */
package com.jssolo.utils;

import com.jssolo.utils.RuntimeExceptionOnly;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class TimeTool {
    public static List<String> splitTime(String dateType, String begin, String end, Integer space, boolean isAddEnd) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date beginD = null;
        Date endD = null;
        try {
            beginD = sdf.parse(begin);
            endD = sdf.parse(end);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> listDate = new ArrayList<String>();
        listDate.add(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(beginD));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(beginD);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endD);
        while (calEnd.after(calBegin)) {
            if ("M".equals(dateType)) {
                calBegin.add(2, space);
            }
            if ("D".equals(dateType)) {
                calBegin.add(5, space);
            }
            if ("H".equals(dateType)) {
                calBegin.add(10, space);
            }
            if ("N".equals(dateType)) {
                calBegin.add(12, space);
            }
            if (calEnd.after(calBegin)) {
                listDate.add(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(calBegin.getTime()));
                continue;
            }
            if (!isAddEnd) continue;
            listDate.add(new SimpleDateFormat("yyyy-MM-dd HH:mm").format(calEnd.getTime()));
        }
        return listDate;
    }

    public static Date dateAddDay(Date date, Integer dayNum) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, dayNum);
        return calendar.getTime();
    }

    public static Date dateAddHour(Date date, Integer hour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(11, hour);
        return calendar.getTime();
    }

    public static Boolean firstIsBig(Date first, Date last) {
        return first.after(last);
    }

    public static Boolean firstIsBigAddHour(Date first, Date last, Integer hour) {
        Date temp = TimeTool.dateAddHour(last, hour);
        return TimeTool.firstIsBig(first, temp);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static Date stringToDate(String dateStr, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeExceptionOnly("com.jssolo.utils.TimeTool.stringToDate()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static BigDecimal dateDiffMinutes(Date d1, Date d2) {
        long l = 60000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffMinutes(Date d1, Date d2, int i) {
        long l = 60000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, i, 4);
        return b3;
    }

    public static BigDecimal dateDiffHours(Date d1, Date d2) {
        long l = 3600000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffHours(Date d1, Date d2, int i) {
        long l = 3600000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, i, 4);
        return b3;
    }

    public static BigDecimal dateDiffDays(Date d1, Date d2) {
        long l = 86400000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffDays(Date d1, Date d2, int i) {
        long l = 86400000L;
        BigDecimal b3 = TimeTool.dateDiff(d1, d2, l, i, 4);
        return b3;
    }

    private static BigDecimal dateDiff(Date d1, Date d2, long l, int i1, int i2) {
        BigDecimal b1 = new BigDecimal(d1.getTime() - d2.getTime()).abs();
        BigDecimal b2 = new BigDecimal(l);
        BigDecimal b3 = b1.divide(b2, i1, i2);
        return b3;
    }
}

