/*
 * Decompiled with CFR 0.152.
 */
package com.jssolo.utils;

import com.jssolo.utils.RuntimeExceptionOnly;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateTools {
    private static final long SECONDS_MS = 1000L;
    private static final long MINUTE_MS = 60000L;
    private static final long HOUR_MS = 3600000L;
    private static final long DAY_MS = 86400000L;
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static List<String> splitTime(String dateType, String begin, String end, Integer space, boolean isAddEnd) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Date beginD = null;
        Date endD = null;
        try {
            beginD = sdf.parse(begin);
            endD = sdf.parse(end);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> listDate = new ArrayList<String>();
        listDate.add(new SimpleDateFormat(DATE_FORMAT).format(beginD));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(beginD);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endD);
        while (calEnd.after(calBegin)) {
            if ("M".equals(dateType)) {
                calBegin.add(2, space);
            }
            if ("D".equals(dateType)) {
                calBegin.add(5, space);
            }
            if ("H".equals(dateType)) {
                calBegin.add(10, space);
            }
            if ("N".equals(dateType)) {
                calBegin.add(12, space);
            }
            if ("S".equals(dateType)) {
                calBegin.add(13, space);
            }
            if (calEnd.after(calBegin)) {
                listDate.add(new SimpleDateFormat(DATE_FORMAT).format(calBegin.getTime()));
                continue;
            }
            if (!isAddEnd) continue;
            listDate.add(new SimpleDateFormat(DATE_FORMAT).format(calEnd.getTime()));
        }
        return listDate;
    }

    public static Date dateAddDay(Date date, Integer dayNum) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, dayNum);
        return calendar.getTime();
    }

    public static Date dateAddDay(Date date, Double dayNum) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int ms = (int)(dayNum * 8.64E7);
        ((Calendar)calendar).add(14, ms);
        return calendar.getTime();
    }

    public static Date dateAddHour(Date date, Integer hour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(11, hour);
        return calendar.getTime();
    }

    public static Date dateAddHour(Date date, Double hour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int ms = (int)(hour * 3600000.0);
        ((Calendar)calendar).add(14, ms);
        return calendar.getTime();
    }

    public static Boolean firstIsBig(Date first, Date last) {
        return first.after(last);
    }

    public static Boolean firstIsBigAddHour(Date first, Date last, Integer hour) {
        Date temp = DateTools.dateAddHour(last, hour);
        return DateTools.firstIsBig(first, temp);
    }

    public static Boolean firstIsBigAddHour(Date first, Date last, Double hour) {
        Date temp = DateTools.dateAddHour(last, hour);
        return DateTools.firstIsBig(first, temp);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static Date stringToDate(String dateStr, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeExceptionOnly("com.jssolo.utils.TimeTool.stringToDate()\u65b9\u6cd5\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static BigDecimal dateDiffMs(Date d1, Date d2) {
        BigDecimal b1 = new BigDecimal(d1.getTime() - d2.getTime()).abs();
        return b1;
    }

    public static BigDecimal dateDiffSeconds(Date d1, Date d2) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 1000L, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffMinutes(Date d1, Date d2) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 60000L, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffMinutes(Date d1, Date d2, int i) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 60000L, i, 4);
        return b3;
    }

    public static BigDecimal dateDiffHours(Date d1, Date d2) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 3600000L, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffHours(Date d1, Date d2, int i) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 3600000L, i, 4);
        return b3;
    }

    public static BigDecimal dateDiffDays(Date d1, Date d2) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 86400000L, 2, 4);
        return b3;
    }

    public static BigDecimal dateDiffDays(Date d1, Date d2, int i) {
        BigDecimal b3 = DateTools.dateDiff(d1, d2, 86400000L, i, 4);
        return b3;
    }

    private static BigDecimal dateDiff(Date d1, Date d2, long l, int i1, int i2) {
        BigDecimal b1 = new BigDecimal(d1.getTime() - d2.getTime()).abs();
        BigDecimal b2 = new BigDecimal(l);
        BigDecimal b3 = b1.divide(b2, i1, i2);
        return b3;
    }

    public static String dateToWeek(Date date) {
        String[] weekDays = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
        return DateTools.dateToWeek(date, weekDays);
    }

    public static String dateToWeek(Date date, String[] weekDays) {
        if (weekDays == null) {
            throw new RuntimeExceptionOnly("com.jssolo.utils.TimeTool.dateToWeek() weekDays \u662f\u7a7a\u7684");
        }
        if (weekDays.length != 7) {
            throw new RuntimeExceptionOnly("com.jssolo.utils.TimeTool.dateToWeek() weekDays \u957f\u5ea6\u4e0d\u4e3a7");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            throw new RuntimeExceptionOnly("com.jssolo.utils.TimeTool.dateToWeek() \u5468\u53f7\u83b7\u53d6\u5f02\u5e38");
        }
        return weekDays[w];
    }

    public static long toTimestamp(String dateStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDateTime dateTime = LocalDateTime.parse(dateStr, formatter);
        ZonedDateTime zonedDateTime = dateTime.atZone(ZoneId.systemDefault());
        long timestamp = zonedDateTime.toInstant().toEpochMilli() / 1000L;
        return timestamp;
    }

    public static long toUTCTimestamp(String dateStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        LocalDateTime dateTime = LocalDateTime.parse(dateStr, formatter);
        ZonedDateTime utcZonedDateTime = dateTime.atZone(ZoneId.of("UTC"));
        long timestamp = utcZonedDateTime.toInstant().toEpochMilli() / 1000L;
        return timestamp;
    }
}

