/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.auth.logic;

import com.jxrisesun.framework.spring.auth.annotation.RequiresLogical;
import com.jxrisesun.framework.spring.auth.annotation.RequiresPermissions;
import com.jxrisesun.framework.spring.auth.annotation.RequiresRoles;
import com.jxrisesun.framework.spring.auth.config.AuthConfig;
import com.jxrisesun.framework.spring.auth.config.SimpleAuthConfig;
import com.jxrisesun.framework.spring.auth.logic.AuthLogic;
import com.jxrisesun.framework.spring.auth.token.AuthToken;
import com.jxrisesun.framework.spring.auth.user.AuthUser;
import com.jxrisesun.lang.exception.auth.NotLoginException;
import com.jxrisesun.lang.exception.auth.NotPermissionException;
import com.jxrisesun.lang.exception.auth.NotRoleException;
import com.jxrisesun.lang.util.ArrayUtils;
import java.util.HashSet;
import java.util.Set;

public class SimpleAuthLogic
implements AuthLogic {
    protected AuthConfig config;

    @Override
    public void login(AuthToken authToken) {
    }

    @Override
    public void logout() {
    }

    @Override
    public void logout(AuthToken authToken) {
    }

    @Override
    public boolean isLogin() {
        return false;
    }

    @Override
    public void checkLogin() {
        if (!this.isLogin()) {
            throw new NotLoginException(this.getConfig().getNotLoginMessage());
        }
    }

    @Override
    public AuthToken getLoginToken() {
        return null;
    }

    @Override
    public String getLoginTokenName() {
        AuthToken authToken = this.getLoginToken();
        return authToken != null ? authToken.getTokenName() : null;
    }

    @Override
    public String getLoginTokenValue() {
        AuthToken authToken = this.getLoginToken();
        return authToken != null && authToken.getTokenValue() != null ? authToken.getTokenValue().toString() : null;
    }

    @Override
    public AuthUser getLoginUser() {
        return null;
    }

    @Override
    public String getLoginUserId() {
        AuthUser authUser = this.getLoginUser();
        return authUser != null ? authUser.getUserId() : null;
    }

    @Override
    public String getLoginUsername() {
        AuthUser authUser = this.getLoginUser();
        return authUser != null ? authUser.getUsername() : null;
    }

    @Override
    public boolean hasPermission(String permission) {
        return false;
    }

    @Override
    public void checkPermission(String permission) {
        if (!this.hasPermission(permission)) {
            throw new NotPermissionException(this.getConfig().getNotPermissionMessage());
        }
    }

    @Override
    public void checkPermission(RequiresPermissions requiresPermissions) {
        Object[] permissions = requiresPermissions.value();
        if (ArrayUtils.isEmpty((Object[])permissions)) {
            return;
        }
        for (Object permission : permissions) {
            if (RequiresLogical.AND.equals((Object)requiresPermissions.logical())) {
                if (this.hasPermission((String)permission)) continue;
                throw new NotPermissionException(this.getConfig().getNotPermissionMessage());
            }
            if (this.hasPermission((String)permission)) break;
        }
    }

    @Override
    public Set<String> getPermissions() {
        return new HashSet<String>();
    }

    @Override
    public boolean hasRole(String role) {
        return false;
    }

    @Override
    public void checkRole(String role) {
        if (!this.hasRole(role)) {
            throw new NotRoleException(this.getConfig().getNotRoleMessage());
        }
    }

    @Override
    public void checkRole(RequiresRoles requiresRoles) {
        Object[] roles = requiresRoles.value();
        if (ArrayUtils.isEmpty((Object[])roles)) {
            return;
        }
        for (Object role : roles) {
            if (RequiresLogical.AND.equals((Object)requiresRoles.logical())) {
                if (this.hasRole((String)role)) continue;
                throw new NotRoleException(this.getConfig().getNotRoleMessage());
            }
            if (this.hasRole((String)role)) break;
        }
    }

    @Override
    public Set<String> getRoles() {
        return new HashSet<String>();
    }

    @Override
    public AuthConfig getConfig() {
        if (this.config == null) {
            this.config = new SimpleAuthConfig();
        }
        return this.config;
    }
}

