/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.condition;

import com.jxrisesun.framework.spring.condition.AbstractBeanCondition;
import com.jxrisesun.framework.spring.condition.ConditionalOnMissBean;
import com.jxrisesun.lang.util.ArrayUtils;
import com.jxrisesun.lang.util.LogUtils;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Order(value=0x7FFFFFFF)
public class OnMissBeanCondition
extends AbstractBeanCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        try {
            if (!metadata.isAnnotated(ConditionalOnMissBean.class.getName())) {
                return true;
            }
            MergedAnnotation mergedAnnotation = metadata.getAnnotations().get(ConditionalOnMissBean.class);
            if (mergedAnnotation == null) {
                return true;
            }
            Object[] values = mergedAnnotation.getClassArray("value");
            if (ArrayUtils.isEmpty((Object[])values)) {
                return true;
            }
            for (Object type : values) {
                Object[] names = context.getBeanFactory().getBeanNamesForType((Class)type, true, false);
                if (!ArrayUtils.isNotEmpty((Object[])names)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LogUtils.debug(OnMissBeanCondition.class, (String)e.getMessage(), (Object[])new Object[0]);
            return true;
        }
    }
}

