/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.context;

import com.jxrisesun.framework.spring.util.RedisUtils;
import com.jxrisesun.lang.util.ClassUtils;
import com.jxrisesun.lang.util.LogUtils;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.env.Environment;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringContextHolder
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static ServletContext servletContext;
    private static Environment environment;
    private static MessageSourceAccessor messageSourceAccessor;

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            ServletContext sc = SpringContextHolder.getServletContext();
            applicationContext = sc != null ? WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc) : ContextLoader.getCurrentWebApplicationContext();
        }
        return applicationContext;
    }

    public static ServletContext getServletContext() {
        if (servletContext == null) {
            try {
                RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
                if (attributes != null) {
                    servletContext = ((ServletRequestAttributes)attributes).getRequest().getServletContext();
                }
            }
            catch (Exception e) {
                LogUtils.debug(SpringContextHolder.class, (String)e.getMessage(), (Object[])new Object[0]);
                return null;
            }
        }
        return servletContext;
    }

    public static void setServletContext(ServletContext servletContext) {
        SpringContextHolder.servletContext = servletContext;
    }

    public static Environment getEnvironment() {
        if (environment == null) {
            environment = SpringContextHolder.getApplicationContext().getEnvironment();
        }
        return environment;
    }

    public static MessageSourceAccessor getMessageSourceAccessor() {
        return messageSourceAccessor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContextHolder.init(applicationContext);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LogUtils.info(SpringContextHolder.class, (String)"---------- \u3010FrameworkSpring\u3011 SpringContextHolder Initializing ----------", (Object[])new Object[0]);
    }

    private static void init(ApplicationContext context) {
        applicationContext = context;
        environment = context.getEnvironment();
        if (context instanceof WebApplicationContext) {
            servletContext = ((WebApplicationContext)context).getServletContext();
        }
        messageSourceAccessor = new MessageSourceAccessor((MessageSource)context, Locale.SIMPLIFIED_CHINESE);
    }

    public static Object getBean(String name, Object ... args) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        return ac != null ? SpringContextHolder.getApplicationContext().getBean(name, args) : null;
    }

    public static <T> T getBean(Class<T> requiredType, Object ... args) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        return (T)(ac != null ? SpringContextHolder.getApplicationContext().getBean(requiredType, args) : null);
    }

    public static <T> T getBean(String name, Class<T> requiredType) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        return (T)(ac != null ? SpringContextHolder.getApplicationContext().getBean(name, requiredType) : null);
    }

    public static Class<?> getBeanClass(String className) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        Class cls = null;
        try {
            cls = ac != null ? ClassUtils.getClass((ClassLoader)ac.getClassLoader(), (String)className) : ClassUtils.getClass((String)className);
        }
        catch (Exception e) {
            LogUtils.debug(SpringContextHolder.class, (String)e.getMessage(), (Object[])new Object[0]);
        }
        return cls;
    }

    public static String[] getBeanNamesForType(Class<?> type) {
        return SpringContextHolder.getBeanNamesForType(type, true, false);
    }

    public static String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        return ac != null ? ac.getBeanNamesForType(type, includeNonSingletons, allowEagerInit) : null;
    }

    public static <T> T registerBean(Class<T> clazz, Object ... args) {
        return SpringContextHolder.registerBean(clazz.getName(), clazz, args);
    }

    public static <T> T registerBean(String name, Class<T> clazz, Object ... args) {
        ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)SpringContextHolder.getApplicationContext();
        return SpringContextHolder.registerBean(applicationContext, name, clazz, args);
    }

    public static <T> T registerBean(ConfigurableApplicationContext applicationContext, String name, Class<T> clazz, Object ... args) {
        if (applicationContext.containsBean(name)) {
            Object bean = applicationContext.getBean(name);
            if (bean.getClass().isAssignableFrom(clazz)) {
                return (T)bean;
            }
            throw new RuntimeException("beanName \u91cd\u590d " + name);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                beanDefinitionBuilder.addConstructorArgValue(arg);
            }
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)applicationContext.getBeanFactory();
        beanDefinitionRegistry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        return (T)applicationContext.getBean(name, clazz);
    }

    public static String getProperty(String key) {
        Environment env = SpringContextHolder.getEnvironment();
        return env != null ? env.getProperty(key) : null;
    }

    public static String getProperty(String key, String defaultValue) {
        Environment env = SpringContextHolder.getEnvironment();
        return env != null ? env.getProperty(key, defaultValue) : null;
    }

    public static boolean hasRedisConnectionFactory() {
        try {
            Class<?> cls = SpringContextHolder.getBeanClass("org.springframework.data.redis.connection.RedisConnectionFactory");
            if (cls == null) {
                return false;
            }
            return SpringContextHolder.getBean(cls, new Object[0]) != null;
        }
        catch (Exception e) {
            LogUtils.debug(RedisUtils.class, (String)e.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }
}

