/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.jxrisesun.lang.Filter;
import com.jxrisesun.lang.util.ArrayUtils;
import com.jxrisesun.lang.util.DateUtils;
import com.jxrisesun.lang.util.NumberUtils;
import com.jxrisesun.lang.util.StringUtils;
import java.io.IOException;
import java.util.Date;

public class JsonDateDeserializer
extends JsonDeserializer<Date> {
    private String[] patterns = new String[]{"yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-ddTHH:mm:ss.SSSZ"};

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        final String dateStr = jsonParser.getText();
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        if (NumberUtils.isNumber((CharSequence)dateStr)) {
            return DateUtils.getDate((long)NumberUtils.parseLong((String)dateStr));
        }
        Date parseDate = null;
        try {
            String firstPattern = (String)ArrayUtils.first((Object[])this.patterns, (Filter)new Filter<String>(){

                public boolean accept(String pattern) {
                    return dateStr.length() == pattern.length();
                }
            });
            if (!StringUtils.isEmpty((CharSequence)firstPattern) && (parseDate = DateUtils.parse((String)dateStr, (String)firstPattern)) != null) {
                return parseDate;
            }
            for (String pattern : this.patterns) {
                parseDate = DateUtils.parse((String)dateStr, (String)pattern);
                if (parseDate == null) continue;
                return parseDate;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getCause());
        }
        return parseDate;
    }
}

