/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.util;

import com.jxrisesun.framework.spring.auth.annotation.RequiresPermissions;
import com.jxrisesun.framework.spring.auth.annotation.RequiresRoles;
import com.jxrisesun.framework.spring.auth.config.AuthConfig;
import com.jxrisesun.framework.spring.auth.logic.AuthLogic;
import com.jxrisesun.framework.spring.auth.logic.SimpleAuthLogic;
import com.jxrisesun.framework.spring.auth.token.AuthToken;
import com.jxrisesun.framework.spring.auth.user.AuthUser;
import com.jxrisesun.framework.spring.context.SpringContextHolder;
import java.util.Set;

public class AuthUtils {
    private static AuthLogic authLogic;

    public static AuthLogic getAuthLogic() {
        if (authLogic == null) {
            authLogic = SpringContextHolder.getBean(AuthLogic.class, new Object[0]);
        }
        if (authLogic == null) {
            authLogic = new SimpleAuthLogic();
        }
        return authLogic;
    }

    public static void setAuthLogic(AuthLogic authLogic) {
        AuthUtils.authLogic = authLogic;
    }

    public static void login(AuthToken authToken) {
        AuthUtils.getAuthLogic().login(authToken);
    }

    public static void logout() {
        AuthUtils.getAuthLogic().logout();
    }

    public static void logout(AuthToken authToken) {
        AuthUtils.getAuthLogic().logout(authToken);
    }

    public static boolean isLogin() {
        return AuthUtils.getAuthLogic().isLogin();
    }

    public static void checkLogin() {
        AuthUtils.getAuthLogic().checkLogin();
    }

    public static AuthToken getLoginToken() {
        return AuthUtils.getAuthLogic().getLoginToken();
    }

    public static AuthUser getLoginUser() {
        return AuthUtils.getAuthLogic().getLoginUser();
    }

    public static boolean hasPermission(String permission) {
        return AuthUtils.getAuthLogic().hasPermission(permission);
    }

    public static void checkPermission(String permission) {
        AuthUtils.getAuthLogic().checkPermission(permission);
    }

    public static void checkPermission(RequiresPermissions requiresPermissions) {
        AuthUtils.getAuthLogic().checkPermission(requiresPermissions);
    }

    public static Set<String> getPermissions() {
        return AuthUtils.getAuthLogic().getPermissions();
    }

    public static boolean hasRole(String role) {
        return AuthUtils.getAuthLogic().hasRole(role);
    }

    public static void checkRole(String role) {
        AuthUtils.getAuthLogic().checkRole(role);
    }

    public static void checkRole(RequiresRoles requiresRoles) {
        AuthUtils.getAuthLogic().checkRole(requiresRoles);
    }

    public static Set<String> getRoles() {
        return AuthUtils.getAuthLogic().getRoles();
    }

    public static AuthConfig getConfig() {
        return AuthUtils.getAuthLogic().getConfig();
    }
}

