/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.jxrisesun.lang.Result;
import com.jxrisesun.lang.function.FuncP;
import com.jxrisesun.lang.result.ApiResult;
import com.jxrisesun.lang.util.LogUtils;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;

public class JwtUtils {
    protected JwtUtils() {
    }

    public static Result<String> signWithHS256(String secret, final String jwtId, final String subject, final String issuer, final long issuedAt, final long expiresAt) {
        return JwtUtils.signWithHS256(secret, new FuncP<JWTCreator.Builder>(){

            public void apply(JWTCreator.Builder builder) {
                builder.withJWTId(jwtId);
                builder.withSubject(subject);
                builder.withIssuer(issuer);
                builder.withIssuedAt(new Date(issuedAt));
                builder.withExpiresAt(new Date(expiresAt));
            }
        });
    }

    public static Result<String> signWithHS256(String secret, FuncP<JWTCreator.Builder> funcBuilder) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTCreator.Builder builder = JWT.create();
            if (funcBuilder != null) {
                funcBuilder.apply((Object)builder);
            }
            String token = builder.sign(algorithm);
            return ApiResult.ok((Object)token);
        }
        catch (JWTCreationException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static Result<String> signWithHS512(String secret, final String jwtId, final String subject, final String issuer, final long issuedAt, final long expiresAt) {
        return JwtUtils.signWithHS512(secret, new FuncP<JWTCreator.Builder>(){

            public void apply(JWTCreator.Builder builder) {
                builder.withJWTId(jwtId);
                builder.withSubject(subject);
                builder.withIssuer(issuer);
                builder.withIssuedAt(new Date(issuedAt));
                builder.withExpiresAt(new Date(expiresAt));
            }
        });
    }

    public static Result<String> signWithHS512(String secret, FuncP<JWTCreator.Builder> funcBuilder) {
        try {
            Algorithm algorithm = Algorithm.HMAC512((String)secret);
            JWTCreator.Builder builder = JWT.create();
            if (funcBuilder != null) {
                funcBuilder.apply((Object)builder);
            }
            String token = builder.sign(algorithm);
            return ApiResult.ok((Object)token);
        }
        catch (JWTCreationException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static Result<String> signWithRS256(RSAPublicKey publicKey, RSAPrivateKey privateKey, FuncP<JWTCreator.Builder> funcBuilder) {
        try {
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, (RSAPrivateKey)privateKey);
            JWTCreator.Builder builder = JWT.create();
            if (funcBuilder != null) {
                funcBuilder.apply((Object)builder);
            }
            String token = builder.sign(algorithm);
            return ApiResult.ok((Object)token);
        }
        catch (JWTCreationException e) {
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static Result<DecodedJWT> verifyWithHS256(String secret, String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            return ApiResult.ok((Object)jwt);
        }
        catch (SignatureVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        catch (JWTVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static Result<DecodedJWT> verifyWithHS512(String secret, String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC512((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            return ApiResult.ok((Object)jwt);
        }
        catch (SignatureVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        catch (JWTVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)e.getMessage());
        }
    }

    public static Result<DecodedJWT> verifyWithRSA256(RSAPublicKey publicKey, RSAPrivateKey privateKey, String token) {
        try {
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)publicKey, (RSAPrivateKey)privateKey);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            return ApiResult.ok((Object)jwt);
        }
        catch (SignatureVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)"\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff01");
        }
        catch (JWTVerificationException e) {
            LogUtils.debug(JwtUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return ApiResult.fail((String)e.getMessage());
        }
    }
}

