/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.util;

import com.jxrisesun.framework.spring.context.SpringContextHolder;
import com.jxrisesun.lang.util.LogUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisUtils {
    public static final long NEVER_EXPIRE = -1L;
    public static final long NOT_VALUE_EXPIRE = -2L;
    private static final ConcurrentHashMap<Class<?>, RedisSerializer<?>> RedisKeySerializerCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, RedisSerializer<?>> RedisValueSerializerCache = new ConcurrentHashMap();
    private static RedisConnectionFactory redisConnectionFactory;

    public static RedisConnectionFactory getRedisConnectionFactory() {
        if (redisConnectionFactory == null) {
            try {
                redisConnectionFactory = SpringContextHolder.getBean(RedisConnectionFactory.class, new Object[0]);
            }
            catch (Exception e) {
                LogUtils.error(RedisUtils.class, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        return redisConnectionFactory;
    }

    public static void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        RedisUtils.redisConnectionFactory = redisConnectionFactory;
    }

    public static <K> RedisSerializer<?> getRedisKeySerializer(Class<K> clsKey) {
        if (clsKey != null) {
            if (RedisKeySerializerCache.containsKey(clsKey)) {
                return RedisKeySerializerCache.get(clsKey);
            }
            Object redisSerializer = null;
            if (clsKey == String.class) {
                redisSerializer = new StringRedisSerializer();
                RedisKeySerializerCache.put(clsKey, (RedisSerializer<?>)redisSerializer);
                return redisSerializer;
            }
            if (clsKey == byte[].class) {
                redisSerializer = new RedisSerializer<byte[]>(){

                    public byte[] serialize(byte[] t) throws SerializationException {
                        return t;
                    }

                    public byte[] deserialize(byte[] bytes) throws SerializationException {
                        return bytes;
                    }
                };
                RedisKeySerializerCache.put(clsKey, (RedisSerializer<?>)redisSerializer);
                return redisSerializer;
            }
        }
        return new StringRedisSerializer();
    }

    public static void setRedisKeySerializer(Class<?> clazz, RedisSerializer<?> redisKeySerializer) {
        RedisKeySerializerCache.put(clazz, redisKeySerializer);
    }

    public static RedisSerializer<?> getRedisValueSerializer(Class<?> clsValue) {
        if (clsValue != null && RedisValueSerializerCache.containsKey(clsValue)) {
            return RedisValueSerializerCache.get(clsValue);
        }
        return new GenericJackson2JsonRedisSerializer();
    }

    public static void setRedisValueSerializer(Class<?> clazz, RedisSerializer<?> redisValueSerializer) {
        RedisValueSerializerCache.put(clazz, redisValueSerializer);
    }

    public static StringRedisTemplate createStringRedisTemplate() {
        StringRedisTemplate redisTemplate = new StringRedisTemplate();
        redisTemplate.setConnectionFactory(RedisUtils.getRedisConnectionFactory());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public static <K, V> RedisTemplate<K, V> createRedisTemplate(Class<K> clsKey, Class<V> clsV) {
        return RedisUtils.createRedisTemplate(RedisUtils.getRedisConnectionFactory(), clsKey, clsV);
    }

    public static <K, V> RedisTemplate<K, V> createRedisTemplate(RedisConnectionFactory redisConnectionFactory, Class<K> clsKey, Class<V> clsV) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.setKeySerializer(RedisUtils.getRedisKeySerializer(clsKey));
        redisTemplate.setHashKeySerializer(RedisUtils.getRedisKeySerializer(clsKey));
        redisTemplate.setValueSerializer(RedisUtils.getRedisValueSerializer(clsV));
        redisTemplate.setHashValueSerializer(RedisUtils.getRedisValueSerializer(clsV));
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public static String getString(StringRedisTemplate stringRedisTemplate, String key) {
        return (String)RedisUtils.get(stringRedisTemplate, key);
    }

    public static void setString(StringRedisTemplate stringRedisTemplate, String key, String value, long timeout) {
        RedisUtils.set(stringRedisTemplate, key, value, timeout);
    }

    public static void updateString(StringRedisTemplate stringRedisTemplate, String key, String value) {
        RedisUtils.update(stringRedisTemplate, key, value);
    }

    public static Object getObject(RedisTemplate<String, Object> redisTemplate, String key) {
        return RedisUtils.get(redisTemplate, key);
    }

    public static void setObject(RedisTemplate<String, Object> redisTemplate, String key, Object object, long timeout) {
        RedisUtils.set(redisTemplate, key, object, timeout);
    }

    public static void updateObject(RedisTemplate<String, Object> redisTemplate, String key, Object object) {
        RedisUtils.update(redisTemplate, key, object);
    }

    public static byte[] getBytes(RedisTemplate<?, ?> redisTemplate, final byte[] key) {
        return (byte[])redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.get(key);
            }
        });
    }

    public static void setBytes(RedisTemplate<?, ?> redisTemplate, final byte[] key, final byte[] object, final long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        redisTemplate.execute((RedisCallback)new RedisCallback<byte[]>(){

            public byte[] doInRedis(RedisConnection connection) throws DataAccessException {
                if (timeout == -1L) {
                    connection.set(key, object);
                } else {
                    connection.set(key, object, Expiration.seconds((long)timeout), RedisStringCommands.SetOption.UPSERT);
                }
                return object;
            }
        });
    }

    public static <K, V> V get(RedisTemplate<K, V> redisTemplate, K key) {
        return (V)redisTemplate.opsForValue().get(key);
    }

    public static <K, V> void set(RedisTemplate<K, V> redisTemplate, K key, V object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        if (timeout == -1L) {
            redisTemplate.opsForValue().set(key, object);
        } else {
            redisTemplate.opsForValue().set(key, object, timeout, TimeUnit.SECONDS);
        }
    }

    public static <K, V> void update(RedisTemplate<K, V> redisTemplate, K key, V object) {
        long expire = RedisUtils.getExpire(redisTemplate, key);
        if (expire == -2L) {
            return;
        }
        RedisUtils.set(redisTemplate, key, object, expire);
    }

    public static <K> void delete(RedisTemplate<K, ?> redisTemplate, K key) {
        redisTemplate.delete(key);
    }

    public static <K> long getExpire(RedisTemplate<K, ?> redisTemplate, K key) {
        return redisTemplate.getExpire(key);
    }

    public static <K, V> void setExpire(RedisTemplate<K, V> redisTemplate, K key, long timeout) {
        if (timeout == -1L) {
            long expire = RedisUtils.getExpire(redisTemplate, key);
            if (expire != -1L) {
                RedisUtils.set(redisTemplate, key, RedisUtils.get(redisTemplate, key), timeout);
            }
            return;
        }
        redisTemplate.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static <K> Set<K> keys(RedisTemplate<K, ?> redisTemplate, K pattern) {
        return redisTemplate.keys(pattern);
    }

    public static <K> long dbSize(RedisTemplate<K, ?> redisTemplate) {
        RedisConnectionFactory factory = redisTemplate.getConnectionFactory();
        if (factory == null) {
            return -1L;
        }
        RedisConnection connection = factory.getConnection();
        return connection.dbSize();
    }
}

