/*
 * Decompiled with CFR 0.152.
 */
package com.jxrisesun.framework.spring.util;

import com.jxrisesun.framework.spring.context.SpringContextHolder;
import com.jxrisesun.lang.exception.UtilException;
import com.jxrisesun.lang.util.LogUtils;
import com.jxrisesun.lang.util.StringUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class SpringUtils {
    public static final String REQUEST_METHOD_GET = "GET";
    public static final String REQUEST_METHOD_POST = "POST";
    public static final String REQUEST_SCHEME_HTTP = "http";
    public static final String REQUEST_SCHEME_HTTPS = "https";
    public static final int REQUEST_PORT_80 = 80;
    public static final int REQUEST_PORT_443 = 443;

    private SpringUtils() {
    }

    public static ApplicationContext getApplicationContext() {
        return SpringContextHolder.getApplicationContext();
    }

    public static Environment getEnvironment() {
        return SpringContextHolder.getEnvironment();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        try {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            return (ServletRequestAttributes)attributes;
        }
        catch (Exception e) {
            LogUtils.debug(SpringUtils.class, (String)e.getMessage(), (Object[])new Object[]{e});
            return null;
        }
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = SpringUtils.getRequestAttributes();
        return attributes != null ? attributes.getRequest() : null;
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes attributes = SpringUtils.getRequestAttributes();
        return attributes != null ? attributes.getResponse() : null;
    }

    public static ServletContext getRequestServletContext(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return null;
        }
        return request.getServletContext();
    }

    public static String getRequestMethod(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return null;
        }
        return request.getMethod();
    }

    public static boolean isRequestGetMethod(HttpServletRequest request) {
        String method = SpringUtils.getRequestMethod(request);
        return REQUEST_METHOD_GET.equalsIgnoreCase(method);
    }

    public static boolean isRequestPostMethod(HttpServletRequest request) {
        String method = SpringUtils.getRequestMethod(request);
        return REQUEST_METHOD_POST.equalsIgnoreCase(method);
    }

    public static boolean isRequestOptionsMethod(HttpServletRequest request) {
        String method = SpringUtils.getRequestMethod(request);
        return "OPTIONS".equalsIgnoreCase(method);
    }

    public static boolean isRequestAjax(HttpServletRequest request) {
        String xRequestedWith = SpringUtils.getRequestHeader(request, "X-Requested-With", true);
        return StringUtils.isNotEmpty((CharSequence)xRequestedWith) && "XMLHttpRequest".equalsIgnoreCase(xRequestedWith);
    }

    public static boolean isRequestMultipart(HttpServletRequest request) {
        if (!SpringUtils.isRequestPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Map<String, String> getRequestHeaderMap(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headers.put(headerName, request.getHeader(headerName));
        }
        return headers;
    }

    public static String getRequestHeader(HttpServletRequest request, String name) {
        return SpringUtils.getRequestHeader(request, name, false);
    }

    public static String getRequestHeader(HttpServletRequest request, String headerName, boolean ignoreCaseName) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return null;
        }
        String header = null;
        if (!ignoreCaseName) {
            header = request.getHeader(headerName);
        } else {
            Enumeration names = request.getHeaderNames();
            String name = null;
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                if (name == null || !name.equalsIgnoreCase(headerName)) continue;
                header = request.getHeader(name);
                break;
            }
        }
        if (header == null) {
            return header;
        }
        header = header.trim();
        return header;
    }

    public static void setRequestHeader(HttpServletResponse response, String name, Object value) {
        if (response == null && (response = SpringUtils.getResponse()) == null) {
            return;
        }
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equals(value.getClass().getSimpleName().toLowerCase())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }

    public static Map<String, String> getRequestParameterMap(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return new HashMap<String, String>();
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            params.put(paramName, request.getParameter(paramName));
        }
        return params;
    }

    public static String getRequestParameter(HttpServletRequest request, String name, String charset) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return null;
        }
        String parameter = request.getParameter(name);
        if (parameter == null) {
            return parameter;
        }
        if (charset != null && !charset.equalsIgnoreCase(request.getCharacterEncoding())) {
            String characterEncoding = request.getCharacterEncoding();
            try {
                parameter = new String(parameter.getBytes(characterEncoding), charset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        parameter = parameter.trim();
        return parameter;
    }

    public static Map<String, Cookie> getRequestCookieMap(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return new LinkedHashMap<String, Cookie>();
        }
        LinkedHashMap<String, Cookie> cookieMap = new LinkedHashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return cookieMap;
        }
        for (Cookie cookie : cookies) {
            cookieMap.put(cookie.getName(), cookie);
        }
        return cookieMap;
    }

    public static String getRequestCookieValue(HttpServletRequest request, String name) {
        Cookie cookie = SpringUtils.getRequestCookie(request, name);
        if (cookie == null) {
            return null;
        }
        String value = cookie.getValue();
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static Cookie getRequestCookie(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = SpringUtils.getRequestCookieMap(request);
        if (cookieMap.size() == 0) {
            return null;
        }
        for (Map.Entry<String, Cookie> kv : cookieMap.entrySet()) {
            if (!kv.getKey().equalsIgnoreCase(name)) continue;
            return kv.getValue();
        }
        return null;
    }

    public static void setRequestCookie(HttpServletResponse response, String name, String value, String domain, int maxAgeInSeconds) {
        SpringUtils.setRequestCookie(response, name, value, domain, "/", maxAgeInSeconds, false);
    }

    public static void setRequestCookie(HttpServletResponse response, String name, String value, String domain, String path, int maxAgeInSeconds, boolean isHttpOnly) {
        if (response == null && (response = SpringUtils.getResponse()) == null) {
            return;
        }
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(isHttpOnly);
        response.addCookie(cookie);
    }

    public static List<MultipartFile> getRequestMultipartFiles(HttpServletRequest request) {
        ArrayList<MultipartFile> multipartFiles = new ArrayList<MultipartFile>();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (!multipartResolver.isMultipart(request)) {
            return multipartFiles;
        }
        MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
        Iterator iterator = multiRequest.getFileNames();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            List files = multiRequest.getFiles(name);
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                if (StringUtils.isEmpty((CharSequence)fileName)) continue;
                multipartFiles.add(file);
            }
        }
        return multipartFiles;
    }

    public static String getRequestUserAgent(HttpServletRequest request) {
        return SpringUtils.getRequestHeader(request, "User-Agent", true);
    }

    public static String getRequestBasePath(ServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str.append(request.getScheme());
        str.append("://");
        str.append(request.getServerName());
        if (request.getScheme().equalsIgnoreCase(REQUEST_SCHEME_HTTP) && request.getServerPort() == 80) {
            str.append("");
        } else if (request.getScheme().equalsIgnoreCase(REQUEST_SCHEME_HTTPS) && request.getServerPort() == 443) {
            str.append("");
        } else {
            str.append(":");
            str.append(request.getServerPort());
        }
        str.append(request.getServletContext().getContextPath());
        return str.toString();
    }

    public static String getRequestServletPath(HttpServletRequest request) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return "";
        }
        return request.getServletPath();
    }

    public static String getRequestToken(HttpServletRequest request, String tokenName, boolean allowHeader, boolean allowCookie, boolean allowUrlParam) {
        if (request == null && (request = SpringUtils.getRequest()) == null) {
            return null;
        }
        String tokenValue = null;
        if (allowHeader && !StringUtils.isEmpty((CharSequence)(tokenValue = SpringUtils.getRequestHeader(request, tokenName)))) {
            return tokenValue;
        }
        if (allowCookie && !StringUtils.isEmpty((CharSequence)(tokenValue = SpringUtils.getRequestCookieValue(request, tokenName)))) {
            return tokenValue;
        }
        if (allowUrlParam && !StringUtils.isEmpty((CharSequence)(tokenValue = SpringUtils.getRequestParameter(request, tokenName, null)))) {
            return tokenValue;
        }
        return tokenValue;
    }

    public static PrintWriter getResponseWriter(ServletResponse response) {
        if (response == null && (response = SpringUtils.getResponse()) == null) {
            return null;
        }
        try {
            return response.getWriter();
        }
        catch (Exception e) {
            throw new UtilException((Throwable)e);
        }
    }
}

