package com.kabouterlabs.jodeint.cquadpack;
import java.util.Collections;
import java.util.Iterator;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Callback;
import org.bridj.FlagSet;
import org.bridj.IntValuedEnum;
import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
/**
 * Wrapper for library <b>cquadpack</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("cquadpack") 
@Runtime(CRuntime.class) 
public class CquadpackLibrary {
	static {
		BridJ.register();
	}
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h</i>
	 */
	public enum quadpack_errno_e implements IntValuedEnum<quadpack_errno_e > {
		SUCCESS(0),
		MAX_SUBDIV(1),
		ROUNDOFF_ER(2),
		BAD_INTEGRAND(3),
		NO_CONVERGANCE(4),
		SLOW_CONVERGANCE(5),
		INVALID_INPUT(6),
		BAD_INTEGRAND_BEHAVIOUR(7);
		quadpack_errno_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<quadpack_errno_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<quadpack_errno_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h</i>
	 */
	public enum quadpack_infinity_e implements IntValuedEnum<quadpack_infinity_e > {
		PLUS_INFINITY(1),
		MINUS_INFINITY(-1),
		MINUS_TO_PLUS_INFINITY(2);
		quadpack_infinity_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<quadpack_infinity_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<quadpack_infinity_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h</i>
	 */
	public enum quadpack_trig_weight_function_e implements IntValuedEnum<quadpack_trig_weight_function_e > {
		COS(1),
		SIN(2);
		quadpack_trig_weight_function_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<quadpack_trig_weight_function_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<quadpack_trig_weight_function_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/**
	 * enum values<br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h</i>
	 */
	public enum quadpack_log_weight_function_e implements IntValuedEnum<quadpack_log_weight_function_e > {
		LOGW_1(1),
		LOGW_2(2),
		LOGW_3(3),
		LOGW_4(4);
		quadpack_log_weight_function_e(long value) {
			this.value = value;
		}
		public final long value;
		public long value() {
			return this.value;
		}
		public Iterator<quadpack_log_weight_function_e > iterator() {
			return Collections.singleton(this).iterator();
		}
		public static IntValuedEnum<quadpack_log_weight_function_e > fromValue(int value) {
			return FlagSet.fromValue(value, values());
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h</i> */
	public static abstract class cquadpack_ode_func extends Callback<cquadpack_ode_func > {
		public double apply(Pointer<Double > doublePtr1) {
			return apply(Pointer.getPeer(doublePtr1));
		}
		public double apply(@Ptr long doublePtr1) {
			return apply((Pointer)Pointer.pointerToAddress(doublePtr1, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:62</i> */
	public static abstract class dqagse_f_callback extends Callback<dqagse_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:79</i> */
	public static abstract class dqagie_f_callback extends Callback<dqagie_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:96</i> */
	public static abstract class dqawoe_f_callback extends Callback<dqawoe_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:121</i> */
	public static abstract class dqawce_f_callback extends Callback<dqawce_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:139</i> */
	public static abstract class dqawfe_f_callback extends Callback<dqawfe_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:164</i> */
	public static abstract class dqawse_f_callback extends Callback<dqawse_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/** <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:185</i> */
	public static abstract class dqagpe_f_callback extends Callback<dqagpe_f_callback > {
		public double apply(Pointer<Double > y) {
			return apply(Pointer.getPeer(y));
		}
		public double apply(@Ptr long y) {
			return apply((Pointer)Pointer.pointerToAddress(y, Double.class));
		}
	};
	/**
	 * Original signature : <code>char* log_weight_to_string(QUADPACK_LOG_WEIGHT_FUNCTION)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:52</i>
	 */
	public static Pointer<Byte > log_weight_to_string(IntValuedEnum<CquadpackLibrary.quadpack_log_weight_function_e > w) {
		return (Pointer)Pointer.pointerToAddress(log_weight_to_string((int)w.value()), Byte.class);
	}
	@Ptr 
	protected native static long log_weight_to_string(int w);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qagse_basic(cquadpack_ode_func, double, double, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:54</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qagse_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double start, double end, Pointer<Double > result) {
		return FlagSet.fromValue(qagse_basic(Pointer.getPeer(func), start, end, Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qagse_basic(@Ptr long func, double start, double end, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qagie_basic(cquadpack_ode_func, double, QUADPACK_INFINITY, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:55</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qagie_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double bound, IntValuedEnum<CquadpackLibrary.quadpack_infinity_e > infinity, Pointer<Double > result) {
		return FlagSet.fromValue(qagie_basic(Pointer.getPeer(func), bound, (int)infinity.value(), Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qagie_basic(@Ptr long func, double bound, int infinity, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qawoe_basic(cquadpack_ode_func, double, double, double, QUADPACK_TRIG_WEIGHT_FUNCTION, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:56</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qawoe_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double a, double b, double omega, IntValuedEnum<CquadpackLibrary.quadpack_trig_weight_function_e > integr, Pointer<Double > result) {
		return FlagSet.fromValue(qawoe_basic(Pointer.getPeer(func), a, b, omega, (int)integr.value(), Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qawoe_basic(@Ptr long func, double a, double b, double omega, int integr, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qawce_basic(cquadpack_ode_func, double, double, double, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:57</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qawce_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double start, double end, double weight, Pointer<Double > result) {
		return FlagSet.fromValue(qawce_basic(Pointer.getPeer(func), start, end, weight, Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qawce_basic(@Ptr long func, double start, double end, double weight, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qawfe_basic(cquadpack_ode_func, double, double, QUADPACK_TRIG_WEIGHT_FUNCTION, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:58</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qawfe_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double a, double omega, IntValuedEnum<CquadpackLibrary.quadpack_trig_weight_function_e > integr, Pointer<Double > result) {
		return FlagSet.fromValue(qawfe_basic(Pointer.getPeer(func), a, omega, (int)integr.value(), Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qawfe_basic(@Ptr long func, double a, double omega, int integr, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qawse_basic(cquadpack_ode_func, double, double, double, double, QUADPACK_LOG_WEIGHT_FUNCTION, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:59</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qawse_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double a, double b, double alfa, double beta, IntValuedEnum<CquadpackLibrary.quadpack_log_weight_function_e > integr, Pointer<Double > result) {
		return FlagSet.fromValue(qawse_basic(Pointer.getPeer(func), a, b, alfa, beta, (int)integr.value(), Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qawse_basic(@Ptr long func, double a, double b, double alfa, double beta, int integr, @Ptr long result);
	/**
	 * Original signature : <code>QUADPACK_ERRNO qagpe_basic(cquadpack_ode_func, double, double, int, double*, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:60</i>
	 */
	public static IntValuedEnum<CquadpackLibrary.quadpack_errno_e > qagpe_basic(Pointer<CquadpackLibrary.cquadpack_ode_func > func, double start, double end, int npts2, Pointer<Double > points, Pointer<Double > result) {
		return FlagSet.fromValue(qagpe_basic(Pointer.getPeer(func), start, end, npts2, Pointer.getPeer(points), Pointer.getPeer(result)), CquadpackLibrary.quadpack_errno_e.class);
	}
	protected native static int qagpe_basic(@Ptr long func, double start, double end, int npts2, @Ptr long points, @Ptr long result);
	/**
	 * Original signature : <code>void dqagse(dqagse_f_callback*, double*, double*, double*, double*, int*, double*, double*, int*, int*, double*, double*, double*, double*, int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:62</i>
	 */
	public static void dqagse(Pointer<CquadpackLibrary.dqagse_f_callback > f, Pointer<Double > a, Pointer<Double > b, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > last) {
		dqagse(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(b), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(last));
	}
	protected native static void dqagse(@Ptr long f, @Ptr long a, @Ptr long b, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long last);
	/**
	 * Original signature : <code>void dqagie(dqagie_f_callback*, double*, int*, double*, double*, int*, double*, double*, int*, int*, double*, double*, double*, double*, int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:79</i>
	 */
	public static void dqagie(Pointer<CquadpackLibrary.dqagie_f_callback > f, Pointer<Double > a, Pointer<Integer > inf, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > last) {
		dqagie(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(inf), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(last));
	}
	protected native static void dqagie(@Ptr long f, @Ptr long a, @Ptr long inf, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long last);
	/**
	 * Original signature : <code>void dqawoe(dqawoe_f_callback*, double*, double*, double*, int*, double*, double*, int*, int*, int*, double*, double*, int*, int*, int*, double*, double*, double*, double*, int*, int*, int*, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:96</i>
	 */
	public static void dqawoe(Pointer<CquadpackLibrary.dqawoe_f_callback > f, Pointer<Double > a, Pointer<Double > b, Pointer<Double > omega, Pointer<Integer > integr, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Integer > icall, Pointer<Integer > maxpl, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Integer > last, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > nnlog, Pointer<Integer > momcom, Pointer<Double > chebmo) {
		dqawoe(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(b), Pointer.getPeer(omega), Pointer.getPeer(integr), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(icall), Pointer.getPeer(maxpl), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(last), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(nnlog), Pointer.getPeer(momcom), Pointer.getPeer(chebmo));
	}
	protected native static void dqawoe(@Ptr long f, @Ptr long a, @Ptr long b, @Ptr long omega, @Ptr long integr, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long icall, @Ptr long maxpl, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long last, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long nnlog, @Ptr long momcom, @Ptr long chebmo);
	/**
	 * Original signature : <code>void dqawce(dqawce_f_callback*, double*, double*, double*, double*, double*, int*, double*, double*, int*, int*, double*, double*, double*, double*, int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:121</i>
	 */
	public static void dqawce(Pointer<CquadpackLibrary.dqawce_f_callback > f, Pointer<Double > a, Pointer<Double > b, Pointer<Double > c, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > last) {
		dqawce(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(b), Pointer.getPeer(c), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(last));
	}
	protected native static void dqawce(@Ptr long f, @Ptr long a, @Ptr long b, @Ptr long c, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long last);
	/**
	 * Original signature : <code>void dqawfe(dqawfe_f_callback*, double*, double*, int*, double*, int*, int*, int*, double*, double*, int*, int*, double*, double*, int*, int*, double*, double*, double*, double*, int*, int*, double*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:139</i>
	 */
	public static void dqawfe(Pointer<CquadpackLibrary.dqawfe_f_callback > f, Pointer<Double > a, Pointer<Double > omega, Pointer<Integer > integr, Pointer<Double > epsabs, Pointer<Integer > limlst, Pointer<Integer > limit, Pointer<Integer > maxpl, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > rslst, Pointer<Double > erlst, Pointer<Integer > ierlst, Pointer<Integer > lst, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > nnlog, Pointer<Double > chebmo) {
		dqawfe(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(omega), Pointer.getPeer(integr), Pointer.getPeer(epsabs), Pointer.getPeer(limlst), Pointer.getPeer(limit), Pointer.getPeer(maxpl), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(rslst), Pointer.getPeer(erlst), Pointer.getPeer(ierlst), Pointer.getPeer(lst), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(nnlog), Pointer.getPeer(chebmo));
	}
	protected native static void dqawfe(@Ptr long f, @Ptr long a, @Ptr long omega, @Ptr long integr, @Ptr long epsabs, @Ptr long limlst, @Ptr long limit, @Ptr long maxpl, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long rslst, @Ptr long erlst, @Ptr long ierlst, @Ptr long lst, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long nnlog, @Ptr long chebmo);
	/**
	 * Original signature : <code>void dqawse(dqawse_f_callback*, double*, double*, double*, double*, int*, double*, double*, int*, double*, double*, int*, int*, double*, double*, double*, double*, int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:164</i>
	 */
	public static void dqawse(Pointer<CquadpackLibrary.dqawse_f_callback > f, Pointer<Double > a, Pointer<Double > b, Pointer<Double > alfa, Pointer<Double > beta, Pointer<Integer > integr, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Integer > iord, Pointer<Integer > last) {
		dqawse(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(b), Pointer.getPeer(alfa), Pointer.getPeer(beta), Pointer.getPeer(integr), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(iord), Pointer.getPeer(last));
	}
	protected native static void dqawse(@Ptr long f, @Ptr long a, @Ptr long b, @Ptr long alfa, @Ptr long beta, @Ptr long integr, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long iord, @Ptr long last);
	/**
	 * Original signature : <code>void dqagpe(dqagpe_f_callback*, double*, double*, int*, double*, double*, double*, int*, double*, double*, int*, int*, double*, double*, double*, double*, double*, int*, int*, int*, int*)</code><br>
	 * <i>native declaration : src/main/native/codeint/cquadpack/include/cquadpack.h:185</i>
	 */
	public static void dqagpe(Pointer<CquadpackLibrary.dqagpe_f_callback > f, Pointer<Double > a, Pointer<Double > b, Pointer<Integer > npts2, Pointer<Double > points, Pointer<Double > epsabs, Pointer<Double > epsrel, Pointer<Integer > limit, Pointer<Double > result, Pointer<Double > abserr, Pointer<Integer > neval, Pointer<Integer > ier, Pointer<Double > alist, Pointer<Double > blist, Pointer<Double > rlist, Pointer<Double > elist, Pointer<Double > pts, Pointer<Integer > level, Pointer<Integer > ndin, Pointer<Integer > iord, Pointer<Integer > last) {
		dqagpe(Pointer.getPeer(f), Pointer.getPeer(a), Pointer.getPeer(b), Pointer.getPeer(npts2), Pointer.getPeer(points), Pointer.getPeer(epsabs), Pointer.getPeer(epsrel), Pointer.getPeer(limit), Pointer.getPeer(result), Pointer.getPeer(abserr), Pointer.getPeer(neval), Pointer.getPeer(ier), Pointer.getPeer(alist), Pointer.getPeer(blist), Pointer.getPeer(rlist), Pointer.getPeer(elist), Pointer.getPeer(pts), Pointer.getPeer(level), Pointer.getPeer(ndin), Pointer.getPeer(iord), Pointer.getPeer(last));
	}
	protected native static void dqagpe(@Ptr long f, @Ptr long a, @Ptr long b, @Ptr long npts2, @Ptr long points, @Ptr long epsabs, @Ptr long epsrel, @Ptr long limit, @Ptr long result, @Ptr long abserr, @Ptr long neval, @Ptr long ier, @Ptr long alist, @Ptr long blist, @Ptr long rlist, @Ptr long elist, @Ptr long pts, @Ptr long level, @Ptr long ndin, @Ptr long iord, @Ptr long last);
}
