/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.client;

import com.kiuwan.client.ClientHelper;
import com.kiuwan.client.KiuwanClientException;
import com.kiuwan.client.model.AnalysisComparation;
import com.kiuwan.client.model.Application;
import com.kiuwan.client.model.ApplicationDefects;
import com.kiuwan.client.model.ApplicationFiles;
import com.kiuwan.client.model.ApplicationResults;
import com.kiuwan.client.model.Defect;
import com.kiuwan.client.model.File;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KiuwanRestApiClient {
    protected static final String REST_API_BASE_URL = "https://api.kiuwan.com";
    protected WebResource connexion;
    protected static final ObjectMapper mapper = new ObjectMapper();

    public KiuwanRestApiClient(String user, String password) {
        this(user, password, REST_API_BASE_URL);
    }

    public KiuwanRestApiClient(String user, String password, String restApiBaseUrl) {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.connexion = ClientHelper.createClient().resource(restApiBaseUrl);
        this.connexion.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, password));
    }

    public void activateLog() {
        this.connexion.addFilter((ClientFilter)new LoggingFilter());
    }

    public List<Application> getApplications() throws KiuwanClientException {
        String path = "/apps/list";
        ClientResponse response = this.get(path);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplications(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public ApplicationResults getApplicationResults(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName;
        return this.requestAndBuildApplicationResults(path);
    }

    public ApplicationResults getApplicationResultsByAnalysisCode(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode;
        return this.requestAndBuildApplicationResults(path);
    }

    public ApplicationResults requestAndBuildApplicationResults(String path) throws KiuwanClientException {
        ClientResponse response = this.get(path);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplication(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public AnalysisComparation requestAndBuildAnalysisComparation(String path) throws KiuwanClientException {
        ClientResponse response = this.get(path);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readAnalysisComparation(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<File> getAllFiles(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        ArrayList<File> files = new ArrayList<File>();
        int page = 1;
        int count = 0;
        do {
            ApplicationFiles appFiles;
            if ((appFiles = this.getApplicationFilesPage(appName, page++, 500)) == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = appFiles.getFiles().size();
            files.addAll(appFiles.getFiles());
        } while (count == 500);
        return files;
    }

    public List<File> getAllAnalysisFiles(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        ArrayList<File> files = new ArrayList<File>();
        int page = 1;
        int count = 0;
        do {
            ApplicationFiles appFiles;
            if ((appFiles = this.getAnalysisFilesPage(analysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = appFiles.getFiles().size();
            files.addAll(appFiles.getFiles());
        } while (count == 500);
        return files;
    }

    private ApplicationFiles getApplicationFilesPage(String appName, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName + "/files";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplicationFiles(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationFiles getAnalysisFilesPage(String analysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode + "/files";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplicationFiles(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationFiles readApplicationFiles(InputStreamReader isr) throws JsonParseException, JsonMappingException, IOException {
        return (ApplicationFiles)mapper.readValue((Reader)isr, (TypeReference)new TypeReference<ApplicationFiles>(){});
    }

    public List<Defect> getAllDefects(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            ApplicationDefects appDefects;
            if ((appDefects = this.getApplicationDefectsPage(appName, page++, 500)) == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = appDefects.getDefects().size();
            defects.addAll(appDefects.getDefects());
        } while (count == 500);
        return defects;
    }

    public List<Defect> getAllAnalysisDefects(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            ApplicationDefects appDefects;
            if ((appDefects = this.getAnalysisDefectsPage(analysisCode, page++, 500)) == null || appDefects.getDefects() == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = appDefects.getDefects().size();
            defects.addAll(appDefects.getDefects());
        } while (count == 500);
        return defects;
    }

    private ApplicationDefects getApplicationDefectsPage(String appName, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName + "/defects";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplicationDefects(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationDefects getAnalysisDefectsPage(String analysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode + "/defects";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readApplicationDefects(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationDefects readApplicationDefects(InputStreamReader isr) throws JsonParseException, JsonMappingException, IOException {
        return (ApplicationDefects)mapper.readValue((Reader)isr, (TypeReference)new TypeReference<ApplicationDefects>(){});
    }

    protected ClientResponse get(String resource) {
        return (ClientResponse)this.connexion.path(resource).get(ClientResponse.class);
    }

    protected ClientResponse get(String resource, MultivaluedMap<String, String> queryParams) {
        return (ClientResponse)this.connexion.path(resource).queryParams(queryParams).get(ClientResponse.class);
    }

    protected List<Application> readApplications(InputStreamReader isr) throws IOException, JsonParseException, JsonMappingException {
        return (List)mapper.readValue((Reader)isr, (TypeReference)new TypeReference<List<Application>>(){});
    }

    private ApplicationResults readApplication(InputStreamReader isr) throws JsonParseException, JsonMappingException, IOException {
        return (ApplicationResults)mapper.readValue((Reader)isr, (TypeReference)new TypeReference<ApplicationResults>(){});
    }

    private AnalysisComparation readAnalysisComparation(InputStreamReader isr) throws JsonParseException, JsonMappingException, IOException {
        return (AnalysisComparation)mapper.readValue((Reader)isr, (TypeReference)new TypeReference<AnalysisComparation>(){});
    }

    protected void checkStatus(ClientResponse response, int checkStatus) throws KiuwanClientException {
        int status = response.getStatus();
        if (status != checkStatus) {
            throw KiuwanClientException.createResponseStatusException(status);
        }
    }

    public AnalysisComparation getAnalysisComparation(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode;
        return this.requestAndBuildAnalysisComparation(path);
    }

    public List<Defect> getAllNewDefects(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            AnalysisComparation analysisComparation;
            if ((analysisComparation = this.getNewDefectsPage(mainAnalysisCode, previousAnalysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = analysisComparation.getNewDefects().size();
            defects.addAll(analysisComparation.getNewDefects());
        } while (count == 500);
        return defects;
    }

    private AnalysisComparation getNewDefectsPage(String mainAnalysisCode, String previousAnalysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode + "/new";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readAnalysisComparation(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<Defect> getAllRemovedDefects(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            AnalysisComparation analysisComparation;
            if ((analysisComparation = this.getRemovedDefectsPage(mainAnalysisCode, previousAnalysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unkonwn error");
            }
            count = analysisComparation.getRemovedDefects().size();
            defects.addAll(analysisComparation.getRemovedDefects());
        } while (count == 500);
        return defects;
    }

    private AnalysisComparation getRemovedDefectsPage(String mainAnalysisCode, String previousAnalysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode + "/removed";
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"page", (Object)pageNumber.toString());
        queryParams.add((Object)"count", (Object)defectsPerPage.toString());
        ClientResponse response = this.get(path, (MultivaluedMap<String, String>)queryParams);
        this.checkStatus(response, 200);
        InputStream is = response.getEntityInputStream();
        InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
        try {
            return this.readAnalysisComparation(isr);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }
}

