/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.client;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.map.DeserializationConfig;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.JacksonFeature;

public class ClientHelper {
    public static Client createClient() {
        return ClientHelper.createClient(null, null, null, null, null);
    }

    public static Client createClient(String proxyHost, Integer proxyPort, Proxy.Type proxyType, String proxyUser, String proxyPassword) {
        JerseyClientBuilder clientBuilder = new JerseyClientBuilder();
        clientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        TrustManager[] certs = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, certs, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        clientBuilder.sslContext(sslContext);
        Client client = null;
        client = proxyHost != null && proxyPort != null && proxyType != null ? JerseyClientBuilder.newClient((Configuration)ClientHelper.configureClient(proxyHost, proxyPort, proxyType, proxyUser, proxyPassword)) : clientBuilder.newClient();
        JacksonJaxbJsonProvider jsonProvider = new JacksonJaxbJsonProvider();
        jsonProvider.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return (Client)((Client)client.register((Object)jsonProvider)).register(JacksonFeature.class);
    }

    private static ClientConfig configureClient(String proxyHost, Integer proxyPort, Proxy.Type proxyType, String proxyUser, String proxyPassword) {
        HttpUrlConnectorProvider.ConnectionFactory connectionFactory = ClientHelper.buildConnectionFactoryWithProxy(proxyHost, proxyPort, proxyType);
        if (proxyUser != null) {
            ClientHelper.configureProxyAuthentication(proxyUser, proxyPassword);
        }
        HttpUrlConnectorProvider httpUrlConnectorProvider = new HttpUrlConnectorProvider().connectionFactory(connectionFactory);
        return new ClientConfig().connectorProvider((ConnectorProvider)httpUrlConnectorProvider);
    }

    private static HttpUrlConnectorProvider.ConnectionFactory buildConnectionFactoryWithProxy(String proxyHost, Integer proxyPort, Proxy.Type proxyType) {
        final Proxy proxy = new Proxy(proxyType, new InetSocketAddress(proxyHost, (int)proxyPort));
        HttpUrlConnectorProvider.ConnectionFactory connectionFactory = new HttpUrlConnectorProvider.ConnectionFactory(){

            public HttpURLConnection getConnection(URL url) throws IOException {
                return (HttpURLConnection)url.openConnection(proxy);
            }
        };
        return connectionFactory;
    }

    private static void configureProxyAuthentication(final String proxyUser, String proxyPassword) {
        if (proxyPassword == null) {
            proxyPassword = "";
        }
        final String secret = proxyPassword;
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(proxyUser, secret.toCharArray());
            }
        });
    }
}

