/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.client;

import com.kiuwan.client.ClientHelper;
import com.kiuwan.client.KiuwanClientException;
import com.kiuwan.client.model.AnalysisBean;
import com.kiuwan.client.model.AnalysisComparation;
import com.kiuwan.client.model.Application;
import com.kiuwan.client.model.ApplicationDefects;
import com.kiuwan.client.model.ApplicationFiles;
import com.kiuwan.client.model.ApplicationResults;
import com.kiuwan.client.model.AuditResultBean;
import com.kiuwan.client.model.Defect;
import com.kiuwan.client.model.File;
import com.kiuwan.client.model.management.applications.ApplicationBean;
import com.kiuwan.client.model.management.users.UserBean;
import com.kiuwan.client.model.management.users.groups.UserGroupBean;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.filter.LoggingFilter;

public class KiuwanRestApiClient {
    protected static final String REST_API_BASE_URL = "https://api.kiuwan.com";
    private static final String CSRF_TOKEN_HEADER = "X-CSRF-TOKEN";
    private WebTarget connection;
    private static String csrfToken;
    private static Map<String, Cookie> cookies;

    public KiuwanRestApiClient(String user, String password) {
        this.initializeConnection(user, password, REST_API_BASE_URL);
    }

    public KiuwanRestApiClient(String user, String password, String restApiBaseUrl) {
        this.initializeConnection(user, password, restApiBaseUrl);
    }

    public KiuwanRestApiClient(String user, String password, String proxyHost, Integer proxyPort, Proxy.Type proxyType) {
        this.initializeConnection(user, password, REST_API_BASE_URL, proxyHost, proxyPort, proxyType, null, null);
    }

    public KiuwanRestApiClient(String user, String password, String restApiBaseUrl, String proxyHost, Integer proxyPort, Proxy.Type proxyType) {
        this.initializeConnection(user, password, restApiBaseUrl, proxyHost, proxyPort, proxyType, null, null);
    }

    public KiuwanRestApiClient(String user, String password, String proxyHost, Integer proxyPort, Proxy.Type proxyType, String proxyUser, String proxyPassword) {
        this.initializeConnection(user, password, REST_API_BASE_URL, proxyHost, proxyPort, proxyType, proxyUser, proxyPassword);
    }

    public KiuwanRestApiClient(String user, String password, String restApiBaseUrl, String proxyHost, Integer proxyPort, Proxy.Type proxyType, String proxyUser, String proxyPassword) {
        this.initializeConnection(user, password, restApiBaseUrl, proxyHost, proxyPort, proxyType, proxyUser, proxyPassword);
    }

    public void activateLog() {
        this.connection.register((Object)new LoggingFilter());
    }

    public List<Application> getApplications() throws KiuwanClientException {
        String path = "/apps/list";
        Response response = this.get(path);
        this.checkStatus(response, 200);
        try {
            return (List)response.readEntity((GenericType)new GenericType<List<Application>>(){});
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public ApplicationResults getApplicationResults(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName;
        return this.requestAndBuildApplicationResults(path);
    }

    public ApplicationResults getApplicationResultsByAnalysisCode(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode;
        return this.requestAndBuildApplicationResults(path);
    }

    public ApplicationResults requestAndBuildApplicationResults(String path) throws KiuwanClientException {
        Response response = this.get(path);
        this.checkStatus(response, 200);
        try {
            return (ApplicationResults)response.readEntity(ApplicationResults.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public AnalysisComparation requestAndBuildAnalysisComparation(String path) throws KiuwanClientException {
        Response response = this.get(path);
        this.checkStatus(response, 200);
        try {
            return (AnalysisComparation)response.readEntity(AnalysisComparation.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<File> getAllFiles(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        ArrayList<File> files = new ArrayList<File>();
        int page = 1;
        int count = 0;
        do {
            ApplicationFiles appFiles;
            if ((appFiles = this.getApplicationFilesPage(appName, page++, 500)) == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = appFiles.getFiles().size();
            files.addAll(appFiles.getFiles());
        } while (count == 500);
        return files;
    }

    public List<File> getAllAnalysisFiles(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        ArrayList<File> files = new ArrayList<File>();
        int page = 1;
        int count = 0;
        do {
            ApplicationFiles appFiles;
            if ((appFiles = this.getAnalysisFilesPage(analysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = appFiles.getFiles().size();
            files.addAll(appFiles.getFiles());
        } while (count == 500);
        return files;
    }

    private ApplicationFiles getApplicationFilesPage(String appName, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName + "/files";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (ApplicationFiles)response.readEntity(ApplicationFiles.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationFiles getAnalysisFilesPage(String analysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode + "/files";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (ApplicationFiles)response.readEntity(ApplicationFiles.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<Defect> getAllDefects(String appName) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            ApplicationDefects appDefects;
            if ((appDefects = this.getApplicationDefectsPage(appName, page++, 500)) == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = appDefects.getDefects().size();
            defects.addAll(appDefects.getDefects());
        } while (count == 500);
        return defects;
    }

    public Map<String, Double> getMetrics(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/metrics";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("code", new String[]{analysisCode});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (Map)response.readEntity((GenericType)new GenericType<Map<String, Double>>(){});
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<Defect> getAllAnalysisDefects(String analysisCode) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            ApplicationDefects appDefects;
            if ((appDefects = this.getAnalysisDefectsPage(analysisCode, page++, 500)) == null || appDefects.getDefects() == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = appDefects.getDefects().size();
            defects.addAll(appDefects.getDefects());
        } while (count == 500);
        return defects;
    }

    private ApplicationDefects getApplicationDefectsPage(String appName, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (appName == null || appName.isEmpty()) {
            throw new KiuwanClientException("Invalid application name");
        }
        String path = "/apps/" + appName + "/defects";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (ApplicationDefects)response.readEntity(ApplicationDefects.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private ApplicationDefects getAnalysisDefectsPage(String analysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (analysisCode == null || analysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid analysis code");
        }
        String path = "/apps/analysis/" + analysisCode + "/defects";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (ApplicationDefects)response.readEntity(ApplicationDefects.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public AnalysisComparation getAnalysisComparation(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode;
        return this.requestAndBuildAnalysisComparation(path);
    }

    public List<Defect> getAllNewDefects(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            AnalysisComparation analysisComparation;
            if ((analysisComparation = this.getNewDefectsPage(mainAnalysisCode, previousAnalysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = analysisComparation.getNewDefects().size();
            defects.addAll(analysisComparation.getNewDefects());
        } while (count == 500);
        return defects;
    }

    public List<AnalysisBean> getAnalyses(String application) throws KiuwanClientException {
        String path = "/apps/" + application + "/analyses";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (List)response.readEntity((GenericType)new GenericType<List<AnalysisBean>>(){});
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private AnalysisComparation getNewDefectsPage(String mainAnalysisCode, String previousAnalysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode + "/new";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (AnalysisComparation)response.readEntity(AnalysisComparation.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    public List<Defect> getAllRemovedDefects(String mainAnalysisCode, String previousAnalysisCode) throws KiuwanClientException {
        ArrayList<Defect> defects = new ArrayList<Defect>();
        int page = 1;
        int count = 0;
        do {
            AnalysisComparation analysisComparation;
            if ((analysisComparation = this.getRemovedDefectsPage(mainAnalysisCode, previousAnalysisCode, page++, 500)) == null) {
                throw new KiuwanClientException("Unknown error");
            }
            count = analysisComparation.getRemovedDefects().size();
            defects.addAll(analysisComparation.getRemovedDefects());
        } while (count == 500);
        return defects;
    }

    public String createApplications(List<ApplicationBean> applications) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String path = "/applications";
        for (ApplicationBean applicationBean : applications) {
            Response response = this.post(path, applicationBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(applicationBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String modifyApplications(List<ApplicationBean> applications) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/applications";
        for (ApplicationBean applicationBean : applications) {
            Response response = this.put(parentPath + "/" + applicationBean.getName(), applicationBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(applicationBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String deleteApplications(List<ApplicationBean> applications) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/applications";
        for (ApplicationBean applicationBean : applications) {
            Response response = this.delete(parentPath + "/" + applicationBean.getName());
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(applicationBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String createUsers(List<UserBean> userBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String path = "/users";
        for (UserBean userBean : userBeans) {
            Response response = this.post(path, userBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userBean.getUsername() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String createUserGroups(List<UserGroupBean> userGroupBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String path = "/userGroups";
        for (UserGroupBean userGroupBean : userGroupBeans) {
            Response response = this.post(path, userGroupBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userGroupBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String modifyUsers(List<UserBean> userBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/users";
        for (UserBean userBean : userBeans) {
            Response response = this.put(parentPath + "/" + userBean.getUsername(), userBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userBean.getUsername() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String modifyUserGroups(List<UserGroupBean> userGroupBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/userGroups";
        for (UserGroupBean userGroupBean : userGroupBeans) {
            Response response = this.put(parentPath + "/" + userGroupBean.getName(), userGroupBean);
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userGroupBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String deleteUsers(List<UserBean> userBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/users";
        for (UserBean userBean : userBeans) {
            Response response = this.delete(parentPath + "/" + userBean.getUsername());
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userBean.getUsername() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public String deleteUserGroups(List<UserGroupBean> userGroupBeans) throws KiuwanClientException {
        StringBuilder results = new StringBuilder();
        String parentPath = "/userGroups";
        for (UserGroupBean userGroupBean : userGroupBeans) {
            Response response = this.delete(parentPath + "/" + userGroupBean.getName());
            String resultMessage = "";
            try {
                resultMessage = (String)response.readEntity(String.class);
            }
            catch (Exception e) {
                resultMessage = "ERROR: " + e.getMessage();
            }
            results.append(userGroupBean.getName() + " -> " + resultMessage + "\n");
        }
        return results.toString();
    }

    public List<UserBean> listUsers() throws KiuwanClientException {
        String path = "/users";
        Response response = this.get(path);
        this.checkStatus(response, 200);
        ArrayList<UserBean> users = new ArrayList();
        try {
            users = (List)response.readEntity((GenericType)new GenericType<List<UserBean>>(){});
        }
        catch (Exception e) {
            throw new KiuwanClientException("Unknown error");
        }
        return users;
    }

    public List<UserGroupBean> listUserGroups() throws KiuwanClientException {
        String path = "/userGroups";
        Response response = this.get(path);
        this.checkStatus(response, 200);
        ArrayList<UserGroupBean> userGroups = new ArrayList();
        try {
            userGroups = (List)response.readEntity((GenericType)new GenericType<List<UserGroupBean>>(){});
        }
        catch (Exception e) {
            throw new KiuwanClientException("Unknown error");
        }
        return userGroups;
    }

    public String sendAuditResult(String analysisCode, Boolean passAudit) throws KiuwanClientException {
        String path = "/auditresults";
        AuditResultBean auditResultBean = new AuditResultBean();
        auditResultBean.setAnalysisCode(analysisCode);
        auditResultBean.setPassAudit(passAudit);
        Response response = this.post(path, auditResultBean);
        this.checkStatus(response, 200);
        String resultMessage = null;
        try {
            resultMessage = (String)response.readEntity(String.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException("Unknown error");
        }
        return resultMessage;
    }

    private void initializeConnection(String user, String password, String restApiBaseUrl) {
        this.connection = ((Client)ClientHelper.createClient().register((Object)HttpAuthenticationFeature.basic((String)user, (String)password))).target(restApiBaseUrl);
    }

    private void initializeConnection(String user, String password, String restApiBaseUrl, String proxyHost, Integer proxyPort, Proxy.Type proxyType, String proxyUser, String proxyPassword) {
        this.connection = ((Client)ClientHelper.createClient(proxyHost, proxyPort, proxyType, proxyUser, proxyPassword).register((Object)HttpAuthenticationFeature.basic((String)user, (String)password))).target(restApiBaseUrl);
    }

    private AnalysisComparation getRemovedDefectsPage(String mainAnalysisCode, String previousAnalysisCode, Integer pageNumber, Integer defectsPerPage) throws KiuwanClientException {
        if (mainAnalysisCode == null || mainAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid mainAnalysisCode");
        }
        if (previousAnalysisCode == null || previousAnalysisCode.isEmpty()) {
            throw new KiuwanClientException("Invalid previousAnalysisCode");
        }
        String path = "/apps/analysis/" + mainAnalysisCode + "/defects/compare/" + previousAnalysisCode + "/removed";
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("page", new String[]{pageNumber.toString()});
        queryParams.put("count", new String[]{defectsPerPage.toString()});
        Response response = this.get(path, queryParams);
        this.checkStatus(response, 200);
        try {
            return (AnalysisComparation)response.readEntity(AnalysisComparation.class);
        }
        catch (Exception e) {
            throw new KiuwanClientException(e);
        }
    }

    private Response get(String resource) {
        Invocation.Builder request = this.connection.path(resource).request();
        this.setCookies(request);
        this.setCsrfToken(request);
        Response response = (Response)request.get(Response.class);
        this.saveCookies(response);
        this.saveCsrfToken(response);
        return response;
    }

    private Response delete(String resource) {
        Invocation.Builder request = this.connection.path(resource).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.setCookies(request);
        this.setCsrfToken(request);
        Response response = (Response)request.delete(Response.class);
        this.saveCookies(response);
        this.saveCsrfToken(response);
        return response;
    }

    private Response put(String resource, Object content) {
        Invocation.Builder request = this.connection.path(resource).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.setCookies(request);
        this.setCsrfToken(request);
        Response response = (Response)request.put(Entity.entity((Object)content, (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        this.saveCookies(response);
        this.saveCsrfToken(response);
        return response;
    }

    private Response post(String resource, Object content) {
        Invocation.Builder request = this.connection.path(resource).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.setCookies(request);
        this.setCsrfToken(request);
        Response response = (Response)request.post(Entity.entity((Object)content, (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        this.saveCookies(response);
        this.saveCsrfToken(response);
        return response;
    }

    private Response get(String resource, Map<String, String[]> queryParams) {
        WebTarget path = this.connection.path(resource);
        for (String parameter : queryParams.keySet()) {
            path = path.queryParam(parameter, (Object[])queryParams.get(parameter));
        }
        Invocation.Builder request = path.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        this.setCookies(request);
        this.setCsrfToken(request);
        Response response = (Response)request.get(Response.class);
        this.saveCookies(response);
        this.saveCsrfToken(response);
        return response;
    }

    private void setCookies(Invocation.Builder request) {
        for (Cookie cookie : cookies.values()) {
            request.cookie(cookie);
        }
    }

    private void setCsrfToken(Invocation.Builder request) {
        String csrfToken = KiuwanRestApiClient.csrfToken;
        if (csrfToken != null) {
            request.header(CSRF_TOKEN_HEADER, (Object)csrfToken);
        }
    }

    private void saveCsrfToken(Response response) {
        String token = response.getHeaderString(CSRF_TOKEN_HEADER);
        if (token != null) {
            csrfToken = token;
        }
    }

    private void saveCookies(Response response) {
        Map cookies = response.getCookies();
        if (cookies != null) {
            KiuwanRestApiClient.cookies.putAll(cookies);
        }
    }

    private void checkStatus(Response response, int checkStatus) throws KiuwanClientException {
        int status = response.getStatus();
        if (status != checkStatus) {
            throw KiuwanClientException.createResponseStatusException(status);
        }
    }

    static {
        cookies = new HashMap<String, Cookie>();
    }
}

