/*
 * Decompiled with CFR 0.152.
 */
package com.kiuwan.client.examples;

import com.kiuwan.client.KiuwanClientException;
import com.kiuwan.client.KiuwanRestApiClient;
import com.kiuwan.client.model.management.users.AccessControlConfigurationBean;
import com.kiuwan.client.model.management.users.PortfolioRoleBean;
import com.kiuwan.client.model.management.users.groups.UserGroupBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class ModifyUserGroups {
    public static void main(String[] args) throws KiuwanClientException {
        if (args.length != 2) {
            System.out.println("You need to pass 2 parameters: username password");
            return;
        }
        String username = args[0];
        String password = args[1];
        UserGroupBean userGroupBean = new UserGroupBean();
        userGroupBean.setName("TheGroup");
        userGroupBean.setNewName("MyGroup");
        userGroupBean.setUsers(Arrays.asList("john@mycompany.com", "emily@mycompany.com"));
        PortfolioRoleBean portfolioRoleBean = new PortfolioRoleBean();
        portfolioRoleBean.setPortfolioName("TechPortfolio");
        portfolioRoleBean.setPortfolioValue("C-SharpApplications");
        portfolioRoleBean.setRoleName("Readonly");
        ArrayList<PortfolioRoleBean> portfolioRoles = new ArrayList<PortfolioRoleBean>();
        portfolioRoles.add(portfolioRoleBean);
        AccessControlConfigurationBean accessControlConfiguration = new AccessControlConfigurationBean();
        accessControlConfiguration.setPortfolioRoles(portfolioRoles);
        accessControlConfiguration.setAssignmentMode("ADD");
        userGroupBean.setAccessControlConfiguration(accessControlConfiguration);
        KiuwanRestApiClient client = new KiuwanRestApiClient(username, password);
        String result = client.modifyUserGroups(Collections.singletonList(userGroupBean));
        System.out.println(result);
    }
}

