/*
 * Decompiled with CFR 0.152.
 */
package com.konfigthis.splitit.client;

import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private Long roundTripTime = null;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody, Long roundTripTime) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.roundTripTime = roundTripTime;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody, Long roundTripTime) {
        this(message, null, code, responseHeaders, responseBody, roundTripTime);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, Long roundTripTime) {
        this(message, throwable, code, responseHeaders, null, roundTripTime);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody, null);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getStatusCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Long getRoundTripTime() {
        return this.roundTripTime;
    }

    @Override
    public String getMessage() {
        return String.format("Message: %s%nHTTP response code: %s%nHTTP response body: %s%nHTTP response headers: %s", super.getMessage(), this.getStatusCode(), this.getResponseBody(), this.getResponseHeaders());
    }
}

