/*
 * splitit-web-api-v3
 * Splitit's Web API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by Konfig (https://konfigthis.com).
 * Do not edit the class manually.
 */


package com.konfigthis.splitit.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.konfigthis.splitit.client.model.CardData2;
import com.konfigthis.splitit.client.model.ConsumerData;
import com.konfigthis.splitit.client.model.Disputes;
import com.konfigthis.splitit.client.model.ExternalProviderTypes;
import com.konfigthis.splitit.client.model.FraudCheck;
import com.konfigthis.splitit.client.model.Installment2;
import com.konfigthis.splitit.client.model.MerchantRef;
import com.konfigthis.splitit.client.model.Money;
import com.konfigthis.splitit.client.model.MoneyFlows;
import com.konfigthis.splitit.client.model.ReAuthorization;
import com.konfigthis.splitit.client.model.ReferenceEntityBase;
import com.konfigthis.splitit.client.model.TerminalRef;
import com.konfigthis.splitit.client.model.TestModes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.konfigthis.splitit.client.JSON;

/**
 * InstallmentPlan
 */@javax.annotation.Generated(value = "Generated by https://konfigthis.com")
public class InstallmentPlan {
  public static final String SERIALIZED_NAME_INSTALLMENT_PLAN_NUMBER = "InstallmentPlanNumber";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_PLAN_NUMBER)
  private String installmentPlanNumber;

  public static final String SERIALIZED_NAME_INSTALLMENT_PLAN_STATUS = "InstallmentPlanStatus";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_PLAN_STATUS)
  private ReferenceEntityBase installmentPlanStatus;

  public static final String SERIALIZED_NAME_AMOUNT = "Amount";
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private Money amount;

  public static final String SERIALIZED_NAME_OUTSTANDING_AMOUNT = "OutstandingAmount";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_AMOUNT)
  private Money outstandingAmount;

  public static final String SERIALIZED_NAME_DISPUTES = "Disputes";
  @SerializedName(SERIALIZED_NAME_DISPUTES)
  private Disputes disputes;

  public static final String SERIALIZED_NAME_NUMBER_OF_INSTALLMENTS = "NumberOfInstallments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_INSTALLMENTS)
  private Integer numberOfInstallments;

  public static final String SERIALIZED_NAME_NUMBER_OF_PROCESSED_INSTALLMENTS = "NumberOfProcessedInstallments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_PROCESSED_INSTALLMENTS)
  private Integer numberOfProcessedInstallments;

  public static final String SERIALIZED_NAME_ORIGINAL_AMOUNT = "OriginalAmount";
  @SerializedName(SERIALIZED_NAME_ORIGINAL_AMOUNT)
  private Money originalAmount;

  public static final String SERIALIZED_NAME_REFUND_AMOUNT = "RefundAmount";
  @SerializedName(SERIALIZED_NAME_REFUND_AMOUNT)
  private Money refundAmount;

  public static final String SERIALIZED_NAME_CONSUMER = "Consumer";
  @SerializedName(SERIALIZED_NAME_CONSUMER)
  private ConsumerData consumer;

  public static final String SERIALIZED_NAME_ACTIVE_CARD = "ActiveCard";
  @SerializedName(SERIALIZED_NAME_ACTIVE_CARD)
  private CardData2 activeCard;

  public static final String SERIALIZED_NAME_FRAUD_CHECK = "FraudCheck";
  @SerializedName(SERIALIZED_NAME_FRAUD_CHECK)
  private FraudCheck fraudCheck;

  public static final String SERIALIZED_NAME_TERMINAL = "Terminal";
  @SerializedName(SERIALIZED_NAME_TERMINAL)
  private TerminalRef terminal;

  public static final String SERIALIZED_NAME_MERCHANT = "Merchant";
  @SerializedName(SERIALIZED_NAME_MERCHANT)
  private MerchantRef merchant;

  public static final String SERIALIZED_NAME_REF_ORDER_NUMBER = "RefOrderNumber";
  @SerializedName(SERIALIZED_NAME_REF_ORDER_NUMBER)
  private String refOrderNumber;

  public static final String SERIALIZED_NAME_PURCHASE_METHOD = "PurchaseMethod";
  @SerializedName(SERIALIZED_NAME_PURCHASE_METHOD)
  private ReferenceEntityBase purchaseMethod;

  public static final String SERIALIZED_NAME_STRATEGY = "Strategy";
  @SerializedName(SERIALIZED_NAME_STRATEGY)
  private ReferenceEntityBase strategy;

  public static final String SERIALIZED_NAME_DELAY_RESOLUTION = "DelayResolution";
  @SerializedName(SERIALIZED_NAME_DELAY_RESOLUTION)
  private ReferenceEntityBase delayResolution;

  public static final String SERIALIZED_NAME_EXTENDED_PARAMS = "ExtendedParams";
  @SerializedName(SERIALIZED_NAME_EXTENDED_PARAMS)
  private Map<String, String> extendedParams = null;

  public static final String SERIALIZED_NAME_IS_FULL_CAPTURED = "IsFullCaptured";
  @SerializedName(SERIALIZED_NAME_IS_FULL_CAPTURED)
  private Boolean isFullCaptured;

  public static final String SERIALIZED_NAME_IS_CHARGED_BACK = "IsChargedBack";
  @SerializedName(SERIALIZED_NAME_IS_CHARGED_BACK)
  private Boolean isChargedBack;

  public static final String SERIALIZED_NAME_ARE_PAYMENTS_ON_HOLD = "ArePaymentsOnHold";
  @SerializedName(SERIALIZED_NAME_ARE_PAYMENTS_ON_HOLD)
  private Boolean arePaymentsOnHold;

  public static final String SERIALIZED_NAME_SCP_FUNDING_PERCENT = "ScpFundingPercent";
  @SerializedName(SERIALIZED_NAME_SCP_FUNDING_PERCENT)
  private Double scpFundingPercent;

  public static final String SERIALIZED_NAME_FUNDING_STATUS = "FundingStatus";
  @SerializedName(SERIALIZED_NAME_FUNDING_STATUS)
  private MoneyFlows fundingStatus;

  public static final String SERIALIZED_NAME_TEST_MODE = "TestMode";
  @SerializedName(SERIALIZED_NAME_TEST_MODE)
  private TestModes testMode;

  public static final String SERIALIZED_NAME_CREATION_DATE_TIME = "CreationDateTime";
  @SerializedName(SERIALIZED_NAME_CREATION_DATE_TIME)
  private OffsetDateTime creationDateTime;

  public static final String SERIALIZED_NAME_LIFE_TIME_URL_EXPIRATION_TIME = "LifeTimeUrlExpirationTime";
  @SerializedName(SERIALIZED_NAME_LIFE_TIME_URL_EXPIRATION_TIME)
  private OffsetDateTime lifeTimeUrlExpirationTime;

  public static final String SERIALIZED_NAME_INSTALLMENTS = "Installments";
  @SerializedName(SERIALIZED_NAME_INSTALLMENTS)
  private List<Installment2> installments = null;

  public static final String SERIALIZED_NAME_SECURE_AUTHORIZATIONS = "SecureAuthorizations";
  @SerializedName(SERIALIZED_NAME_SECURE_AUTHORIZATIONS)
  private List<ReAuthorization> secureAuthorizations = null;

  public static final String SERIALIZED_NAME_LOGO_URL = "LogoUrl";
  @SerializedName(SERIALIZED_NAME_LOGO_URL)
  private String logoUrl;

  public static final String SERIALIZED_NAME_IS_IN_AUTO_RETRY = "IsInAutoRetry";
  @SerializedName(SERIALIZED_NAME_IS_IN_AUTO_RETRY)
  private Boolean isInAutoRetry;

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "PaymentMethod";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private String paymentMethod;

  public static final String SERIALIZED_NAME_ALLOW_CARD_UPDATE_ON_SPLITIT_PORTALS = "AllowCardUpdateOnSplititPortals";
  @SerializedName(SERIALIZED_NAME_ALLOW_CARD_UPDATE_ON_SPLITIT_PORTALS)
  private Boolean allowCardUpdateOnSplititPortals;

  public static final String SERIALIZED_NAME_ON_HOLD_LAST_OPEN_DATE = "OnHoldLastOpenDate";
  @SerializedName(SERIALIZED_NAME_ON_HOLD_LAST_OPEN_DATE)
  private OffsetDateTime onHoldLastOpenDate;

  public static final String SERIALIZED_NAME_ON_HOLD_LAST_OPEN_USER_ID = "OnHoldLastOpenUserId";
  @SerializedName(SERIALIZED_NAME_ON_HOLD_LAST_OPEN_USER_ID)
  private String onHoldLastOpenUserId;

  public static final String SERIALIZED_NAME_INSTALLMENTS_SCHEDULE_INTERVAL = "InstallmentsScheduleInterval";
  @SerializedName(SERIALIZED_NAME_INSTALLMENTS_SCHEDULE_INTERVAL)
  private Integer installmentsScheduleInterval;

  public static final String SERIALIZED_NAME_EXTERNAL_PAYMENT_PROVIDER = "ExternalPaymentProvider";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_PAYMENT_PROVIDER)
  private ExternalProviderTypes externalPaymentProvider;

  public InstallmentPlan() {
  }

  public InstallmentPlan installmentPlanNumber(String installmentPlanNumber) {
    
    
    
    
    this.installmentPlanNumber = installmentPlanNumber;
    return this;
  }

   /**
   * Get installmentPlanNumber
   * @return installmentPlanNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getInstallmentPlanNumber() {
    return installmentPlanNumber;
  }


  public void setInstallmentPlanNumber(String installmentPlanNumber) {
    
    
    
    this.installmentPlanNumber = installmentPlanNumber;
  }


  public InstallmentPlan installmentPlanStatus(ReferenceEntityBase installmentPlanStatus) {
    
    
    
    
    this.installmentPlanStatus = installmentPlanStatus;
    return this;
  }

   /**
   * Get installmentPlanStatus
   * @return installmentPlanStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ReferenceEntityBase getInstallmentPlanStatus() {
    return installmentPlanStatus;
  }


  public void setInstallmentPlanStatus(ReferenceEntityBase installmentPlanStatus) {
    
    
    
    this.installmentPlanStatus = installmentPlanStatus;
  }


  public InstallmentPlan amount(Money amount) {
    
    
    
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Money getAmount() {
    return amount;
  }


  public void setAmount(Money amount) {
    
    
    
    this.amount = amount;
  }


  public InstallmentPlan outstandingAmount(Money outstandingAmount) {
    
    
    
    
    this.outstandingAmount = outstandingAmount;
    return this;
  }

   /**
   * Get outstandingAmount
   * @return outstandingAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Money getOutstandingAmount() {
    return outstandingAmount;
  }


  public void setOutstandingAmount(Money outstandingAmount) {
    
    
    
    this.outstandingAmount = outstandingAmount;
  }


  public InstallmentPlan disputes(Disputes disputes) {
    
    
    
    
    this.disputes = disputes;
    return this;
  }

   /**
   * Get disputes
   * @return disputes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Disputes getDisputes() {
    return disputes;
  }


  public void setDisputes(Disputes disputes) {
    
    
    
    this.disputes = disputes;
  }


  public InstallmentPlan numberOfInstallments(Integer numberOfInstallments) {
    
    
    
    
    this.numberOfInstallments = numberOfInstallments;
    return this;
  }

   /**
   * Get numberOfInstallments
   * @return numberOfInstallments
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Integer getNumberOfInstallments() {
    return numberOfInstallments;
  }


  public void setNumberOfInstallments(Integer numberOfInstallments) {
    
    
    
    this.numberOfInstallments = numberOfInstallments;
  }


  public InstallmentPlan numberOfProcessedInstallments(Integer numberOfProcessedInstallments) {
    
    
    
    
    this.numberOfProcessedInstallments = numberOfProcessedInstallments;
    return this;
  }

   /**
   * Get numberOfProcessedInstallments
   * @return numberOfProcessedInstallments
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Integer getNumberOfProcessedInstallments() {
    return numberOfProcessedInstallments;
  }


  public void setNumberOfProcessedInstallments(Integer numberOfProcessedInstallments) {
    
    
    
    this.numberOfProcessedInstallments = numberOfProcessedInstallments;
  }


  public InstallmentPlan originalAmount(Money originalAmount) {
    
    
    
    
    this.originalAmount = originalAmount;
    return this;
  }

   /**
   * Get originalAmount
   * @return originalAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Money getOriginalAmount() {
    return originalAmount;
  }


  public void setOriginalAmount(Money originalAmount) {
    
    
    
    this.originalAmount = originalAmount;
  }


  public InstallmentPlan refundAmount(Money refundAmount) {
    
    
    
    
    this.refundAmount = refundAmount;
    return this;
  }

   /**
   * Get refundAmount
   * @return refundAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Money getRefundAmount() {
    return refundAmount;
  }


  public void setRefundAmount(Money refundAmount) {
    
    
    
    this.refundAmount = refundAmount;
  }


  public InstallmentPlan consumer(ConsumerData consumer) {
    
    
    
    
    this.consumer = consumer;
    return this;
  }

   /**
   * Get consumer
   * @return consumer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ConsumerData getConsumer() {
    return consumer;
  }


  public void setConsumer(ConsumerData consumer) {
    
    
    
    this.consumer = consumer;
  }


  public InstallmentPlan activeCard(CardData2 activeCard) {
    
    
    
    
    this.activeCard = activeCard;
    return this;
  }

   /**
   * Get activeCard
   * @return activeCard
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public CardData2 getActiveCard() {
    return activeCard;
  }


  public void setActiveCard(CardData2 activeCard) {
    
    
    
    this.activeCard = activeCard;
  }


  public InstallmentPlan fraudCheck(FraudCheck fraudCheck) {
    
    
    
    
    this.fraudCheck = fraudCheck;
    return this;
  }

   /**
   * Get fraudCheck
   * @return fraudCheck
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public FraudCheck getFraudCheck() {
    return fraudCheck;
  }


  public void setFraudCheck(FraudCheck fraudCheck) {
    
    
    
    this.fraudCheck = fraudCheck;
  }


  public InstallmentPlan terminal(TerminalRef terminal) {
    
    
    
    
    this.terminal = terminal;
    return this;
  }

   /**
   * Get terminal
   * @return terminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TerminalRef getTerminal() {
    return terminal;
  }


  public void setTerminal(TerminalRef terminal) {
    
    
    
    this.terminal = terminal;
  }


  public InstallmentPlan merchant(MerchantRef merchant) {
    
    
    
    
    this.merchant = merchant;
    return this;
  }

   /**
   * Get merchant
   * @return merchant
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public MerchantRef getMerchant() {
    return merchant;
  }


  public void setMerchant(MerchantRef merchant) {
    
    
    
    this.merchant = merchant;
  }


  public InstallmentPlan refOrderNumber(String refOrderNumber) {
    
    
    
    
    this.refOrderNumber = refOrderNumber;
    return this;
  }

   /**
   * Get refOrderNumber
   * @return refOrderNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getRefOrderNumber() {
    return refOrderNumber;
  }


  public void setRefOrderNumber(String refOrderNumber) {
    
    
    
    this.refOrderNumber = refOrderNumber;
  }


  public InstallmentPlan purchaseMethod(ReferenceEntityBase purchaseMethod) {
    
    
    
    
    this.purchaseMethod = purchaseMethod;
    return this;
  }

   /**
   * Get purchaseMethod
   * @return purchaseMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ReferenceEntityBase getPurchaseMethod() {
    return purchaseMethod;
  }


  public void setPurchaseMethod(ReferenceEntityBase purchaseMethod) {
    
    
    
    this.purchaseMethod = purchaseMethod;
  }


  public InstallmentPlan strategy(ReferenceEntityBase strategy) {
    
    
    
    
    this.strategy = strategy;
    return this;
  }

   /**
   * Get strategy
   * @return strategy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ReferenceEntityBase getStrategy() {
    return strategy;
  }


  public void setStrategy(ReferenceEntityBase strategy) {
    
    
    
    this.strategy = strategy;
  }


  public InstallmentPlan delayResolution(ReferenceEntityBase delayResolution) {
    
    
    
    
    this.delayResolution = delayResolution;
    return this;
  }

   /**
   * Get delayResolution
   * @return delayResolution
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ReferenceEntityBase getDelayResolution() {
    return delayResolution;
  }


  public void setDelayResolution(ReferenceEntityBase delayResolution) {
    
    
    
    this.delayResolution = delayResolution;
  }


  public InstallmentPlan extendedParams(Map<String, String> extendedParams) {
    
    
    
    
    this.extendedParams = extendedParams;
    return this;
  }

  public InstallmentPlan putExtendedParamsItem(String key, String extendedParamsItem) {
    if (this.extendedParams == null) {
      this.extendedParams = new HashMap<>();
    }
    this.extendedParams.put(key, extendedParamsItem);
    return this;
  }

   /**
   * Get extendedParams
   * @return extendedParams
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, String> getExtendedParams() {
    return extendedParams;
  }


  public void setExtendedParams(Map<String, String> extendedParams) {
    
    
    
    this.extendedParams = extendedParams;
  }


  public InstallmentPlan isFullCaptured(Boolean isFullCaptured) {
    
    
    
    
    this.isFullCaptured = isFullCaptured;
    return this;
  }

   /**
   * Get isFullCaptured
   * @return isFullCaptured
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Boolean getIsFullCaptured() {
    return isFullCaptured;
  }


  public void setIsFullCaptured(Boolean isFullCaptured) {
    
    
    
    this.isFullCaptured = isFullCaptured;
  }


  public InstallmentPlan isChargedBack(Boolean isChargedBack) {
    
    
    
    
    this.isChargedBack = isChargedBack;
    return this;
  }

   /**
   * Get isChargedBack
   * @return isChargedBack
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Boolean getIsChargedBack() {
    return isChargedBack;
  }


  public void setIsChargedBack(Boolean isChargedBack) {
    
    
    
    this.isChargedBack = isChargedBack;
  }


  public InstallmentPlan arePaymentsOnHold(Boolean arePaymentsOnHold) {
    
    
    
    
    this.arePaymentsOnHold = arePaymentsOnHold;
    return this;
  }

   /**
   * Get arePaymentsOnHold
   * @return arePaymentsOnHold
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Boolean getArePaymentsOnHold() {
    return arePaymentsOnHold;
  }


  public void setArePaymentsOnHold(Boolean arePaymentsOnHold) {
    
    
    
    this.arePaymentsOnHold = arePaymentsOnHold;
  }


  public InstallmentPlan scpFundingPercent(Double scpFundingPercent) {
    
    
    
    
    this.scpFundingPercent = scpFundingPercent;
    return this;
  }

  public InstallmentPlan scpFundingPercent(Integer scpFundingPercent) {
    
    
    
    
    this.scpFundingPercent = scpFundingPercent.doubleValue();
    return this;
  }

   /**
   * Get scpFundingPercent
   * @return scpFundingPercent
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Double getScpFundingPercent() {
    return scpFundingPercent;
  }


  public void setScpFundingPercent(Double scpFundingPercent) {
    
    
    
    this.scpFundingPercent = scpFundingPercent;
  }


  public InstallmentPlan fundingStatus(MoneyFlows fundingStatus) {
    
    
    
    
    this.fundingStatus = fundingStatus;
    return this;
  }

   /**
   * Get fundingStatus
   * @return fundingStatus
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public MoneyFlows getFundingStatus() {
    return fundingStatus;
  }


  public void setFundingStatus(MoneyFlows fundingStatus) {
    
    
    
    this.fundingStatus = fundingStatus;
  }


  public InstallmentPlan testMode(TestModes testMode) {
    
    
    
    
    this.testMode = testMode;
    return this;
  }

   /**
   * Get testMode
   * @return testMode
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public TestModes getTestMode() {
    return testMode;
  }


  public void setTestMode(TestModes testMode) {
    
    
    
    this.testMode = testMode;
  }


  public InstallmentPlan creationDateTime(OffsetDateTime creationDateTime) {
    
    
    
    
    this.creationDateTime = creationDateTime;
    return this;
  }

   /**
   * Get creationDateTime
   * @return creationDateTime
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getCreationDateTime() {
    return creationDateTime;
  }


  public void setCreationDateTime(OffsetDateTime creationDateTime) {
    
    
    
    this.creationDateTime = creationDateTime;
  }


  public InstallmentPlan lifeTimeUrlExpirationTime(OffsetDateTime lifeTimeUrlExpirationTime) {
    
    
    
    
    this.lifeTimeUrlExpirationTime = lifeTimeUrlExpirationTime;
    return this;
  }

   /**
   * Get lifeTimeUrlExpirationTime
   * @return lifeTimeUrlExpirationTime
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public OffsetDateTime getLifeTimeUrlExpirationTime() {
    return lifeTimeUrlExpirationTime;
  }


  public void setLifeTimeUrlExpirationTime(OffsetDateTime lifeTimeUrlExpirationTime) {
    
    
    
    this.lifeTimeUrlExpirationTime = lifeTimeUrlExpirationTime;
  }


  public InstallmentPlan installments(List<Installment2> installments) {
    
    
    
    
    this.installments = installments;
    return this;
  }

  public InstallmentPlan addInstallmentsItem(Installment2 installmentsItem) {
    if (this.installments == null) {
      this.installments = new ArrayList<>();
    }
    this.installments.add(installmentsItem);
    return this;
  }

   /**
   * Get installments
   * @return installments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<Installment2> getInstallments() {
    return installments;
  }


  public void setInstallments(List<Installment2> installments) {
    
    
    
    this.installments = installments;
  }


  public InstallmentPlan secureAuthorizations(List<ReAuthorization> secureAuthorizations) {
    
    
    
    
    this.secureAuthorizations = secureAuthorizations;
    return this;
  }

  public InstallmentPlan addSecureAuthorizationsItem(ReAuthorization secureAuthorizationsItem) {
    if (this.secureAuthorizations == null) {
      this.secureAuthorizations = new ArrayList<>();
    }
    this.secureAuthorizations.add(secureAuthorizationsItem);
    return this;
  }

   /**
   * Get secureAuthorizations
   * @return secureAuthorizations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<ReAuthorization> getSecureAuthorizations() {
    return secureAuthorizations;
  }


  public void setSecureAuthorizations(List<ReAuthorization> secureAuthorizations) {
    
    
    
    this.secureAuthorizations = secureAuthorizations;
  }


  public InstallmentPlan logoUrl(String logoUrl) {
    
    
    
    
    this.logoUrl = logoUrl;
    return this;
  }

   /**
   * Get logoUrl
   * @return logoUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getLogoUrl() {
    return logoUrl;
  }


  public void setLogoUrl(String logoUrl) {
    
    
    
    this.logoUrl = logoUrl;
  }


  public InstallmentPlan isInAutoRetry(Boolean isInAutoRetry) {
    
    
    
    
    this.isInAutoRetry = isInAutoRetry;
    return this;
  }

   /**
   * Get isInAutoRetry
   * @return isInAutoRetry
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Boolean getIsInAutoRetry() {
    return isInAutoRetry;
  }


  public void setIsInAutoRetry(Boolean isInAutoRetry) {
    
    
    
    this.isInAutoRetry = isInAutoRetry;
  }


  public InstallmentPlan paymentMethod(String paymentMethod) {
    
    
    
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * Get paymentMethod
   * @return paymentMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(String paymentMethod) {
    
    
    
    this.paymentMethod = paymentMethod;
  }


  public InstallmentPlan allowCardUpdateOnSplititPortals(Boolean allowCardUpdateOnSplititPortals) {
    
    
    
    
    this.allowCardUpdateOnSplititPortals = allowCardUpdateOnSplititPortals;
    return this;
  }

   /**
   * Get allowCardUpdateOnSplititPortals
   * @return allowCardUpdateOnSplititPortals
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Boolean getAllowCardUpdateOnSplititPortals() {
    return allowCardUpdateOnSplititPortals;
  }


  public void setAllowCardUpdateOnSplititPortals(Boolean allowCardUpdateOnSplititPortals) {
    
    
    
    this.allowCardUpdateOnSplititPortals = allowCardUpdateOnSplititPortals;
  }


  public InstallmentPlan onHoldLastOpenDate(OffsetDateTime onHoldLastOpenDate) {
    
    
    
    
    this.onHoldLastOpenDate = onHoldLastOpenDate;
    return this;
  }

   /**
   * Get onHoldLastOpenDate
   * @return onHoldLastOpenDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OffsetDateTime getOnHoldLastOpenDate() {
    return onHoldLastOpenDate;
  }


  public void setOnHoldLastOpenDate(OffsetDateTime onHoldLastOpenDate) {
    
    
    
    this.onHoldLastOpenDate = onHoldLastOpenDate;
  }


  public InstallmentPlan onHoldLastOpenUserId(String onHoldLastOpenUserId) {
    
    
    
    
    this.onHoldLastOpenUserId = onHoldLastOpenUserId;
    return this;
  }

   /**
   * Get onHoldLastOpenUserId
   * @return onHoldLastOpenUserId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getOnHoldLastOpenUserId() {
    return onHoldLastOpenUserId;
  }


  public void setOnHoldLastOpenUserId(String onHoldLastOpenUserId) {
    
    
    
    this.onHoldLastOpenUserId = onHoldLastOpenUserId;
  }


  public InstallmentPlan installmentsScheduleInterval(Integer installmentsScheduleInterval) {
    
    
    
    
    this.installmentsScheduleInterval = installmentsScheduleInterval;
    return this;
  }

   /**
   * Get installmentsScheduleInterval
   * @return installmentsScheduleInterval
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Integer getInstallmentsScheduleInterval() {
    return installmentsScheduleInterval;
  }


  public void setInstallmentsScheduleInterval(Integer installmentsScheduleInterval) {
    
    
    
    this.installmentsScheduleInterval = installmentsScheduleInterval;
  }


  public InstallmentPlan externalPaymentProvider(ExternalProviderTypes externalPaymentProvider) {
    
    
    
    
    this.externalPaymentProvider = externalPaymentProvider;
    return this;
  }

   /**
   * Get externalPaymentProvider
   * @return externalPaymentProvider
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ExternalProviderTypes getExternalPaymentProvider() {
    return externalPaymentProvider;
  }


  public void setExternalPaymentProvider(ExternalProviderTypes externalPaymentProvider) {
    
    
    
    this.externalPaymentProvider = externalPaymentProvider;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   *
   * @param key name of the property
   * @param value value of the property
   * @return the InstallmentPlan instance itself
   */
  public InstallmentPlan putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   *
   * @return a map of objects
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   *
   * @param key name of the property
   * @return an object
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InstallmentPlan installmentPlan = (InstallmentPlan) o;
    return Objects.equals(this.installmentPlanNumber, installmentPlan.installmentPlanNumber) &&
        Objects.equals(this.installmentPlanStatus, installmentPlan.installmentPlanStatus) &&
        Objects.equals(this.amount, installmentPlan.amount) &&
        Objects.equals(this.outstandingAmount, installmentPlan.outstandingAmount) &&
        Objects.equals(this.disputes, installmentPlan.disputes) &&
        Objects.equals(this.numberOfInstallments, installmentPlan.numberOfInstallments) &&
        Objects.equals(this.numberOfProcessedInstallments, installmentPlan.numberOfProcessedInstallments) &&
        Objects.equals(this.originalAmount, installmentPlan.originalAmount) &&
        Objects.equals(this.refundAmount, installmentPlan.refundAmount) &&
        Objects.equals(this.consumer, installmentPlan.consumer) &&
        Objects.equals(this.activeCard, installmentPlan.activeCard) &&
        Objects.equals(this.fraudCheck, installmentPlan.fraudCheck) &&
        Objects.equals(this.terminal, installmentPlan.terminal) &&
        Objects.equals(this.merchant, installmentPlan.merchant) &&
        Objects.equals(this.refOrderNumber, installmentPlan.refOrderNumber) &&
        Objects.equals(this.purchaseMethod, installmentPlan.purchaseMethod) &&
        Objects.equals(this.strategy, installmentPlan.strategy) &&
        Objects.equals(this.delayResolution, installmentPlan.delayResolution) &&
        Objects.equals(this.extendedParams, installmentPlan.extendedParams) &&
        Objects.equals(this.isFullCaptured, installmentPlan.isFullCaptured) &&
        Objects.equals(this.isChargedBack, installmentPlan.isChargedBack) &&
        Objects.equals(this.arePaymentsOnHold, installmentPlan.arePaymentsOnHold) &&
        Objects.equals(this.scpFundingPercent, installmentPlan.scpFundingPercent) &&
        Objects.equals(this.fundingStatus, installmentPlan.fundingStatus) &&
        Objects.equals(this.testMode, installmentPlan.testMode) &&
        Objects.equals(this.creationDateTime, installmentPlan.creationDateTime) &&
        Objects.equals(this.lifeTimeUrlExpirationTime, installmentPlan.lifeTimeUrlExpirationTime) &&
        Objects.equals(this.installments, installmentPlan.installments) &&
        Objects.equals(this.secureAuthorizations, installmentPlan.secureAuthorizations) &&
        Objects.equals(this.logoUrl, installmentPlan.logoUrl) &&
        Objects.equals(this.isInAutoRetry, installmentPlan.isInAutoRetry) &&
        Objects.equals(this.paymentMethod, installmentPlan.paymentMethod) &&
        Objects.equals(this.allowCardUpdateOnSplititPortals, installmentPlan.allowCardUpdateOnSplititPortals) &&
        Objects.equals(this.onHoldLastOpenDate, installmentPlan.onHoldLastOpenDate) &&
        Objects.equals(this.onHoldLastOpenUserId, installmentPlan.onHoldLastOpenUserId) &&
        Objects.equals(this.installmentsScheduleInterval, installmentPlan.installmentsScheduleInterval) &&
        Objects.equals(this.externalPaymentProvider, installmentPlan.externalPaymentProvider)&&
        Objects.equals(this.additionalProperties, installmentPlan.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(installmentPlanNumber, installmentPlanStatus, amount, outstandingAmount, disputes, numberOfInstallments, numberOfProcessedInstallments, originalAmount, refundAmount, consumer, activeCard, fraudCheck, terminal, merchant, refOrderNumber, purchaseMethod, strategy, delayResolution, extendedParams, isFullCaptured, isChargedBack, arePaymentsOnHold, scpFundingPercent, fundingStatus, testMode, creationDateTime, lifeTimeUrlExpirationTime, installments, secureAuthorizations, logoUrl, isInAutoRetry, paymentMethod, allowCardUpdateOnSplititPortals, onHoldLastOpenDate, onHoldLastOpenUserId, installmentsScheduleInterval, externalPaymentProvider, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InstallmentPlan {\n");
    sb.append("    installmentPlanNumber: ").append(toIndentedString(installmentPlanNumber)).append("\n");
    sb.append("    installmentPlanStatus: ").append(toIndentedString(installmentPlanStatus)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    outstandingAmount: ").append(toIndentedString(outstandingAmount)).append("\n");
    sb.append("    disputes: ").append(toIndentedString(disputes)).append("\n");
    sb.append("    numberOfInstallments: ").append(toIndentedString(numberOfInstallments)).append("\n");
    sb.append("    numberOfProcessedInstallments: ").append(toIndentedString(numberOfProcessedInstallments)).append("\n");
    sb.append("    originalAmount: ").append(toIndentedString(originalAmount)).append("\n");
    sb.append("    refundAmount: ").append(toIndentedString(refundAmount)).append("\n");
    sb.append("    consumer: ").append(toIndentedString(consumer)).append("\n");
    sb.append("    activeCard: ").append(toIndentedString(activeCard)).append("\n");
    sb.append("    fraudCheck: ").append(toIndentedString(fraudCheck)).append("\n");
    sb.append("    terminal: ").append(toIndentedString(terminal)).append("\n");
    sb.append("    merchant: ").append(toIndentedString(merchant)).append("\n");
    sb.append("    refOrderNumber: ").append(toIndentedString(refOrderNumber)).append("\n");
    sb.append("    purchaseMethod: ").append(toIndentedString(purchaseMethod)).append("\n");
    sb.append("    strategy: ").append(toIndentedString(strategy)).append("\n");
    sb.append("    delayResolution: ").append(toIndentedString(delayResolution)).append("\n");
    sb.append("    extendedParams: ").append(toIndentedString(extendedParams)).append("\n");
    sb.append("    isFullCaptured: ").append(toIndentedString(isFullCaptured)).append("\n");
    sb.append("    isChargedBack: ").append(toIndentedString(isChargedBack)).append("\n");
    sb.append("    arePaymentsOnHold: ").append(toIndentedString(arePaymentsOnHold)).append("\n");
    sb.append("    scpFundingPercent: ").append(toIndentedString(scpFundingPercent)).append("\n");
    sb.append("    fundingStatus: ").append(toIndentedString(fundingStatus)).append("\n");
    sb.append("    testMode: ").append(toIndentedString(testMode)).append("\n");
    sb.append("    creationDateTime: ").append(toIndentedString(creationDateTime)).append("\n");
    sb.append("    lifeTimeUrlExpirationTime: ").append(toIndentedString(lifeTimeUrlExpirationTime)).append("\n");
    sb.append("    installments: ").append(toIndentedString(installments)).append("\n");
    sb.append("    secureAuthorizations: ").append(toIndentedString(secureAuthorizations)).append("\n");
    sb.append("    logoUrl: ").append(toIndentedString(logoUrl)).append("\n");
    sb.append("    isInAutoRetry: ").append(toIndentedString(isInAutoRetry)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    allowCardUpdateOnSplititPortals: ").append(toIndentedString(allowCardUpdateOnSplititPortals)).append("\n");
    sb.append("    onHoldLastOpenDate: ").append(toIndentedString(onHoldLastOpenDate)).append("\n");
    sb.append("    onHoldLastOpenUserId: ").append(toIndentedString(onHoldLastOpenUserId)).append("\n");
    sb.append("    installmentsScheduleInterval: ").append(toIndentedString(installmentsScheduleInterval)).append("\n");
    sb.append("    externalPaymentProvider: ").append(toIndentedString(externalPaymentProvider)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("InstallmentPlanNumber");
    openapiFields.add("InstallmentPlanStatus");
    openapiFields.add("Amount");
    openapiFields.add("OutstandingAmount");
    openapiFields.add("Disputes");
    openapiFields.add("NumberOfInstallments");
    openapiFields.add("NumberOfProcessedInstallments");
    openapiFields.add("OriginalAmount");
    openapiFields.add("RefundAmount");
    openapiFields.add("Consumer");
    openapiFields.add("ActiveCard");
    openapiFields.add("FraudCheck");
    openapiFields.add("Terminal");
    openapiFields.add("Merchant");
    openapiFields.add("RefOrderNumber");
    openapiFields.add("PurchaseMethod");
    openapiFields.add("Strategy");
    openapiFields.add("DelayResolution");
    openapiFields.add("ExtendedParams");
    openapiFields.add("IsFullCaptured");
    openapiFields.add("IsChargedBack");
    openapiFields.add("ArePaymentsOnHold");
    openapiFields.add("ScpFundingPercent");
    openapiFields.add("FundingStatus");
    openapiFields.add("TestMode");
    openapiFields.add("CreationDateTime");
    openapiFields.add("LifeTimeUrlExpirationTime");
    openapiFields.add("Installments");
    openapiFields.add("SecureAuthorizations");
    openapiFields.add("LogoUrl");
    openapiFields.add("IsInAutoRetry");
    openapiFields.add("PaymentMethod");
    openapiFields.add("AllowCardUpdateOnSplititPortals");
    openapiFields.add("OnHoldLastOpenDate");
    openapiFields.add("OnHoldLastOpenUserId");
    openapiFields.add("InstallmentsScheduleInterval");
    openapiFields.add("ExternalPaymentProvider");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("NumberOfInstallments");
    openapiRequiredFields.add("NumberOfProcessedInstallments");
    openapiRequiredFields.add("IsFullCaptured");
    openapiRequiredFields.add("IsChargedBack");
    openapiRequiredFields.add("ArePaymentsOnHold");
    openapiRequiredFields.add("ScpFundingPercent");
    openapiRequiredFields.add("FundingStatus");
    openapiRequiredFields.add("TestMode");
    openapiRequiredFields.add("CreationDateTime");
    openapiRequiredFields.add("LifeTimeUrlExpirationTime");
    openapiRequiredFields.add("IsInAutoRetry");
    openapiRequiredFields.add("AllowCardUpdateOnSplititPortals");
    openapiRequiredFields.add("InstallmentsScheduleInterval");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to InstallmentPlan
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (!InstallmentPlan.openapiRequiredFields.isEmpty()) { // has required fields but JSON object is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in InstallmentPlan is not found in the empty JSON string", InstallmentPlan.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : InstallmentPlan.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if ((jsonObj.get("InstallmentPlanNumber") != null && !jsonObj.get("InstallmentPlanNumber").isJsonNull()) && !jsonObj.get("InstallmentPlanNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `InstallmentPlanNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("InstallmentPlanNumber").toString()));
      }
      // validate the optional field `InstallmentPlanStatus`
      if (jsonObj.get("InstallmentPlanStatus") != null && !jsonObj.get("InstallmentPlanStatus").isJsonNull()) {
        ReferenceEntityBase.validateJsonObject(jsonObj.getAsJsonObject("InstallmentPlanStatus"));
      }
      // validate the optional field `Amount`
      if (jsonObj.get("Amount") != null && !jsonObj.get("Amount").isJsonNull()) {
        Money.validateJsonObject(jsonObj.getAsJsonObject("Amount"));
      }
      // validate the optional field `OutstandingAmount`
      if (jsonObj.get("OutstandingAmount") != null && !jsonObj.get("OutstandingAmount").isJsonNull()) {
        Money.validateJsonObject(jsonObj.getAsJsonObject("OutstandingAmount"));
      }
      // validate the optional field `Disputes`
      if (jsonObj.get("Disputes") != null && !jsonObj.get("Disputes").isJsonNull()) {
        Disputes.validateJsonObject(jsonObj.getAsJsonObject("Disputes"));
      }
      // validate the optional field `OriginalAmount`
      if (jsonObj.get("OriginalAmount") != null && !jsonObj.get("OriginalAmount").isJsonNull()) {
        Money.validateJsonObject(jsonObj.getAsJsonObject("OriginalAmount"));
      }
      // validate the optional field `RefundAmount`
      if (jsonObj.get("RefundAmount") != null && !jsonObj.get("RefundAmount").isJsonNull()) {
        Money.validateJsonObject(jsonObj.getAsJsonObject("RefundAmount"));
      }
      // validate the optional field `Consumer`
      if (jsonObj.get("Consumer") != null && !jsonObj.get("Consumer").isJsonNull()) {
        ConsumerData.validateJsonObject(jsonObj.getAsJsonObject("Consumer"));
      }
      // validate the optional field `ActiveCard`
      if (jsonObj.get("ActiveCard") != null && !jsonObj.get("ActiveCard").isJsonNull()) {
        CardData2.validateJsonObject(jsonObj.getAsJsonObject("ActiveCard"));
      }
      // validate the optional field `FraudCheck`
      if (jsonObj.get("FraudCheck") != null && !jsonObj.get("FraudCheck").isJsonNull()) {
        FraudCheck.validateJsonObject(jsonObj.getAsJsonObject("FraudCheck"));
      }
      // validate the optional field `Terminal`
      if (jsonObj.get("Terminal") != null && !jsonObj.get("Terminal").isJsonNull()) {
        TerminalRef.validateJsonObject(jsonObj.getAsJsonObject("Terminal"));
      }
      // validate the optional field `Merchant`
      if (jsonObj.get("Merchant") != null && !jsonObj.get("Merchant").isJsonNull()) {
        MerchantRef.validateJsonObject(jsonObj.getAsJsonObject("Merchant"));
      }
      if ((jsonObj.get("RefOrderNumber") != null && !jsonObj.get("RefOrderNumber").isJsonNull()) && !jsonObj.get("RefOrderNumber").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `RefOrderNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get("RefOrderNumber").toString()));
      }
      // validate the optional field `PurchaseMethod`
      if (jsonObj.get("PurchaseMethod") != null && !jsonObj.get("PurchaseMethod").isJsonNull()) {
        ReferenceEntityBase.validateJsonObject(jsonObj.getAsJsonObject("PurchaseMethod"));
      }
      // validate the optional field `Strategy`
      if (jsonObj.get("Strategy") != null && !jsonObj.get("Strategy").isJsonNull()) {
        ReferenceEntityBase.validateJsonObject(jsonObj.getAsJsonObject("Strategy"));
      }
      // validate the optional field `DelayResolution`
      if (jsonObj.get("DelayResolution") != null && !jsonObj.get("DelayResolution").isJsonNull()) {
        ReferenceEntityBase.validateJsonObject(jsonObj.getAsJsonObject("DelayResolution"));
      }
      if (jsonObj.get("Installments") != null && !jsonObj.get("Installments").isJsonNull()) {
        JsonArray jsonArrayinstallments = jsonObj.getAsJsonArray("Installments");
        if (jsonArrayinstallments != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Installments").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Installments` to be an array in the JSON string but got `%s`", jsonObj.get("Installments").toString()));
          }

          // validate the optional field `Installments` (array)
          for (int i = 0; i < jsonArrayinstallments.size(); i++) {
            Installment2.validateJsonObject(jsonArrayinstallments.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("SecureAuthorizations") != null && !jsonObj.get("SecureAuthorizations").isJsonNull()) {
        JsonArray jsonArraysecureAuthorizations = jsonObj.getAsJsonArray("SecureAuthorizations");
        if (jsonArraysecureAuthorizations != null) {
          // ensure the json data is an array
          if (!jsonObj.get("SecureAuthorizations").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `SecureAuthorizations` to be an array in the JSON string but got `%s`", jsonObj.get("SecureAuthorizations").toString()));
          }

          // validate the optional field `SecureAuthorizations` (array)
          for (int i = 0; i < jsonArraysecureAuthorizations.size(); i++) {
            ReAuthorization.validateJsonObject(jsonArraysecureAuthorizations.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("LogoUrl") != null && !jsonObj.get("LogoUrl").isJsonNull()) && !jsonObj.get("LogoUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `LogoUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("LogoUrl").toString()));
      }
      if ((jsonObj.get("PaymentMethod") != null && !jsonObj.get("PaymentMethod").isJsonNull()) && !jsonObj.get("PaymentMethod").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `PaymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("PaymentMethod").toString()));
      }
      if ((jsonObj.get("OnHoldLastOpenUserId") != null && !jsonObj.get("OnHoldLastOpenUserId").isJsonNull()) && !jsonObj.get("OnHoldLastOpenUserId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `OnHoldLastOpenUserId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("OnHoldLastOpenUserId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!InstallmentPlan.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'InstallmentPlan' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<InstallmentPlan> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(InstallmentPlan.class));

       return (TypeAdapter<T>) new TypeAdapter<InstallmentPlan>() {
           @Override
           public void write(JsonWriter out, InstallmentPlan value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public InstallmentPlan read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             InstallmentPlan instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else if (entry.getValue().isJsonArray()) {
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), List.class));
                 } else { // JSON object
                     instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of InstallmentPlan given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of InstallmentPlan
  * @throws IOException if the JSON string is invalid with respect to InstallmentPlan
  */
  public static InstallmentPlan fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, InstallmentPlan.class);
  }

 /**
  * Convert an instance of InstallmentPlan to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

