/*
 * splitit-web-api-v3
 * Splitit's Web API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by Konfig (https://konfigthis.com).
 * Do not edit the class manually.
 */


package com.konfigthis.splitit.client.api;

import com.konfigthis.splitit.client.ApiCallback;
import com.konfigthis.splitit.client.ApiClient;
import com.konfigthis.splitit.client.ApiException;
import com.konfigthis.splitit.client.ApiResponse;
import com.konfigthis.splitit.client.Configuration;
import com.konfigthis.splitit.client.Pair;
import com.konfigthis.splitit.client.ProgressRequestBody;
import com.konfigthis.splitit.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.konfigthis.splitit.client.model.AddressData;
import com.konfigthis.splitit.client.model.AddressDataModel;
import com.konfigthis.splitit.client.model.CardData;
import com.konfigthis.splitit.client.model.CheckInstallmentsEligibilityRequest;
import com.konfigthis.splitit.client.model.EventsEndpointsModel;
import com.konfigthis.splitit.client.model.IdentifierContract;
import com.konfigthis.splitit.client.model.InitiatePlanResponse;
import com.konfigthis.splitit.client.model.InitiateRedirectionEndpointsModel;
import com.konfigthis.splitit.client.model.InstallmentPlanCancelRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanCancelResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanCreateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanCreateResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanGetResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanInitiateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanRefundRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanRefundResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanSearchResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateRequestByIdentifier;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateResponse;
import com.konfigthis.splitit.client.model.InstallmentsEligibilityResponse;
import com.konfigthis.splitit.client.model.PaymentMethodModel;
import com.konfigthis.splitit.client.model.PlanData;
import com.konfigthis.splitit.client.model.PlanDataModel;
import com.konfigthis.splitit.client.model.ProcessingData;
import com.konfigthis.splitit.client.model.RedirectionEndpointsModel;
import com.konfigthis.splitit.client.model.RefundStrategy;
import com.konfigthis.splitit.client.model.ShippingStatus;
import com.konfigthis.splitit.client.model.ShopperData;
import com.konfigthis.splitit.client.model.UxSettingsModel;
import com.konfigthis.splitit.client.model.VerifyAuthorizationResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class InstallmentPlanApiGenerated {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InstallmentPlanApiGenerated() throws IllegalArgumentException {
        this(Configuration.getDefaultApiClient());
    }

    public InstallmentPlanApiGenerated(ApiClient apiClient) throws IllegalArgumentException {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call cancelCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCancelRequest installmentPlanCancelRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanCancelRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/cancel"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCancelRequest installmentPlanCancelRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling cancel(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling cancel(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling cancel(Async)");
        }

        return cancelCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest, _callback);

    }


    private ApiResponse<InstallmentPlanCancelResponse> cancelWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCancelRequest installmentPlanCancelRequest) throws ApiException {
        okhttp3.Call localVarCall = cancelValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanCancelResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call cancelAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCancelRequest installmentPlanCancelRequest, final ApiCallback<InstallmentPlanCancelResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanCancelResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class CancelRequestBuilder {
        private final String installmentPlanNumber;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private String referenceId;

        private CancelRequestBuilder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set referenceId
         * @param referenceId  (optional)
         * @return CancelRequestBuilder
         */
        public CancelRequestBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }
        
        /**
         * Build call for cancel
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanCancelRequest installmentPlanCancelRequest = buildBodyParams();
            return cancelCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest, _callback);
        }

        private InstallmentPlanCancelRequest buildBodyParams() {
            InstallmentPlanCancelRequest installmentPlanCancelRequest = new InstallmentPlanCancelRequest();
            installmentPlanCancelRequest.referenceId(this.referenceId);
            return installmentPlanCancelRequest;
        }

        /**
         * Execute cancel request
         * @return InstallmentPlanCancelResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanCancelResponse execute() throws ApiException {
            InstallmentPlanCancelRequest installmentPlanCancelRequest = buildBodyParams();
            ApiResponse<InstallmentPlanCancelResponse> localVarResp = cancelWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute cancel request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanCancelResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanCancelResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanCancelRequest installmentPlanCancelRequest = buildBodyParams();
            return cancelWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest);
        }

        /**
         * Execute cancel request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanCancelResponse> _callback) throws ApiException {
            InstallmentPlanCancelRequest installmentPlanCancelRequest = buildBodyParams();
            return cancelAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCancelRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return CancelRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public CancelRequestBuilder cancel(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new CancelRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call checkEligibilityCall(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = checkInstallmentsEligibilityRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/check-eligibility";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkEligibilityValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling checkEligibility(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling checkEligibility(Async)");
        }

        // verify the required parameter 'checkInstallmentsEligibilityRequest' is set
        if (checkInstallmentsEligibilityRequest == null) {
            throw new ApiException("Missing the required parameter 'checkInstallmentsEligibilityRequest' when calling checkEligibility(Async)");
        }

        return checkEligibilityCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);

    }


    private ApiResponse<InstallmentsEligibilityResponse> checkEligibilityWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest) throws ApiException {
        okhttp3.Call localVarCall = checkEligibilityValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentsEligibilityResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call checkEligibilityAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback<InstallmentsEligibilityResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkEligibilityValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentsEligibilityResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class CheckEligibilityRequestBuilder {
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private PlanData planData;
        private CardData cardDetails;
        private AddressData billingAddress;
        private String shopperIdentifier;

        private CheckEligibilityRequestBuilder(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set planData
         * @param planData  (optional)
         * @return CheckEligibilityRequestBuilder
         */
        public CheckEligibilityRequestBuilder planData(PlanData planData) {
            this.planData = planData;
            return this;
        }
        
        /**
         * Set cardDetails
         * @param cardDetails  (optional)
         * @return CheckEligibilityRequestBuilder
         */
        public CheckEligibilityRequestBuilder cardDetails(CardData cardDetails) {
            this.cardDetails = cardDetails;
            return this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return CheckEligibilityRequestBuilder
         */
        public CheckEligibilityRequestBuilder billingAddress(AddressData billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }
        
        /**
         * Set shopperIdentifier
         * @param shopperIdentifier  (optional)
         * @return CheckEligibilityRequestBuilder
         */
        public CheckEligibilityRequestBuilder shopperIdentifier(String shopperIdentifier) {
            this.shopperIdentifier = shopperIdentifier;
            return this;
        }
        
        /**
         * Build call for checkEligibility
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        }

        private CheckInstallmentsEligibilityRequest buildBodyParams() {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = new CheckInstallmentsEligibilityRequest();
            checkInstallmentsEligibilityRequest.planData(this.planData);
            checkInstallmentsEligibilityRequest.cardDetails(this.cardDetails);
            checkInstallmentsEligibilityRequest.billingAddress(this.billingAddress);
            checkInstallmentsEligibilityRequest.shopperIdentifier(this.shopperIdentifier);
            return checkInstallmentsEligibilityRequest;
        }

        /**
         * Execute checkEligibility request
         * @return InstallmentsEligibilityResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentsEligibilityResponse execute() throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            ApiResponse<InstallmentsEligibilityResponse> localVarResp = checkEligibilityWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute checkEligibility request with HTTP info returned
         * @return ApiResponse&lt;InstallmentsEligibilityResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentsEligibilityResponse> executeWithHttpInfo() throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest);
        }

        /**
         * Execute checkEligibility request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentsEligibilityResponse> _callback) throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityAsync(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param checkInstallmentsEligibilityRequest  (required)
     * @return CheckEligibilityRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public CheckEligibilityRequestBuilder checkEligibility(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new CheckEligibilityRequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call getCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling get(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling get(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling get(Async)");
        }

        return getCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);

    }


    private ApiResponse<InstallmentPlanGetResponse> getWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws ApiException {
        okhttp3.Call localVarCall = getValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanGetResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback<InstallmentPlanGetResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanGetResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class GetRequestBuilder {
        private final String installmentPlanNumber;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;

        private GetRequestBuilder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Build call for get
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }


        /**
         * Execute get request
         * @return InstallmentPlanGetResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanGetResponse execute() throws ApiException {
            ApiResponse<InstallmentPlanGetResponse> localVarResp = getWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute get request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanGetResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanGetResponse> executeWithHttpInfo() throws ApiException {
            return getWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
        }

        /**
         * Execute get request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanGetResponse> _callback) throws ApiException {
            return getAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return GetRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public GetRequestBuilder get(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new GetRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call postCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanInitiateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/initiate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititTestMode != null) {
            localVarHeaderParams.put("X-Splitit-TestMode", localVarApiClient.parameterToString(xSplititTestMode));
        }

        if (splititclientinfo != null) {
            localVarHeaderParams.put("Splititclientinfo", localVarApiClient.parameterToString(splititclientinfo));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling post(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling post(Async)");
        }

        // verify the required parameter 'installmentPlanInitiateRequest' is set
        if (installmentPlanInitiateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanInitiateRequest' when calling post(Async)");
        }

        return postCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo, _callback);

    }


    private ApiResponse<InitiatePlanResponse> postWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String splititclientinfo) throws ApiException {
        okhttp3.Call localVarCall = postValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo, null);
        Type localVarReturnType = new TypeToken<InitiatePlanResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call postAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback<InitiatePlanResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = postValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo, _callback);
        Type localVarReturnType = new TypeToken<InitiatePlanResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class PostRequestBuilder {
        private final Boolean autoCapture;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private Boolean attempt3dSecure;
        private ShopperData shopper;
        private PlanDataModel planData;
        private AddressDataModel billingAddress;
        private InitiateRedirectionEndpointsModel redirectUrls;
        private UxSettingsModel uxSettings;
        private EventsEndpointsModel eventsEndpoints;
        private ProcessingData processingData;
        private String xSplititTestMode;
        private String splititclientinfo;

        private PostRequestBuilder(Boolean autoCapture, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.autoCapture = autoCapture;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set attempt3dSecure
         * @param attempt3dSecure  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder attempt3dSecure(Boolean attempt3dSecure) {
            this.attempt3dSecure = attempt3dSecure;
            return this;
        }
        
        /**
         * Set shopper
         * @param shopper  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder shopper(ShopperData shopper) {
            this.shopper = shopper;
            return this;
        }
        
        /**
         * Set planData
         * @param planData  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder planData(PlanDataModel planData) {
            this.planData = planData;
            return this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder billingAddress(AddressDataModel billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }
        
        /**
         * Set redirectUrls
         * @param redirectUrls  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder redirectUrls(InitiateRedirectionEndpointsModel redirectUrls) {
            this.redirectUrls = redirectUrls;
            return this;
        }
        
        /**
         * Set uxSettings
         * @param uxSettings  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder uxSettings(UxSettingsModel uxSettings) {
            this.uxSettings = uxSettings;
            return this;
        }
        
        /**
         * Set eventsEndpoints
         * @param eventsEndpoints  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder eventsEndpoints(EventsEndpointsModel eventsEndpoints) {
            this.eventsEndpoints = eventsEndpoints;
            return this;
        }
        
        /**
         * Set processingData
         * @param processingData  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder processingData(ProcessingData processingData) {
            this.processingData = processingData;
            return this;
        }
        
        /**
         * Set xSplititTestMode
         * @param xSplititTestMode  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder xSplititTestMode(String xSplititTestMode) {
            this.xSplititTestMode = xSplititTestMode;
            return this;
        }
        
        /**
         * Set splititclientinfo
         * @param splititclientinfo  (optional)
         * @return PostRequestBuilder
         */
        public PostRequestBuilder splititclientinfo(String splititclientinfo) {
            this.splititclientinfo = splititclientinfo;
            return this;
        }
        
        /**
         * Build call for post
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo, _callback);
        }

        private InstallmentPlanInitiateRequest buildBodyParams() {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = new InstallmentPlanInitiateRequest();
            installmentPlanInitiateRequest.autoCapture(this.autoCapture);
            installmentPlanInitiateRequest.attempt3dSecure(this.attempt3dSecure);
            installmentPlanInitiateRequest.shopper(this.shopper);
            installmentPlanInitiateRequest.planData(this.planData);
            installmentPlanInitiateRequest.billingAddress(this.billingAddress);
            installmentPlanInitiateRequest.redirectUrls(this.redirectUrls);
            installmentPlanInitiateRequest.uxSettings(this.uxSettings);
            installmentPlanInitiateRequest.eventsEndpoints(this.eventsEndpoints);
            installmentPlanInitiateRequest.processingData(this.processingData);
            return installmentPlanInitiateRequest;
        }

        /**
         * Execute post request
         * @return InitiatePlanResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InitiatePlanResponse execute() throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            ApiResponse<InitiatePlanResponse> localVarResp = postWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute post request with HTTP info returned
         * @return ApiResponse&lt;InitiatePlanResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InitiatePlanResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo);
        }

        /**
         * Execute post request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InitiatePlanResponse> _callback) throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postAsync(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, splititclientinfo, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanInitiateRequest  (required)
     * @return PostRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public PostRequestBuilder post(Boolean autoCapture, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (autoCapture == null) throw new IllegalArgumentException("\"autoCapture\" is required but got null");
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new PostRequestBuilder(autoCapture, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call post2Call(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanCreateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititTestMode != null) {
            localVarHeaderParams.put("X-Splitit-TestMode", localVarApiClient.parameterToString(xSplititTestMode));
        }

        if (splititclientinfo != null) {
            localVarHeaderParams.put("Splititclientinfo", localVarApiClient.parameterToString(splititclientinfo));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call post2ValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling post2(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling post2(Async)");
        }

        // verify the required parameter 'installmentPlanCreateRequest' is set
        if (installmentPlanCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanCreateRequest' when calling post2(Async)");
        }

        return post2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo, _callback);

    }


    private ApiResponse<InstallmentPlanCreateResponse> post2WithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String splititclientinfo) throws ApiException {
        okhttp3.Call localVarCall = post2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanCreateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call post2Async(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String splititclientinfo, final ApiCallback<InstallmentPlanCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = post2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class Post2RequestBuilder {
        private final Boolean autoCapture;
        private final Boolean termsAndConditionsAccepted;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private Boolean attempt3dSecure;
        private ShopperData shopper;
        private PlanDataModel planData;
        private AddressDataModel billingAddress;
        private PaymentMethodModel paymentMethod;
        private RedirectionEndpointsModel redirectUrls;
        private ProcessingData processingData;
        private EventsEndpointsModel eventsEndpoints;
        private String xSplititTestMode;
        private String splititclientinfo;

        private Post2RequestBuilder(Boolean autoCapture, Boolean termsAndConditionsAccepted, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.autoCapture = autoCapture;
            this.termsAndConditionsAccepted = termsAndConditionsAccepted;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set attempt3dSecure
         * @param attempt3dSecure  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder attempt3dSecure(Boolean attempt3dSecure) {
            this.attempt3dSecure = attempt3dSecure;
            return this;
        }
        
        /**
         * Set shopper
         * @param shopper  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder shopper(ShopperData shopper) {
            this.shopper = shopper;
            return this;
        }
        
        /**
         * Set planData
         * @param planData  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder planData(PlanDataModel planData) {
            this.planData = planData;
            return this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder billingAddress(AddressDataModel billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }
        
        /**
         * Set paymentMethod
         * @param paymentMethod  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder paymentMethod(PaymentMethodModel paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }
        
        /**
         * Set redirectUrls
         * @param redirectUrls  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder redirectUrls(RedirectionEndpointsModel redirectUrls) {
            this.redirectUrls = redirectUrls;
            return this;
        }
        
        /**
         * Set processingData
         * @param processingData  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder processingData(ProcessingData processingData) {
            this.processingData = processingData;
            return this;
        }
        
        /**
         * Set eventsEndpoints
         * @param eventsEndpoints  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder eventsEndpoints(EventsEndpointsModel eventsEndpoints) {
            this.eventsEndpoints = eventsEndpoints;
            return this;
        }
        
        /**
         * Set xSplititTestMode
         * @param xSplititTestMode  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder xSplititTestMode(String xSplititTestMode) {
            this.xSplititTestMode = xSplititTestMode;
            return this;
        }
        
        /**
         * Set splititclientinfo
         * @param splititclientinfo  (optional)
         * @return Post2RequestBuilder
         */
        public Post2RequestBuilder splititclientinfo(String splititclientinfo) {
            this.splititclientinfo = splititclientinfo;
            return this;
        }
        
        /**
         * Build call for post2
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo, _callback);
        }

        private InstallmentPlanCreateRequest buildBodyParams() {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = new InstallmentPlanCreateRequest();
            installmentPlanCreateRequest.autoCapture(this.autoCapture);
            installmentPlanCreateRequest.attempt3dSecure(this.attempt3dSecure);
            installmentPlanCreateRequest.termsAndConditionsAccepted(this.termsAndConditionsAccepted);
            installmentPlanCreateRequest.shopper(this.shopper);
            installmentPlanCreateRequest.planData(this.planData);
            installmentPlanCreateRequest.billingAddress(this.billingAddress);
            installmentPlanCreateRequest.paymentMethod(this.paymentMethod);
            installmentPlanCreateRequest.redirectUrls(this.redirectUrls);
            installmentPlanCreateRequest.processingData(this.processingData);
            installmentPlanCreateRequest.eventsEndpoints(this.eventsEndpoints);
            return installmentPlanCreateRequest;
        }

        /**
         * Execute post2 request
         * @return InstallmentPlanCreateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanCreateResponse execute() throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            ApiResponse<InstallmentPlanCreateResponse> localVarResp = post2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute post2 request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanCreateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanCreateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo);
        }

        /**
         * Execute post2 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanCreateResponse> _callback) throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2Async(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, splititclientinfo, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanCreateRequest  (required)
     * @return Post2RequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public Post2RequestBuilder post2(Boolean autoCapture, Boolean termsAndConditionsAccepted, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (autoCapture == null) throw new IllegalArgumentException("\"autoCapture\" is required but got null");
        if (termsAndConditionsAccepted == null) throw new IllegalArgumentException("\"termsAndConditionsAccepted\" is required but got null");
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new Post2RequestBuilder(autoCapture, termsAndConditionsAccepted, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call refundCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanRefundRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/refund"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call refundValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling refund(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling refund(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling refund(Async)");
        }

        // verify the required parameter 'installmentPlanRefundRequest' is set
        if (installmentPlanRefundRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanRefundRequest' when calling refund(Async)");
        }

        return refundCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);

    }


    private ApiResponse<InstallmentPlanRefundResponse> refundWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest) throws ApiException {
        okhttp3.Call localVarCall = refundValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanRefundResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call refundAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback<InstallmentPlanRefundResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = refundValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanRefundResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class RefundRequestBuilder {
        private final Double amount;
        private final String installmentPlanNumber;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private RefundStrategy refundStrategy;
        private String referenceId;

        private RefundRequestBuilder(double amount, String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.amount = amount;
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refundStrategy
         * @param refundStrategy  (optional)
         * @return RefundRequestBuilder
         */
        public RefundRequestBuilder refundStrategy(RefundStrategy refundStrategy) {
            this.refundStrategy = refundStrategy;
            return this;
        }
        
        /**
         * Set referenceId
         * @param referenceId  (optional)
         * @return RefundRequestBuilder
         */
        public RefundRequestBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }
        
        /**
         * Build call for refund
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        }

        private InstallmentPlanRefundRequest buildBodyParams() {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = new InstallmentPlanRefundRequest();
            installmentPlanRefundRequest.amount(this.amount);
            installmentPlanRefundRequest.refundStrategy(this.refundStrategy);
            installmentPlanRefundRequest.referenceId(this.referenceId);
            return installmentPlanRefundRequest;
        }

        /**
         * Execute refund request
         * @return InstallmentPlanRefundResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanRefundResponse execute() throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            ApiResponse<InstallmentPlanRefundResponse> localVarResp = refundWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute refund request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanRefundResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanRefundResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest);
        }

        /**
         * Execute refund request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanRefundResponse> _callback) throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanRefundRequest  (required)
     * @return RefundRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public RefundRequestBuilder refund(double amount, String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new RefundRequestBuilder(amount, installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call searchCall(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (installmentPlanNumber != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("installmentPlanNumber", installmentPlanNumber));
        }

        if (refOrderNumber != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("refOrderNumber", refOrderNumber));
        }

        if (extendedParams != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("extendedParams", extendedParams));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling search(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling search(Async)");
        }

        return searchCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);

    }


    private ApiResponse<InstallmentPlanSearchResponse> searchWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams) throws ApiException {
        okhttp3.Call localVarCall = searchValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanSearchResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call searchAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback<InstallmentPlanSearchResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanSearchResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class SearchRequestBuilder {
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private String installmentPlanNumber;
        private String refOrderNumber;
        private Map<String, String> extendedParams;

        private SearchRequestBuilder(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set installmentPlanNumber
         * @param installmentPlanNumber  (optional)
         * @return SearchRequestBuilder
         */
        public SearchRequestBuilder installmentPlanNumber(String installmentPlanNumber) {
            this.installmentPlanNumber = installmentPlanNumber;
            return this;
        }
        
        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return SearchRequestBuilder
         */
        public SearchRequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return this;
        }
        
        /**
         * Set extendedParams
         * @param extendedParams  (optional)
         * @return SearchRequestBuilder
         */
        public SearchRequestBuilder extendedParams(Map<String, String> extendedParams) {
            this.extendedParams = extendedParams;
            return this;
        }
        
        /**
         * Build call for search
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return searchCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        }


        /**
         * Execute search request
         * @return InstallmentPlanSearchResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanSearchResponse execute() throws ApiException {
            ApiResponse<InstallmentPlanSearchResponse> localVarResp = searchWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute search request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanSearchResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanSearchResponse> executeWithHttpInfo() throws ApiException {
            return searchWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams);
        }

        /**
         * Execute search request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanSearchResponse> _callback) throws ApiException {
            return searchAsync(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return SearchRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public SearchRequestBuilder search(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new SearchRequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call updateOrderCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanUpdateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/updateorder"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateOrderValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling updateOrder(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling updateOrder(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling updateOrder(Async)");
        }

        // verify the required parameter 'installmentPlanUpdateRequest' is set
        if (installmentPlanUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanUpdateRequest' when calling updateOrder(Async)");
        }

        return updateOrderCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);

    }


    private ApiResponse<InstallmentPlanUpdateResponse> updateOrderWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateOrderValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call updateOrderAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateOrderValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class UpdateOrderRequestBuilder {
        private final String installmentPlanNumber;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private String refOrderNumber;
        private String trackingNumber;
        private Boolean capture;
        private ShippingStatus shippingStatus;
        private Double newAmount;

        private UpdateOrderRequestBuilder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return UpdateOrderRequestBuilder
         */
        public UpdateOrderRequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return this;
        }
        
        /**
         * Set trackingNumber
         * @param trackingNumber  (optional)
         * @return UpdateOrderRequestBuilder
         */
        public UpdateOrderRequestBuilder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }
        
        /**
         * Set capture
         * @param capture  (optional)
         * @return UpdateOrderRequestBuilder
         */
        public UpdateOrderRequestBuilder capture(Boolean capture) {
            this.capture = capture;
            return this;
        }
        
        /**
         * Set shippingStatus
         * @param shippingStatus  (optional)
         * @return UpdateOrderRequestBuilder
         */
        public UpdateOrderRequestBuilder shippingStatus(ShippingStatus shippingStatus) {
            this.shippingStatus = shippingStatus;
            return this;
        }
        
        /**
         * Set newAmount
         * @param newAmount  (optional)
         * @return UpdateOrderRequestBuilder
         */
        public UpdateOrderRequestBuilder newAmount(Double newAmount) {
            this.newAmount = newAmount;
            return this;
        }
        
        /**
         * Build call for updateOrder
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        }

        private InstallmentPlanUpdateRequest buildBodyParams() {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = new InstallmentPlanUpdateRequest();
            installmentPlanUpdateRequest.refOrderNumber(this.refOrderNumber);
            installmentPlanUpdateRequest.trackingNumber(this.trackingNumber);
            installmentPlanUpdateRequest.capture(this.capture);
            installmentPlanUpdateRequest.shippingStatus(this.shippingStatus);
            installmentPlanUpdateRequest.newAmount(this.newAmount);
            return installmentPlanUpdateRequest;
        }

        /**
         * Execute updateOrder request
         * @return InstallmentPlanUpdateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanUpdateResponse execute() throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            ApiResponse<InstallmentPlanUpdateResponse> localVarResp = updateOrderWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute updateOrder request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanUpdateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanUpdateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest);
        }

        /**
         * Execute updateOrder request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanUpdateRequest  (required)
     * @return UpdateOrderRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public UpdateOrderRequestBuilder updateOrder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new UpdateOrderRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call updateOrder2Call(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanUpdateRequestByIdentifier;

        // create path and map variables
        String localVarPath = "/api/installmentplans/updateorder";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateOrder2ValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling updateOrder2(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling updateOrder2(Async)");
        }

        // verify the required parameter 'installmentPlanUpdateRequestByIdentifier' is set
        if (installmentPlanUpdateRequestByIdentifier == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanUpdateRequestByIdentifier' when calling updateOrder2(Async)");
        }

        return updateOrder2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);

    }


    private ApiResponse<InstallmentPlanUpdateResponse> updateOrder2WithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier) throws ApiException {
        okhttp3.Call localVarCall = updateOrder2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call updateOrder2Async(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateOrder2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class UpdateOrder2RequestBuilder {
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;
        private String refOrderNumber;
        private String trackingNumber;
        private Boolean capture;
        private ShippingStatus shippingStatus;
        private Double newAmount;
        private IdentifierContract identifier;

        private UpdateOrder2RequestBuilder(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return this;
        }
        
        /**
         * Set trackingNumber
         * @param trackingNumber  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }
        
        /**
         * Set capture
         * @param capture  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder capture(Boolean capture) {
            this.capture = capture;
            return this;
        }
        
        /**
         * Set shippingStatus
         * @param shippingStatus  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder shippingStatus(ShippingStatus shippingStatus) {
            this.shippingStatus = shippingStatus;
            return this;
        }
        
        /**
         * Set newAmount
         * @param newAmount  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder newAmount(Double newAmount) {
            this.newAmount = newAmount;
            return this;
        }
        
        /**
         * Set identifier
         * @param identifier  (optional)
         * @return UpdateOrder2RequestBuilder
         */
        public UpdateOrder2RequestBuilder identifier(IdentifierContract identifier) {
            this.identifier = identifier;
            return this;
        }
        
        /**
         * Build call for updateOrder2
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        }

        private InstallmentPlanUpdateRequestByIdentifier buildBodyParams() {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = new InstallmentPlanUpdateRequestByIdentifier();
            return installmentPlanUpdateRequestByIdentifier;
        }

        /**
         * Execute updateOrder2 request
         * @return InstallmentPlanUpdateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanUpdateResponse execute() throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            ApiResponse<InstallmentPlanUpdateResponse> localVarResp = updateOrder2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute updateOrder2 request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanUpdateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanUpdateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier);
        }

        /**
         * Execute updateOrder2 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2Async(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanUpdateRequestByIdentifier  (required)
     * @return UpdateOrder2RequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public UpdateOrder2RequestBuilder updateOrder2(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new UpdateOrder2RequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call verifyAuthorizationCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/verifyauthorization"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call verifyAuthorizationValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling verifyAuthorization(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling verifyAuthorization(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling verifyAuthorization(Async)");
        }

        return verifyAuthorizationCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);

    }


    private ApiResponse<VerifyAuthorizationResponse> verifyAuthorizationWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws ApiException {
        okhttp3.Call localVarCall = verifyAuthorizationValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, null);
        Type localVarReturnType = new TypeToken<VerifyAuthorizationResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call verifyAuthorizationAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback<VerifyAuthorizationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = verifyAuthorizationValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        Type localVarReturnType = new TypeToken<VerifyAuthorizationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class VerifyAuthorizationRequestBuilder {
        private final String installmentPlanNumber;
        private final String xSplititIdempotencyKey;
        private final String xSplititTouchPoint;

        private VerifyAuthorizationRequestBuilder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Build call for verifyAuthorization
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return verifyAuthorizationCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }


        /**
         * Execute verifyAuthorization request
         * @return VerifyAuthorizationResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public VerifyAuthorizationResponse execute() throws ApiException {
            ApiResponse<VerifyAuthorizationResponse> localVarResp = verifyAuthorizationWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute verifyAuthorization request with HTTP info returned
         * @return ApiResponse&lt;VerifyAuthorizationResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<VerifyAuthorizationResponse> executeWithHttpInfo() throws ApiException {
            return verifyAuthorizationWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
        }

        /**
         * Execute verifyAuthorization request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<VerifyAuthorizationResponse> _callback) throws ApiException {
            return verifyAuthorizationAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return VerifyAuthorizationRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public VerifyAuthorizationRequestBuilder verifyAuthorization(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return new VerifyAuthorizationRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
}
