/*
 * splitit-web-api-v3
 * Splitit's Web API
 *
 * The version of the OpenAPI document: 1.0.0
 * 
 *
 * NOTE: This class is auto generated by Konfig (https://konfigthis.com).
 * Do not edit the class manually.
 */


package com.konfigthis.splitit.client.api;

import com.konfigthis.splitit.client.ApiCallback;
import com.konfigthis.splitit.client.ApiClient;
import com.konfigthis.splitit.client.ApiException;
import com.konfigthis.splitit.client.ApiResponse;
import com.konfigthis.splitit.client.Configuration;
import com.konfigthis.splitit.client.Pair;
import com.konfigthis.splitit.client.ProgressRequestBody;
import com.konfigthis.splitit.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.konfigthis.splitit.client.model.AddressData;
import com.konfigthis.splitit.client.model.AddressDataModel;
import com.konfigthis.splitit.client.model.CardData;
import com.konfigthis.splitit.client.model.CheckInstallmentsEligibilityRequest;
import com.konfigthis.splitit.client.model.EligibilityTermsAndConditionResponse;
import com.konfigthis.splitit.client.model.EventsEndpointsModel;
import com.konfigthis.splitit.client.model.IdentifierContract;
import com.konfigthis.splitit.client.model.InitiatePlanResponse;
import com.konfigthis.splitit.client.model.InitiateRedirectionEndpointsModel;
import com.konfigthis.splitit.client.model.InstallmentPlanCreateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanCreateResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanGetResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanInitiateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanRefundRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanRefundResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanSearchResponse;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateRequest;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateRequestByIdentifier;
import com.konfigthis.splitit.client.model.InstallmentPlanUpdateResponse;
import com.konfigthis.splitit.client.model.InstallmentsEligibilityResponse;
import com.konfigthis.splitit.client.model.PaymentMethodModel;
import com.konfigthis.splitit.client.model.PlanData;
import com.konfigthis.splitit.client.model.PlanDataModel;
import com.konfigthis.splitit.client.model.ProcessingData;
import com.konfigthis.splitit.client.model.RedirectionEndpointsModel;
import com.konfigthis.splitit.client.model.RefundStrategy;
import com.konfigthis.splitit.client.model.ShippingStatus;
import com.konfigthis.splitit.client.model.ShopperData;
import com.konfigthis.splitit.client.model.UxSettingsModel;
import com.konfigthis.splitit.client.model.VerifyAuthorizationResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class InstallmentPlanApiGenerated {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InstallmentPlanApiGenerated() throws IllegalArgumentException {
        this(Configuration.getDefaultApiClient());
    }

    public InstallmentPlanApiGenerated(ApiClient apiClient) throws IllegalArgumentException {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call checkEligibilityCall(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = checkInstallmentsEligibilityRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/check-eligibility";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call checkEligibilityValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling checkEligibility(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling checkEligibility(Async)");
        }

        // verify the required parameter 'checkInstallmentsEligibilityRequest' is set
        if (checkInstallmentsEligibilityRequest == null) {
            throw new ApiException("Missing the required parameter 'checkInstallmentsEligibilityRequest' when calling checkEligibility(Async)");
        }

        return checkEligibilityCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);

    }


    private ApiResponse<InstallmentsEligibilityResponse> checkEligibilityWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest) throws ApiException {
        okhttp3.Call localVarCall = checkEligibilityValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentsEligibilityResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call checkEligibilityAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest, final ApiCallback<InstallmentsEligibilityResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = checkEligibilityValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentsEligibilityResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class CheckEligibilityRequestBuilderGenerated {
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        PlanData planData;
        CardData cardDetails;
        AddressData billingAddress;
        String shopperIdentifier;

        public CheckEligibilityRequestBuilderGenerated(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set planData
         * @param planData  (optional)
         * @return InstallmentPlanApi.CheckEligibilityRequestBuilder
         */
        public InstallmentPlanApi.CheckEligibilityRequestBuilder planData(PlanData planData) {
            this.planData = planData;
            return (InstallmentPlanApi.CheckEligibilityRequestBuilder) this;
        }
        
        /**
         * Set cardDetails
         * @param cardDetails  (optional)
         * @return InstallmentPlanApi.CheckEligibilityRequestBuilder
         */
        public InstallmentPlanApi.CheckEligibilityRequestBuilder cardDetails(CardData cardDetails) {
            this.cardDetails = cardDetails;
            return (InstallmentPlanApi.CheckEligibilityRequestBuilder) this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return InstallmentPlanApi.CheckEligibilityRequestBuilder
         */
        public InstallmentPlanApi.CheckEligibilityRequestBuilder billingAddress(AddressData billingAddress) {
            this.billingAddress = billingAddress;
            return (InstallmentPlanApi.CheckEligibilityRequestBuilder) this;
        }
        
        /**
         * Set shopperIdentifier
         * @param shopperIdentifier  (optional)
         * @return InstallmentPlanApi.CheckEligibilityRequestBuilder
         */
        public InstallmentPlanApi.CheckEligibilityRequestBuilder shopperIdentifier(String shopperIdentifier) {
            this.shopperIdentifier = shopperIdentifier;
            return (InstallmentPlanApi.CheckEligibilityRequestBuilder) this;
        }
        
        /**
         * Build call for checkEligibility
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityCall(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        }

        private CheckInstallmentsEligibilityRequest buildBodyParams() {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = new CheckInstallmentsEligibilityRequest();
            checkInstallmentsEligibilityRequest.planData(this.planData);
            checkInstallmentsEligibilityRequest.cardDetails(this.cardDetails);
            checkInstallmentsEligibilityRequest.billingAddress(this.billingAddress);
            checkInstallmentsEligibilityRequest.shopperIdentifier(this.shopperIdentifier);
            return checkInstallmentsEligibilityRequest;
        }

        /**
         * Execute checkEligibility request
         * @return InstallmentsEligibilityResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentsEligibilityResponse execute() throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            ApiResponse<InstallmentsEligibilityResponse> localVarResp = checkEligibilityWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute checkEligibility request with HTTP info returned
         * @return ApiResponse&lt;InstallmentsEligibilityResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentsEligibilityResponse> executeWithHttpInfo() throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest);
        }

        /**
         * Execute checkEligibility request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentsEligibilityResponse> _callback) throws ApiException {
            CheckInstallmentsEligibilityRequest checkInstallmentsEligibilityRequest = buildBodyParams();
            return checkEligibilityAsync(xSplititIdempotencyKey, xSplititTouchPoint, checkInstallmentsEligibilityRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param checkInstallmentsEligibilityRequest  (required)
     * @return CheckEligibilityRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.CheckEligibilityRequestBuilder checkEligibility(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new CheckEligibilityRequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call getCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling get(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling get(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling get(Async)");
        }

        return getCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);

    }


    private ApiResponse<InstallmentPlanGetResponse> getWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws ApiException {
        okhttp3.Call localVarCall = getValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanGetResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback<InstallmentPlanGetResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanGetResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class GetRequestBuilderGenerated {
        final String installmentPlanNumber;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;

        public GetRequestBuilderGenerated(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Build call for get
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }


        /**
         * Execute get request
         * @return InstallmentPlanGetResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanGetResponse execute() throws ApiException {
            ApiResponse<InstallmentPlanGetResponse> localVarResp = getWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute get request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanGetResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanGetResponse> executeWithHttpInfo() throws ApiException {
            return getWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
        }

        /**
         * Execute get request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanGetResponse> _callback) throws ApiException {
            return getAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return GetRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.GetRequestBuilder get(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new GetRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call getEligibilityTermsAndConditionCall(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{ipn}/legal"
            .replace("{" + "ipn" + "}", localVarApiClient.escapeString(ipn.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEligibilityTermsAndConditionValidateBeforeCall(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'ipn' is set
        if (ipn == null) {
            throw new ApiException("Missing the required parameter 'ipn' when calling getEligibilityTermsAndCondition(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling getEligibilityTermsAndCondition(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling getEligibilityTermsAndCondition(Async)");
        }

        return getEligibilityTermsAndConditionCall(ipn, xSplititIdempotencyKey, xSplititTouchPoint, _callback);

    }


    private ApiResponse<EligibilityTermsAndConditionResponse> getEligibilityTermsAndConditionWithHttpInfo(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint) throws ApiException {
        okhttp3.Call localVarCall = getEligibilityTermsAndConditionValidateBeforeCall(ipn, xSplititIdempotencyKey, xSplititTouchPoint, null);
        Type localVarReturnType = new TypeToken<EligibilityTermsAndConditionResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call getEligibilityTermsAndConditionAsync(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback<EligibilityTermsAndConditionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEligibilityTermsAndConditionValidateBeforeCall(ipn, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        Type localVarReturnType = new TypeToken<EligibilityTermsAndConditionResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class GetEligibilityTermsAndConditionRequestBuilderGenerated {
        final String ipn;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;

        public GetEligibilityTermsAndConditionRequestBuilderGenerated(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.ipn = ipn;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Build call for getEligibilityTermsAndCondition
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return getEligibilityTermsAndConditionCall(ipn, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }


        /**
         * Execute getEligibilityTermsAndCondition request
         * @return EligibilityTermsAndConditionResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public EligibilityTermsAndConditionResponse execute() throws ApiException {
            ApiResponse<EligibilityTermsAndConditionResponse> localVarResp = getEligibilityTermsAndConditionWithHttpInfo(ipn, xSplititIdempotencyKey, xSplititTouchPoint);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute getEligibilityTermsAndCondition request with HTTP info returned
         * @return ApiResponse&lt;EligibilityTermsAndConditionResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<EligibilityTermsAndConditionResponse> executeWithHttpInfo() throws ApiException {
            return getEligibilityTermsAndConditionWithHttpInfo(ipn, xSplititIdempotencyKey, xSplititTouchPoint);
        }

        /**
         * Execute getEligibilityTermsAndCondition request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<EligibilityTermsAndConditionResponse> _callback) throws ApiException {
            return getEligibilityTermsAndConditionAsync(ipn, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }
    }

    /**
     * 
     * 
     * @param ipn  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return GetEligibilityTermsAndConditionRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.GetEligibilityTermsAndConditionRequestBuilder getEligibilityTermsAndCondition(String ipn, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (ipn == null) throw new IllegalArgumentException("\"ipn\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new GetEligibilityTermsAndConditionRequestBuilder(ipn, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call postCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanInitiateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/initiate";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititTestMode != null) {
            localVarHeaderParams.put("X-Splitit-TestMode", localVarApiClient.parameterToString(xSplititTestMode));
        }

        if (xSplititStrategy != null) {
            localVarHeaderParams.put("X-Splitit-Strategy", localVarApiClient.parameterToString(xSplititStrategy));
        }

        if (splititclientinfo != null) {
            localVarHeaderParams.put("Splititclientinfo", localVarApiClient.parameterToString(splititclientinfo));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call postValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling post(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling post(Async)");
        }

        // verify the required parameter 'installmentPlanInitiateRequest' is set
        if (installmentPlanInitiateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanInitiateRequest' when calling post(Async)");
        }

        return postCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);

    }


    private ApiResponse<InitiatePlanResponse> postWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo) throws ApiException {
        okhttp3.Call localVarCall = postValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, null);
        Type localVarReturnType = new TypeToken<InitiatePlanResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call postAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanInitiateRequest installmentPlanInitiateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback<InitiatePlanResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = postValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        Type localVarReturnType = new TypeToken<InitiatePlanResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class PostRequestBuilderGenerated {
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        Boolean autoCapture;
        Boolean attempt3dSecure;
        ShopperData shopper;
        PlanDataModel planData;
        AddressDataModel billingAddress;
        InitiateRedirectionEndpointsModel redirectUrls;
        UxSettingsModel uxSettings;
        EventsEndpointsModel eventsEndpoints;
        ProcessingData processingData;
        String xSplititTestMode;
        String xSplititStrategy;
        String splititclientinfo;

        public PostRequestBuilderGenerated(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set autoCapture
         * @param autoCapture  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder autoCapture(Boolean autoCapture) {
            this.autoCapture = autoCapture;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set attempt3dSecure
         * @param attempt3dSecure  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder attempt3dSecure(Boolean attempt3dSecure) {
            this.attempt3dSecure = attempt3dSecure;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set shopper
         * @param shopper  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder shopper(ShopperData shopper) {
            this.shopper = shopper;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set planData
         * @param planData  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder planData(PlanDataModel planData) {
            this.planData = planData;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder billingAddress(AddressDataModel billingAddress) {
            this.billingAddress = billingAddress;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set redirectUrls
         * @param redirectUrls  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder redirectUrls(InitiateRedirectionEndpointsModel redirectUrls) {
            this.redirectUrls = redirectUrls;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set uxSettings
         * @param uxSettings  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder uxSettings(UxSettingsModel uxSettings) {
            this.uxSettings = uxSettings;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set eventsEndpoints
         * @param eventsEndpoints  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder eventsEndpoints(EventsEndpointsModel eventsEndpoints) {
            this.eventsEndpoints = eventsEndpoints;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set processingData
         * @param processingData  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder processingData(ProcessingData processingData) {
            this.processingData = processingData;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set xSplititTestMode
         * @param xSplititTestMode  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder xSplititTestMode(String xSplititTestMode) {
            this.xSplititTestMode = xSplititTestMode;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set xSplititStrategy
         * @param xSplititStrategy  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder xSplititStrategy(String xSplititStrategy) {
            this.xSplititStrategy = xSplititStrategy;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Set splititclientinfo
         * @param splititclientinfo  (optional)
         * @return InstallmentPlanApi.PostRequestBuilder
         */
        public InstallmentPlanApi.PostRequestBuilder splititclientinfo(String splititclientinfo) {
            this.splititclientinfo = splititclientinfo;
            return (InstallmentPlanApi.PostRequestBuilder) this;
        }
        
        /**
         * Build call for post
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        }

        private InstallmentPlanInitiateRequest buildBodyParams() {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = new InstallmentPlanInitiateRequest();
            installmentPlanInitiateRequest.autoCapture(this.autoCapture);
            installmentPlanInitiateRequest.attempt3dSecure(this.attempt3dSecure);
            installmentPlanInitiateRequest.shopper(this.shopper);
            installmentPlanInitiateRequest.planData(this.planData);
            installmentPlanInitiateRequest.billingAddress(this.billingAddress);
            installmentPlanInitiateRequest.redirectUrls(this.redirectUrls);
            installmentPlanInitiateRequest.uxSettings(this.uxSettings);
            installmentPlanInitiateRequest.eventsEndpoints(this.eventsEndpoints);
            installmentPlanInitiateRequest.processingData(this.processingData);
            return installmentPlanInitiateRequest;
        }

        /**
         * Execute post request
         * @return InitiatePlanResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InitiatePlanResponse execute() throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            ApiResponse<InitiatePlanResponse> localVarResp = postWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute post request with HTTP info returned
         * @return ApiResponse&lt;InitiatePlanResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InitiatePlanResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo);
        }

        /**
         * Execute post request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InitiatePlanResponse> _callback) throws ApiException {
            InstallmentPlanInitiateRequest installmentPlanInitiateRequest = buildBodyParams();
            return postAsync(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanInitiateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanInitiateRequest  (required)
     * @return PostRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.PostRequestBuilder post(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new PostRequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call post2Call(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanCreateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititTestMode != null) {
            localVarHeaderParams.put("X-Splitit-TestMode", localVarApiClient.parameterToString(xSplititTestMode));
        }

        if (xSplititStrategy != null) {
            localVarHeaderParams.put("X-Splitit-Strategy", localVarApiClient.parameterToString(xSplititStrategy));
        }

        if (splititclientinfo != null) {
            localVarHeaderParams.put("Splititclientinfo", localVarApiClient.parameterToString(splititclientinfo));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call post2ValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling post2(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling post2(Async)");
        }

        // verify the required parameter 'installmentPlanCreateRequest' is set
        if (installmentPlanCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanCreateRequest' when calling post2(Async)");
        }

        return post2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);

    }


    private ApiResponse<InstallmentPlanCreateResponse> post2WithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo) throws ApiException {
        okhttp3.Call localVarCall = post2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanCreateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call post2Async(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanCreateRequest installmentPlanCreateRequest, String xSplititTestMode, String xSplititStrategy, String splititclientinfo, final ApiCallback<InstallmentPlanCreateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = post2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanCreateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class Post2RequestBuilderGenerated {
        final Boolean autoCapture;
        final Boolean termsAndConditionsAccepted;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        Boolean attempt3dSecure;
        ShopperData shopper;
        PlanDataModel planData;
        AddressDataModel billingAddress;
        PaymentMethodModel paymentMethod;
        RedirectionEndpointsModel redirectUrls;
        ProcessingData processingData;
        EventsEndpointsModel eventsEndpoints;
        String xSplititTestMode;
        String xSplititStrategy;
        String splititclientinfo;

        public Post2RequestBuilderGenerated(Boolean autoCapture, Boolean termsAndConditionsAccepted, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.autoCapture = autoCapture;
            this.termsAndConditionsAccepted = termsAndConditionsAccepted;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set attempt3dSecure
         * @param attempt3dSecure  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder attempt3dSecure(Boolean attempt3dSecure) {
            this.attempt3dSecure = attempt3dSecure;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set shopper
         * @param shopper  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder shopper(ShopperData shopper) {
            this.shopper = shopper;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set planData
         * @param planData  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder planData(PlanDataModel planData) {
            this.planData = planData;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set billingAddress
         * @param billingAddress  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder billingAddress(AddressDataModel billingAddress) {
            this.billingAddress = billingAddress;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set paymentMethod
         * @param paymentMethod  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder paymentMethod(PaymentMethodModel paymentMethod) {
            this.paymentMethod = paymentMethod;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set redirectUrls
         * @param redirectUrls  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder redirectUrls(RedirectionEndpointsModel redirectUrls) {
            this.redirectUrls = redirectUrls;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set processingData
         * @param processingData  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder processingData(ProcessingData processingData) {
            this.processingData = processingData;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set eventsEndpoints
         * @param eventsEndpoints  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder eventsEndpoints(EventsEndpointsModel eventsEndpoints) {
            this.eventsEndpoints = eventsEndpoints;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set xSplititTestMode
         * @param xSplititTestMode  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder xSplititTestMode(String xSplititTestMode) {
            this.xSplititTestMode = xSplititTestMode;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set xSplititStrategy
         * @param xSplititStrategy  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder xSplititStrategy(String xSplititStrategy) {
            this.xSplititStrategy = xSplititStrategy;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Set splititclientinfo
         * @param splititclientinfo  (optional)
         * @return InstallmentPlanApi.Post2RequestBuilder
         */
        public InstallmentPlanApi.Post2RequestBuilder splititclientinfo(String splititclientinfo) {
            this.splititclientinfo = splititclientinfo;
            return (InstallmentPlanApi.Post2RequestBuilder) this;
        }
        
        /**
         * Build call for post2
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        }

        private InstallmentPlanCreateRequest buildBodyParams() {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = new InstallmentPlanCreateRequest();
            installmentPlanCreateRequest.autoCapture(this.autoCapture);
            installmentPlanCreateRequest.attempt3dSecure(this.attempt3dSecure);
            installmentPlanCreateRequest.termsAndConditionsAccepted(this.termsAndConditionsAccepted);
            installmentPlanCreateRequest.shopper(this.shopper);
            installmentPlanCreateRequest.planData(this.planData);
            installmentPlanCreateRequest.billingAddress(this.billingAddress);
            installmentPlanCreateRequest.paymentMethod(this.paymentMethod);
            installmentPlanCreateRequest.redirectUrls(this.redirectUrls);
            installmentPlanCreateRequest.processingData(this.processingData);
            installmentPlanCreateRequest.eventsEndpoints(this.eventsEndpoints);
            return installmentPlanCreateRequest;
        }

        /**
         * Execute post2 request
         * @return InstallmentPlanCreateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanCreateResponse execute() throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            ApiResponse<InstallmentPlanCreateResponse> localVarResp = post2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute post2 request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanCreateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanCreateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo);
        }

        /**
         * Execute post2 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanCreateResponse> _callback) throws ApiException {
            InstallmentPlanCreateRequest installmentPlanCreateRequest = buildBodyParams();
            return post2Async(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanCreateRequest, xSplititTestMode, xSplititStrategy, splititclientinfo, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanCreateRequest  (required)
     * @return Post2RequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.Post2RequestBuilder post2(Boolean autoCapture, Boolean termsAndConditionsAccepted, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (autoCapture == null) throw new IllegalArgumentException("\"autoCapture\" is required but got null");
        if (termsAndConditionsAccepted == null) throw new IllegalArgumentException("\"termsAndConditionsAccepted\" is required but got null");
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new Post2RequestBuilder(autoCapture, termsAndConditionsAccepted, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call refundCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanRefundRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/refund"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call refundValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling refund(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling refund(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling refund(Async)");
        }

        // verify the required parameter 'installmentPlanRefundRequest' is set
        if (installmentPlanRefundRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanRefundRequest' when calling refund(Async)");
        }

        return refundCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);

    }


    private ApiResponse<InstallmentPlanRefundResponse> refundWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest) throws ApiException {
        okhttp3.Call localVarCall = refundValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanRefundResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call refundAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanRefundRequest installmentPlanRefundRequest, final ApiCallback<InstallmentPlanRefundResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = refundValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanRefundResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class RefundRequestBuilderGenerated {
        final Double amount;
        final String installmentPlanNumber;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        RefundStrategy refundStrategy;
        String referenceId;

        public RefundRequestBuilderGenerated(double amount, String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.amount = amount;
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refundStrategy
         * @param refundStrategy  (optional)
         * @return InstallmentPlanApi.RefundRequestBuilder
         */
        public InstallmentPlanApi.RefundRequestBuilder refundStrategy(RefundStrategy refundStrategy) {
            this.refundStrategy = refundStrategy;
            return (InstallmentPlanApi.RefundRequestBuilder) this;
        }
        
        /**
         * Set referenceId
         * @param referenceId  (optional)
         * @return InstallmentPlanApi.RefundRequestBuilder
         */
        public InstallmentPlanApi.RefundRequestBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return (InstallmentPlanApi.RefundRequestBuilder) this;
        }
        
        /**
         * Build call for refund
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        }

        private InstallmentPlanRefundRequest buildBodyParams() {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = new InstallmentPlanRefundRequest();
            installmentPlanRefundRequest.amount(this.amount);
            installmentPlanRefundRequest.refundStrategy(this.refundStrategy);
            installmentPlanRefundRequest.referenceId(this.referenceId);
            return installmentPlanRefundRequest;
        }

        /**
         * Execute refund request
         * @return InstallmentPlanRefundResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanRefundResponse execute() throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            ApiResponse<InstallmentPlanRefundResponse> localVarResp = refundWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute refund request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanRefundResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanRefundResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest);
        }

        /**
         * Execute refund request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanRefundResponse> _callback) throws ApiException {
            InstallmentPlanRefundRequest installmentPlanRefundRequest = buildBodyParams();
            return refundAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanRefundRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanRefundRequest  (required)
     * @return RefundRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.RefundRequestBuilder refund(double amount, String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new RefundRequestBuilder(amount, installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call searchCall(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (installmentPlanNumber != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("installmentPlanNumber", installmentPlanNumber));
        }

        if (refOrderNumber != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("refOrderNumber", refOrderNumber));
        }

        if (extendedParams != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("extendedParams", extendedParams));
        }

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling search(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling search(Async)");
        }

        return searchCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);

    }


    private ApiResponse<InstallmentPlanSearchResponse> searchWithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams) throws ApiException {
        okhttp3.Call localVarCall = searchValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanSearchResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call searchAsync(String xSplititIdempotencyKey, String xSplititTouchPoint, String installmentPlanNumber, String refOrderNumber, Map<String, String> extendedParams, final ApiCallback<InstallmentPlanSearchResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = searchValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanSearchResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class SearchRequestBuilderGenerated {
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        String installmentPlanNumber;
        String refOrderNumber;
        Map<String, String> extendedParams;

        public SearchRequestBuilderGenerated(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set installmentPlanNumber
         * @param installmentPlanNumber  (optional)
         * @return InstallmentPlanApi.SearchRequestBuilder
         */
        public InstallmentPlanApi.SearchRequestBuilder installmentPlanNumber(String installmentPlanNumber) {
            this.installmentPlanNumber = installmentPlanNumber;
            return (InstallmentPlanApi.SearchRequestBuilder) this;
        }
        
        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return InstallmentPlanApi.SearchRequestBuilder
         */
        public InstallmentPlanApi.SearchRequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return (InstallmentPlanApi.SearchRequestBuilder) this;
        }
        
        /**
         * Set extendedParams
         * @param extendedParams  (optional)
         * @return InstallmentPlanApi.SearchRequestBuilder
         */
        public InstallmentPlanApi.SearchRequestBuilder extendedParams(Map<String, String> extendedParams) {
            this.extendedParams = extendedParams;
            return (InstallmentPlanApi.SearchRequestBuilder) this;
        }
        
        /**
         * Build call for search
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return searchCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        }


        /**
         * Execute search request
         * @return InstallmentPlanSearchResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanSearchResponse execute() throws ApiException {
            ApiResponse<InstallmentPlanSearchResponse> localVarResp = searchWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute search request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanSearchResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanSearchResponse> executeWithHttpInfo() throws ApiException {
            return searchWithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams);
        }

        /**
         * Execute search request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanSearchResponse> _callback) throws ApiException {
            return searchAsync(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanNumber, refOrderNumber, extendedParams, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return SearchRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.SearchRequestBuilder search(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new SearchRequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call updateOrderCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanUpdateRequest;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/updateorder"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateOrderValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling updateOrder(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling updateOrder(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling updateOrder(Async)");
        }

        // verify the required parameter 'installmentPlanUpdateRequest' is set
        if (installmentPlanUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanUpdateRequest' when calling updateOrder(Async)");
        }

        return updateOrderCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);

    }


    private ApiResponse<InstallmentPlanUpdateResponse> updateOrderWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateOrderValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call updateOrderAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequest installmentPlanUpdateRequest, final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateOrderValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class UpdateOrderRequestBuilderGenerated {
        final String installmentPlanNumber;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        String refOrderNumber;
        String trackingNumber;
        Boolean capture;
        ShippingStatus shippingStatus;
        Double newAmount;

        public UpdateOrderRequestBuilderGenerated(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return InstallmentPlanApi.UpdateOrderRequestBuilder
         */
        public InstallmentPlanApi.UpdateOrderRequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return (InstallmentPlanApi.UpdateOrderRequestBuilder) this;
        }
        
        /**
         * Set trackingNumber
         * @param trackingNumber  (optional)
         * @return InstallmentPlanApi.UpdateOrderRequestBuilder
         */
        public InstallmentPlanApi.UpdateOrderRequestBuilder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return (InstallmentPlanApi.UpdateOrderRequestBuilder) this;
        }
        
        /**
         * Set capture
         * @param capture  (optional)
         * @return InstallmentPlanApi.UpdateOrderRequestBuilder
         */
        public InstallmentPlanApi.UpdateOrderRequestBuilder capture(Boolean capture) {
            this.capture = capture;
            return (InstallmentPlanApi.UpdateOrderRequestBuilder) this;
        }
        
        /**
         * Set shippingStatus
         * @param shippingStatus  (optional)
         * @return InstallmentPlanApi.UpdateOrderRequestBuilder
         */
        public InstallmentPlanApi.UpdateOrderRequestBuilder shippingStatus(ShippingStatus shippingStatus) {
            this.shippingStatus = shippingStatus;
            return (InstallmentPlanApi.UpdateOrderRequestBuilder) this;
        }
        
        /**
         * Set newAmount
         * @param newAmount  (optional)
         * @return InstallmentPlanApi.UpdateOrderRequestBuilder
         */
        public InstallmentPlanApi.UpdateOrderRequestBuilder newAmount(Double newAmount) {
            this.newAmount = newAmount;
            return (InstallmentPlanApi.UpdateOrderRequestBuilder) this;
        }
        
        /**
         * Build call for updateOrder
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        }

        private InstallmentPlanUpdateRequest buildBodyParams() {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = new InstallmentPlanUpdateRequest();
            installmentPlanUpdateRequest.refOrderNumber(this.refOrderNumber);
            installmentPlanUpdateRequest.trackingNumber(this.trackingNumber);
            installmentPlanUpdateRequest.capture(this.capture);
            installmentPlanUpdateRequest.shippingStatus(this.shippingStatus);
            installmentPlanUpdateRequest.newAmount(this.newAmount);
            return installmentPlanUpdateRequest;
        }

        /**
         * Execute updateOrder request
         * @return InstallmentPlanUpdateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanUpdateResponse execute() throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            ApiResponse<InstallmentPlanUpdateResponse> localVarResp = updateOrderWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute updateOrder request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanUpdateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanUpdateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest);
        }

        /**
         * Execute updateOrder request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {
            InstallmentPlanUpdateRequest installmentPlanUpdateRequest = buildBodyParams();
            return updateOrderAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequest, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanUpdateRequest  (required)
     * @return UpdateOrderRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.UpdateOrderRequestBuilder updateOrder(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new UpdateOrderRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call updateOrder2Call(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = installmentPlanUpdateRequestByIdentifier;

        // create path and map variables
        String localVarPath = "/api/installmentplans/updateorder";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json",
            "text/json",
            "application/json-patch+json",
            "application/*+json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateOrder2ValidateBeforeCall(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling updateOrder2(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling updateOrder2(Async)");
        }

        // verify the required parameter 'installmentPlanUpdateRequestByIdentifier' is set
        if (installmentPlanUpdateRequestByIdentifier == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanUpdateRequestByIdentifier' when calling updateOrder2(Async)");
        }

        return updateOrder2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);

    }


    private ApiResponse<InstallmentPlanUpdateResponse> updateOrder2WithHttpInfo(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier) throws ApiException {
        okhttp3.Call localVarCall = updateOrder2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, null);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call updateOrder2Async(String xSplititIdempotencyKey, String xSplititTouchPoint, InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier, final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateOrder2ValidateBeforeCall(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        Type localVarReturnType = new TypeToken<InstallmentPlanUpdateResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class UpdateOrder2RequestBuilderGenerated {
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;
        String refOrderNumber;
        String trackingNumber;
        Boolean capture;
        ShippingStatus shippingStatus;
        Double newAmount;
        IdentifierContract identifier;

        public UpdateOrder2RequestBuilderGenerated(String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Set refOrderNumber
         * @param refOrderNumber  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder refOrderNumber(String refOrderNumber) {
            this.refOrderNumber = refOrderNumber;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Set trackingNumber
         * @param trackingNumber  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Set capture
         * @param capture  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder capture(Boolean capture) {
            this.capture = capture;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Set shippingStatus
         * @param shippingStatus  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder shippingStatus(ShippingStatus shippingStatus) {
            this.shippingStatus = shippingStatus;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Set newAmount
         * @param newAmount  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder newAmount(Double newAmount) {
            this.newAmount = newAmount;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Set identifier
         * @param identifier  (optional)
         * @return InstallmentPlanApi.UpdateOrder2RequestBuilder
         */
        public InstallmentPlanApi.UpdateOrder2RequestBuilder identifier(IdentifierContract identifier) {
            this.identifier = identifier;
            return (InstallmentPlanApi.UpdateOrder2RequestBuilder) this;
        }
        
        /**
         * Build call for updateOrder2
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2Call(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        }

        private InstallmentPlanUpdateRequestByIdentifier buildBodyParams() {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = new InstallmentPlanUpdateRequestByIdentifier();
            return installmentPlanUpdateRequestByIdentifier;
        }

        /**
         * Execute updateOrder2 request
         * @return InstallmentPlanUpdateResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public InstallmentPlanUpdateResponse execute() throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            ApiResponse<InstallmentPlanUpdateResponse> localVarResp = updateOrder2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute updateOrder2 request with HTTP info returned
         * @return ApiResponse&lt;InstallmentPlanUpdateResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<InstallmentPlanUpdateResponse> executeWithHttpInfo() throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2WithHttpInfo(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier);
        }

        /**
         * Execute updateOrder2 request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<InstallmentPlanUpdateResponse> _callback) throws ApiException {
            InstallmentPlanUpdateRequestByIdentifier installmentPlanUpdateRequestByIdentifier = buildBodyParams();
            return updateOrder2Async(xSplititIdempotencyKey, xSplititTouchPoint, installmentPlanUpdateRequestByIdentifier, _callback);
        }
    }

    /**
     * 
     * 
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @param installmentPlanUpdateRequestByIdentifier  (required)
     * @return UpdateOrder2RequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.UpdateOrder2RequestBuilder updateOrder2(String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new UpdateOrder2RequestBuilder(xSplititIdempotencyKey, xSplititTouchPoint);
    }
    private okhttp3.Call verifyAuthorizationCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/installmentplans/{installmentPlanNumber}/verifyauthorization"
            .replace("{" + "installmentPlanNumber" + "}", localVarApiClient.escapeString(installmentPlanNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (xSplititIdempotencyKey != null) {
            localVarHeaderParams.put("X-Splitit-IdempotencyKey", localVarApiClient.parameterToString(xSplititIdempotencyKey));
        }

        if (xSplititTouchPoint != null) {
            localVarHeaderParams.put("X-Splitit-TouchPoint", localVarApiClient.parameterToString(xSplititTouchPoint));
        }

        final String[] localVarAccepts = {
            "application/json",
            "text/json",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "oauth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call verifyAuthorizationValidateBeforeCall(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'installmentPlanNumber' is set
        if (installmentPlanNumber == null) {
            throw new ApiException("Missing the required parameter 'installmentPlanNumber' when calling verifyAuthorization(Async)");
        }

        // verify the required parameter 'xSplititIdempotencyKey' is set
        if (xSplititIdempotencyKey == null) {
            throw new ApiException("Missing the required parameter 'xSplititIdempotencyKey' when calling verifyAuthorization(Async)");
        }

        // verify the required parameter 'xSplititTouchPoint' is set
        if (xSplititTouchPoint == null) {
            throw new ApiException("Missing the required parameter 'xSplititTouchPoint' when calling verifyAuthorization(Async)");
        }

        return verifyAuthorizationCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);

    }


    private ApiResponse<VerifyAuthorizationResponse> verifyAuthorizationWithHttpInfo(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws ApiException {
        okhttp3.Call localVarCall = verifyAuthorizationValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, null);
        Type localVarReturnType = new TypeToken<VerifyAuthorizationResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call verifyAuthorizationAsync(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint, final ApiCallback<VerifyAuthorizationResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = verifyAuthorizationValidateBeforeCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        Type localVarReturnType = new TypeToken<VerifyAuthorizationResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public abstract class VerifyAuthorizationRequestBuilderGenerated {
        final String installmentPlanNumber;
        final String xSplititIdempotencyKey;
        final String xSplititTouchPoint;

        public VerifyAuthorizationRequestBuilderGenerated(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) {
            this.installmentPlanNumber = installmentPlanNumber;
            this.xSplititIdempotencyKey = xSplititIdempotencyKey;
            this.xSplititTouchPoint = xSplititTouchPoint;
        }

        /**
         * Build call for verifyAuthorization
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return verifyAuthorizationCall(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }


        /**
         * Execute verifyAuthorization request
         * @return VerifyAuthorizationResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public VerifyAuthorizationResponse execute() throws ApiException {
            ApiResponse<VerifyAuthorizationResponse> localVarResp = verifyAuthorizationWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
            return localVarResp.getResponseBody();
        }

        /**
         * Execute verifyAuthorization request with HTTP info returned
         * @return ApiResponse&lt;VerifyAuthorizationResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<VerifyAuthorizationResponse> executeWithHttpInfo() throws ApiException {
            return verifyAuthorizationWithHttpInfo(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
        }

        /**
         * Execute verifyAuthorization request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<VerifyAuthorizationResponse> _callback) throws ApiException {
            return verifyAuthorizationAsync(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint, _callback);
        }
    }

    /**
     * 
     * 
     * @param installmentPlanNumber  (required)
     * @param xSplititIdempotencyKey  (required)
     * @param xSplititTouchPoint TouchPoint (required)
     * @return VerifyAuthorizationRequestBuilder
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td>  </td><td>  -  </td></tr>
     </table>
     */
    public InstallmentPlanApi.VerifyAuthorizationRequestBuilder verifyAuthorization(String installmentPlanNumber, String xSplititIdempotencyKey, String xSplititTouchPoint) throws IllegalArgumentException {
        if (installmentPlanNumber == null) throw new IllegalArgumentException("\"installmentPlanNumber\" is required but got null");
            

        if (xSplititIdempotencyKey == null) throw new IllegalArgumentException("\"xSplititIdempotencyKey\" is required but got null");
            

        if (xSplititTouchPoint == null) throw new IllegalArgumentException("\"xSplititTouchPoint\" is required but got null");
            

        return ((InstallmentPlanApi) this).new VerifyAuthorizationRequestBuilder(installmentPlanNumber, xSplititIdempotencyKey, xSplititTouchPoint);
    }
}
