/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.ksptooi.guice.compomentscan.ComponentScanModule;
import com.ksptooi.psm.mybatis.DatabaseModule;
import com.ksptooi.psm.processor.ServiceUnitManager;
import com.ksptooi.psm.shell.SshModules;
import com.ksptooi.psm.subsystem.SubSystemManager;
import com.ksptooi.psm.subsystem.SubSystemScanner;
import com.ksptooi.psm.subsystem.entity.DiscoveredSubSystem;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class Application {
    public static final ComponentScanModule csm = new ComponentScanModule("com.ksptooi");
    public static final Injector injector = Guice.createInjector((Module[])new Module[]{new SshModules(), new DatabaseModule(), csm});
    public static final String version = "4.0A";
    public static final String platform = "x64";

    public static void main(String[] p) throws InterruptedException {
        SubSystemScanner subSystemScanner = (SubSystemScanner)injector.getInstance(SubSystemScanner.class);
        List<DiscoveredSubSystem> scan = subSystemScanner.scan("./subsystems");
        SubSystemManager subMgr = (SubSystemManager)injector.getInstance(SubSystemManager.class);
        subMgr.install(scan);
        ServiceUnitManager unitMgr = (ServiceUnitManager)injector.getInstance(ServiceUnitManager.class);
        unitMgr.scanFromPackage("com.ksptooi.psm");
        unitMgr.scanFromPackage("com.ksptooi.inner");
        unitMgr.installRequestHandler();
        unitMgr.installEventHandler();
        CountDownLatch cdl = new CountDownLatch(1);
        cdl.await();
    }
}

