/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.guice.compomentscan;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.ksptooi.guice.annotations.MultiInstance;
import com.ksptooi.guice.annotations.Unit;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class ComponentScanModule
extends AbstractModule {
    private final String packageName;
    private final Set<Class<? extends Annotation>> bindingAnnotations;

    public ComponentScanModule(String packageName) {
        this.packageName = packageName;
        this.bindingAnnotations = new HashSet<Class<? extends Annotation>>();
        this.bindingAnnotations.add(Unit.class);
    }

    @SafeVarargs
    public ComponentScanModule(String packageName, Class<? extends Annotation> ... bindingAnnotations) {
        this.packageName = packageName;
        this.bindingAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(bindingAnnotations));
    }

    public void configure() {
        Reflections packageReflections = new Reflections(this.packageName, new Scanner[0]);
        List collect = this.bindingAnnotations.stream().map(arg_0 -> ((Reflections)packageReflections).getTypesAnnotatedWith(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        for (Class clazz : collect) {
            MultiInstance multi = clazz.getAnnotation(MultiInstance.class);
            if (multi == null) {
                this.bind(clazz).in(Scopes.SINGLETON);
                continue;
            }
            this.bind(clazz).in(Scopes.NO_SCOPE);
        }
    }
}

