/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.inner;

import com.ksptooi.psm.mapper.StatementHistoryMapper;
import com.ksptooi.psm.mapper.UsersMapper;
import com.ksptooi.psm.modes.StatementHistoryVo;
import com.ksptooi.psm.modes.UserVo;
import com.ksptooi.psm.processor.EventHandler;
import com.ksptooi.psm.processor.ServiceUnit;
import com.ksptooi.psm.processor.ShellRequest;
import com.ksptooi.psm.processor.event.BadRequestEvent;
import com.ksptooi.psm.processor.event.StatementCommitEvent;
import com.ksptooi.psm.utils.aio.AdvInputOutputCable;
import jakarta.inject.Inject;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.apache.sshd.server.session.ServerSession;
import xyz.downgoon.snowflake.Snowflake;

@ServiceUnit(value="bundled:UserStatementSrvUnit")
public class UserStatementSrvUnit {
    @Inject
    private StatementHistoryMapper statementHistMapper;
    @Inject
    private UsersMapper usersMapper;
    @Inject
    private Snowflake snowflake;

    @EventHandler(global=true)
    public void saveUserStatement(StatementCommitEvent event) {
        ServerSession session = event.getUserShell().getSession().getSession();
        byte[] sessionId = session.getSessionId();
        String account = session.getUsername();
        UserVo userVo = this.usersMapper.getByAccount(account);
        String statement = event.getStatement();
        StatementHistoryVo i = new StatementHistoryVo();
        i.setId(this.snowflake.nextId());
        i.setUserId(userVo.getUid());
        i.setUserAccount(userVo.getAccount());
        i.setStatement(statement);
        i.setSessionId(Hex.encodeHexString((byte[])sessionId));
        i.setIpAddress(session.getClientAddress().toString());
        i.setAtTime(new Date());
        this.statementHistMapper.insert(i);
    }

    @EventHandler(global=true)
    public void badRequestNotify(BadRequestEvent event) {
        ShellRequest request = event.getRequest();
        AdvInputOutputCable cable = request.getShell().getCable();
        if (event.getErrorCode().equals("PSM:STM:E3")) {
            return;
        }
        if (event.getErrorCode().equals("PSM:STM:E1")) {
            cable.w("fatal: ").w(request.getPattern()).w("\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42,\u5904\u7406\u5668\u4e0e\u6807\u5b9a\u7684\u4e0d\u4e00\u81f4.");
            cable.nextLine();
            return;
        }
        cable.w("\u001b[0;31m").w(request.getPattern()).w(": \u65e0\u6cd5\u5904\u7406\u8bf7\u6c42,\u5339\u914d\u5904\u7406\u5668\u5931\u8d25.").w("\u001b[0m");
        cable.nextLine();
    }
}

