/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.configset;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.configset.ConfigSetVo;
import com.ksptooi.psm.mapper.ConfigSetMapper;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.h2.util.StringUtils;
import xyz.downgoon.snowflake.Snowflake;

@Unit
public class ConfigSet {
    @Inject
    private ConfigSetMapper mapper;
    @Inject
    private Snowflake snowflake;

    public ConfigSetVo create(String key, String def) {
        ConfigSetVo i = new ConfigSetVo();
        i.setId(this.snowflake.nextId());
        i.setKey(key);
        i.setVal(def);
        i.setDef(def);
        i.setUserId(-1L);
        i.setDescription(null);
        i.setCreateTime(new Date());
        this.mapper.insert(i);
        return i;
    }

    public void remove(String key) {
    }

    public String valOf(String key) {
        List<ConfigSetVo> byKey = this.mapper.getByKey(key);
        if (byKey == null || byKey.isEmpty()) {
            return null;
        }
        ConfigSetVo data = byKey.getFirst();
        if (StringUtils.isNullOrEmpty((String)data.getVal())) {
            return data.getDef();
        }
        return data.getVal();
    }

    public String valOf(String key, String def) {
        String val = this.valOf(key);
        if (StringUtils.isNullOrEmpty((String)val)) {
            ConfigSetVo i = this.create(key, def);
            return i.getDef();
        }
        return val;
    }

    public List<String> valsOf(String key) {
        List<ConfigSetVo> vo = this.mapper.getByKey(key);
        if (vo == null || vo.isEmpty()) {
            return null;
        }
        return vo.stream().map(ConfigSetVo::getVal).toList();
    }

    public List<String> valsOf(String key, String def) {
        List<ConfigSetVo> vo = this.mapper.getByKey(key);
        if (vo == null || vo.isEmpty()) {
            ConfigSetVo i = this.create(key, def);
            return Collections.singletonList(i.getDef());
        }
        return vo.stream().map(ConfigSetVo::getVal).toList();
    }
}

