/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.processor;

import com.alibaba.fastjson.JSON;
import com.ksptooi.Application;
import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.mapper.RequestHandlerMapper;
import com.ksptooi.psm.modes.RequestHandlerVo;
import com.ksptooi.psm.processor.DefineTools;
import com.ksptooi.psm.processor.EventSchedule;
import com.ksptooi.psm.processor.ServiceUnit;
import com.ksptooi.psm.processor.ShellRequest;
import com.ksptooi.psm.processor.SrvDefineException;
import com.ksptooi.psm.processor.SrvUnitTools;
import com.ksptooi.psm.processor.TaskManager;
import com.ksptooi.psm.processor.entity.ActivatedSrvUnit;
import com.ksptooi.psm.processor.entity.HookTaskFinished;
import com.ksptooi.psm.processor.entity.Process;
import com.ksptooi.psm.processor.entity.SrvDefine;
import com.ksptooi.psm.processor.event.BadRequestEvent;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.downgoon.snowflake.Snowflake;

@Unit
public class ServiceUnitManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceUnitManager.class);
    @Inject
    private RequestHandlerMapper requestHandlerMapper;
    @Inject
    private Snowflake snowflake;
    @Inject
    private TaskManager taskManager;
    @Inject
    private EventSchedule eventSchedule;
    private static final Map<String, ActivatedSrvUnit> procMap = new ConcurrentHashMap<String, ActivatedSrvUnit>();

    public void register(List<Object> procMap) {
        for (Object obj : procMap) {
            this.register(obj);
        }
    }

    public void register(Object proc) {
        String procName = SrvUnitTools.getSrvUnitName(proc.getClass());
        String classType = proc.getClass().getName();
        try {
            List<SrvDefine> srvDefine = SrvUnitTools.getSrvDefine(proc.getClass());
            if (procMap.containsKey(procName)) {
                log.warn("\u65e0\u6cd5\u6ce8\u518c\u670d\u52a1\u5355\u5143:{} \u670d\u52a1\u5355\u5143\u540d\u79f0\u51b2\u7a81,\u5f53\u524d\u5df2\u6ce8\u518c\u4e86\u4e00\u4e2a\u76f8\u540c\u540d\u5b57\u7684\u670d\u52a1\u5355\u5143.", (Object)procName);
                return;
            }
            ActivatedSrvUnit p = new ActivatedSrvUnit();
            p.setSrvUnitName(procName);
            p.setSrvUnit(proc);
            p.setClassType(classType);
            p.setSrvDefines(srvDefine);
            p.setRequestHandlerInstalled(false);
            p.setEventHandlerInstalled(false);
            procMap.put(procName, p);
            log.info("\u5df2\u6ce8\u518c\u670d\u52a1\u5355\u5143:{} \u5305\u542b{}\u4e2a\u5185\u90e8\u6784\u4ef6", (Object)procName, (Object)srvDefine.size());
            SrvDefine hook = DefineTools.getHook("hook_activated", srvDefine);
            if (hook != null) {
                hook.getMethod().invoke(proc, new Object[0]);
            }
            Application.injector.injectMembers(proc);
        }
        catch (SrvDefineException e) {
            e.printStackTrace();
            log.warn("\u65e0\u6cd5\u6ce8\u518c\u670d\u52a1\u5355\u5143:{} - {} \u56e0\u4e3a\u670d\u52a1\u5355\u5143\u5df2\u635f\u574f.", (Object)procName, (Object)classType);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void installRequestHandler() {
        for (Map.Entry<String, ActivatedSrvUnit> item : procMap.entrySet()) {
            if (item.getValue().isRequestHandlerInstalled()) continue;
            List<SrvDefine> defines = item.getValue().getSrvDefines();
            String procName = item.getKey();
            String procClassType = item.getValue().getSrvUnit().getClass().getName();
            for (SrvDefine def : defines) {
                if (!def.getDefType().equals("request_handler")) continue;
                RequestHandlerVo byName = this.requestHandlerMapper.getByPatternAndParamsCount(def.getPattern(), def.getParamCount());
                if (byName != null) {
                    if (!byName.getSrvUnitClassType().equals(procClassType)) {
                        this.requestHandlerMapper.deleteById(byName.getId());
                        log.info("\u79fb\u9664\u8bf7\u6c42\u5904\u7406\u5668 {}:{}", (Object)byName.getSrvUnitName(), (Object)byName.getSrvUnitClassType());
                    } else {
                        log.info("\u6fc0\u6d3b\u8bf7\u6c42\u5904\u7406\u5668 {}:{}({})", new Object[]{procName, byName.getPattern(), byName.getParamsCount()});
                        continue;
                    }
                }
                RequestHandlerVo insert = new RequestHandlerVo();
                insert.setId(this.snowflake.nextId());
                insert.setPattern(def.getPattern());
                insert.setParams(JSON.toJSONString(def.getParams()));
                insert.setParamsCount(def.getParamCount());
                insert.setSrvUnitName(procName);
                insert.setSrvUnitClassType(procClassType);
                insert.setStatus(0);
                insert.setMetadata("");
                insert.setCreateTime(new Date());
                this.requestHandlerMapper.insert(insert);
                log.info("\u6ce8\u518c\u8bf7\u6c42\u6267\u884c\u5668 {}:{}({})", new Object[]{procName, def.getPattern(), def.getParamCount()});
            }
            item.getValue().setRequestHandlerInstalled(true);
        }
    }

    public void installEventHandler() {
        for (Map.Entry<String, ActivatedSrvUnit> item : procMap.entrySet()) {
            if (item.getValue().isEventHandlerInstalled()) continue;
            List<SrvDefine> srvDefines = item.getValue().getSrvDefines();
            for (SrvDefine def : srvDefines) {
                if (!def.getDefType().equals("event_handler") || !def.isGlobalEventHandler()) continue;
                this.eventSchedule.register(def);
            }
            item.getValue().setEventHandlerInstalled(true);
        }
    }

    public Process forward(ShellRequest request, HookTaskFinished hook) {
        this.resolverRequest(request);
        RequestHandlerVo requestHandlerVo = this.requestHandlerMapper.getByPatternAndParamsCount(request.getPattern(), request.getParams().size());
        if (requestHandlerVo == null) {
            log.warn("\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42:{} \u65e0\u6cd5\u4ece\u6570\u636e\u5e93\u67e5\u627e\u5230\u5408\u9002\u7684Handler", (Object)request.getPattern());
            this.eventSchedule.forward(new BadRequestEvent(request, "PSM:STM:E0"));
            return null;
        }
        ActivatedSrvUnit aProc = procMap.get(requestHandlerVo.getSrvUnitName());
        if (aProc == null) {
            this.eventSchedule.forward(new BadRequestEvent(request, "PSM:STM:E0"));
            return null;
        }
        if (!aProc.getClassType().equals(requestHandlerVo.getSrvUnitClassType())) {
            log.warn("\u65e0\u6cd5\u5904\u7406\u8bf7\u6c42:{} \u6570\u636e\u5e93\u4e0e\u5f53\u524d\u52a0\u8f7d\u7684\u670d\u52a1\u5355\u5143\u7c7b\u578b\u4e0d\u4e00\u81f4. \u6570\u636e\u5e93:{} \u5f53\u524d:{}", new Object[]{request.getPattern(), requestHandlerVo.getSrvUnitClassType(), aProc.getClassType()});
            this.eventSchedule.forward(new BadRequestEvent(request, "PSM:STM:E1"));
            return null;
        }
        SrvDefine procDef = DefineTools.getDefine(requestHandlerVo.getPattern(), requestHandlerVo.getParamsCount(), aProc.getSrvDefines());
        if (procDef == null) {
            procDef = DefineTools.getDefaultDefine(aProc.getSrvDefines());
        }
        if (procDef == null) {
            this.eventSchedule.forward(new BadRequestEvent(new ShellRequest(request), "PSM:STM:E2"));
        }
        request.setMetadata(requestHandlerVo.getMetadata());
        Process t = new Process();
        t.setTaskName(procDef.getMethod().getName());
        t.setRequest(request);
        t.setServiceUnit(aProc);
        t.setTarget(procDef.getMethod());
        t.setInjectParams(SrvUnitTools.assemblyParams(procDef.getMethod(), request.getParams(), request, t, this.taskManager));
        t.setFinishHook(hook);
        t.setTaskManager(this.taskManager);
        this.taskManager.commit(t);
        return t;
    }

    public void scanFromPackage(String packagePath) {
        Reflections reflections = new Reflections(packagePath, new Scanner[0]);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(ServiceUnit.class);
        this.register(this.getProcessorForClassSet(typesAnnotatedWith));
    }

    public void scanFromURL(URL url) {
        URLClassLoader loader = new URLClassLoader(new URL[]{url});
        Reflections packageReflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addClassLoaders(new ClassLoader[]{loader}));
        Set typesAnnotatedWith = packageReflections.getTypesAnnotatedWith(ServiceUnit.class);
        this.register(this.getProcessorForClassSet(typesAnnotatedWith));
    }

    public void scanFromPlugins(URL url, ClassLoader classLoader) {
        Reflections packageReflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addClassLoaders(new ClassLoader[]{classLoader}));
        Set typesAnnotatedWith = packageReflections.getTypesAnnotatedWith(ServiceUnit.class);
        this.register(this.getProcessorForClassSet(typesAnnotatedWith));
    }

    private List<Object> getProcessorForClassSet(Set<Class<?>> classSet) {
        if (classSet.isEmpty()) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Class<?> item : classSet) {
            try {
                Object processor = item.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ret.add(processor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private void resolverRequest(ShellRequest req) {
        String[] split;
        String statement = req.getStatement();
        String requestName = null;
        requestName = statement.trim();
        String[] params = statement.split(">");
        if (params.length <= 1) {
            req.setPattern(requestName);
            req.setParams(new ArrayList<String>());
            return;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        String param = params[1];
        for (String item : split = param.split(",")) {
            if (item.trim().equals("")) continue;
            paramList.add(item.trim());
        }
        req.setPattern(params[0]);
        req.setParams(paramList);
    }

    public static ActivatedSrvUnit getProcessor(String procName) {
        return procMap.get(procName);
    }
}

