/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.services;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.mapper.UsersMapper;
import com.ksptooi.psm.modes.UserVo;
import jakarta.inject.Inject;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import xyz.downgoon.snowflake.Snowflake;

@Unit
public class UserAccountService {
    @Inject
    private UsersMapper userMapper;
    @Inject
    private Snowflake snowflake;

    public int getTotal() {
        return this.userMapper.count(null);
    }

    public UserVo getByAccount(String account) {
        return this.userMapper.getByAccount(account);
    }

    public void updateLastLoginTime(Long id) {
        UserVo byId = this.userMapper.getById(id);
        byId.setLastLoginTime(new Date());
        this.userMapper.update(byId);
    }

    public boolean createUser(String account, String password) throws Exception {
        UserVo query = new UserVo();
        query.setAccount(account);
        if (!this.userMapper.getList(query).isEmpty()) {
            throw new Exception("\u8d26\u6237\u540d\u79f0\u91cd\u590d.");
        }
        UserVo u = new UserVo();
        u.setUid(this.snowflake.nextId());
        u.setAccount(account);
        String passwordCt = DigestUtils.sha512Hex((String)(u.getUid() + password));
        u.setPassword(passwordCt);
        u.setStatus(0);
        u.setLastLoginTime(new Date());
        u.setCreateTime(new Date());
        int insert = this.userMapper.insert(u);
        return insert > 0;
    }
}

