/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.shell;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.modes.UserVo;
import com.ksptooi.psm.services.LoginHistoryService;
import com.ksptooi.psm.services.UserAccountService;
import jakarta.inject.Inject;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.sshd.server.auth.AsyncAuthException;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unit
public class SimplePasswordAuthenticator
implements PasswordAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(SimplePasswordAuthenticator.class);
    @Inject
    private UserAccountService accountService;
    @Inject
    private LoginHistoryService historyService;

    public boolean authenticate(String username, String inPassPt, ServerSession session) throws PasswordChangeRequiredException, AsyncAuthException {
        try {
            if (this.accountService.getTotal() < 1) {
                String account = "default";
                String pwdPt = this.generatePassword();
                this.accountService.createUser("default", pwdPt);
                log.info("\u5df2\u521b\u5efa\u9ed8\u8ba4\u7528\u6237:{} \u5bc6\u7801:{}", (Object)"default", (Object)pwdPt);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        UserVo vo = this.accountService.getByAccount(username);
        SocketAddress origin = session.getClientAddress();
        if (vo == null || vo.getStatus() != 0) {
            log.warn("\u6e90:{} \u63d0\u4f9b\u4e86\u4e00\u4e2a\u65e0\u6548\u7684\u8d26\u6237 {}.", (Object)origin, (Object)username);
            this.historyService.newLoginFailedRecord(username, origin, "\u672a\u77e5\u7684\u8d26\u6237");
            return false;
        }
        String inPassCt = DigestUtils.sha512Hex((String)(vo.getUid() + inPassPt));
        if (!vo.getPassword().equals(inPassCt)) {
            log.warn("\u6e90:{} \u8d26\u6237:{} \u56e0\u5bc6\u7801\u9519\u8bef\u767b\u5f55\u5931\u8d25.", (Object)username, (Object)origin);
            this.historyService.newLoginFailedRecord(username, origin, "\u51ed\u636e\u9519\u8bef");
            return false;
        }
        this.historyService.newLoginSuccessRecord(username, origin);
        this.accountService.updateLastLoginTime(vo.getUid());
        return true;
    }

    public boolean handleClientPasswordChangeRequest(ServerSession session, String username, String oldPassword, String newPassword) {
        return super.handleClientPasswordChangeRequest(session, username, oldPassword, newPassword);
    }

    private String generatePassword() {
        String uppercaseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
        String numbers = "0123456789";
        String symbols = "!@#$%^&*()-_+=<>?";
        String allChars = uppercaseLetters + lowercaseLetters + numbers + symbols;
        StringBuilder password = new StringBuilder();
        Random random = new Random();
        password.append(uppercaseLetters.charAt(random.nextInt(uppercaseLetters.length())));
        password.append(lowercaseLetters.charAt(random.nextInt(lowercaseLetters.length())));
        password.append(numbers.charAt(random.nextInt(numbers.length())));
        password.append(symbols.charAt(random.nextInt(symbols.length())));
        for (int i = 4; i < 12; ++i) {
            password.append(allChars.charAt(random.nextInt(allChars.length())));
        }
        List charList = password.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        Collections.shuffle(charList);
        StringBuilder shuffledPassword = new StringBuilder();
        for (Character character : charList) {
            shuffledPassword.append(character);
        }
        return shuffledPassword.toString();
    }
}

