/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.subsystem;

import com.ksptooi.guice.annotations.Unit;
import com.ksptooi.psm.exception.SubSystemInstallException;
import com.ksptooi.psm.subsystem.SubSystemEntry;
import com.ksptooi.psm.subsystem.entity.DiscoveredSubSystem;
import com.ksptooi.uac.commons.JarFileFilter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Unit
public class SubSystemScanner {
    private static final Logger log = LoggerFactory.getLogger(SubSystemScanner.class);

    public List<DiscoveredSubSystem> scan(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return Collections.emptyList();
        }
        File[] jarFiles = dir.listFiles(new JarFileFilter());
        if (jarFiles == null || jarFiles.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<DiscoveredSubSystem> ret = new ArrayList<DiscoveredSubSystem>();
        for (File jar : jarFiles) {
            String jarFileName = jar.getName();
            try {
                URL url = jar.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                Reflections packageReflections = new Reflections((Configuration)new ConfigurationBuilder().addUrls(new URL[]{url}).addClassLoaders(new ClassLoader[]{loader}));
                Set entrySet = packageReflections.getTypesAnnotatedWith(SubSystemEntry.class);
                Class<?> entry = this.ensureCorrectEntry(jarFileName, entrySet);
                SubSystemEntry anno = entry.getAnnotation(SubSystemEntry.class);
                DiscoveredSubSystem discovered = new DiscoveredSubSystem();
                discovered.setJarFile(jar);
                discovered.setName(anno.name());
                discovered.setVersion(anno.version());
                discovered.setEntry(entry);
                discovered.setClassLoader(loader);
                discovered.setReflections(packageReflections);
                log.info("\u53d1\u73b0\u53ef\u7528\u7684\u5b50\u7cfb\u7edf {}-{}:[{}]", new Object[]{anno.name(), anno.version(), jarFileName});
                ret.add(discovered);
            }
            catch (SubSystemInstallException | MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<DiscoveredSubSystem> scan(String path) {
        return this.scan(new File(path));
    }

    private Class<?> ensureCorrectEntry(String jarName, Set<Class<?>> entries) {
        if (entries.isEmpty()) {
            throw new SubSystemInstallException("The subsystem does not have entry. jar file name:" + jarName);
        }
        if (entries.size() != 1) {
            throw new SubSystemInstallException("The subsystem has multiple entries the jar file name:" + jarName);
        }
        Class<?> next = entries.iterator().next();
        SubSystemEntry annoEntry = next.getAnnotation(SubSystemEntry.class);
        String n = annoEntry.name();
        String v = annoEntry.version();
        if (StringUtils.isBlank((CharSequence)n)) {
            throw new SubSystemInstallException("the subsystem is damaged. because %name% is blank in the entry.  jar file name:" + jarName);
        }
        if (StringUtils.isBlank((CharSequence)v)) {
            throw new SubSystemInstallException("the subsystem is damaged. because %version% is blank in the entry.  jar file name:" + jarName);
        }
        return next;
    }
}

