/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.utils;

public class FixedSizeStringBuffer {
    private final StringBuffer buffer;
    private final int maxSize;

    public FixedSizeStringBuffer(int maxSize) {
        this.maxSize = maxSize;
        this.buffer = new StringBuffer();
    }

    public FixedSizeStringBuffer append(char c) {
        if (this.buffer.length() >= this.maxSize) {
            this.buffer.deleteCharAt(0);
        }
        this.buffer.append(c);
        return this;
    }

    public FixedSizeStringBuffer append(String str) {
        for (char c : str.toCharArray()) {
            this.append(c);
        }
        return this;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public int length() {
        return this.buffer.length();
    }

    public char charAt(int index) {
        return this.buffer.charAt(index);
    }

    public void delete(int start, int end) {
        this.buffer.delete(start, end);
    }

    public FixedSizeStringBuffer clear() {
        this.buffer.setLength(0);
        return this;
    }

    public FixedSizeStringBuffer setLength(int i) {
        this.buffer.setLength(i);
        return this;
    }
}

