/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.utils.aio;

import asia.kala.ansi.AnsiString;
import com.ksptooi.psm.utils.aio.AdvancedInputOutputPort;
import com.ksptooi.psm.utils.aio.BufferedAndMatcher;
import com.ksptooi.psm.utils.aio.ConnectMode;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;

public class AdvInputOutputCable
extends BufferedAndMatcher {
    private final long id;
    private AdvancedInputOutputPort port;
    private boolean destroyed = false;
    private final Queue<char[]> is = new ArrayBlockingQueue<char[]>(8192);
    private final Queue<String> os = new ArrayBlockingQueue<String>(8192);

    public AdvInputOutputCable(Long id, AdvancedInputOutputPort port) {
        this.id = id;
        this.port = port;
    }

    public void connect(ConnectMode m) {
        this.ensureCableNotDestroyed();
        if (!this.isConnect(m)) {
            this.port.connect(this, m, this.is, this.os);
        }
    }

    public void connect() {
        this.connect(ConnectMode.INPUT);
        this.connect(ConnectMode.OUTPUT);
    }

    public void disconnect(ConnectMode m) {
        if (this.isConnect(m)) {
            this.port.disconnect(m);
        }
    }

    public void disconnect() {
        this.disconnect(ConnectMode.INPUT);
        this.disconnect(ConnectMode.OUTPUT);
    }

    public void read() throws IOException {
        this.ensureCableNotDestroyed();
        this.rl = this.port.read(this, this.rb);
    }

    public void bindPort(AdvancedInputOutputPort port) {
        this.ensureCableNotDestroyed();
        if (this.isConnect(ConnectMode.INPUT)) {
            this.disconnect(ConnectMode.INPUT);
        }
        if (this.isConnect(ConnectMode.OUTPUT)) {
            this.disconnect(ConnectMode.OUTPUT);
        }
        this.port = port;
    }

    public void flush() {
        this.ensureCableNotDestroyed();
        if (!this.isConnect(ConnectMode.OUTPUT)) {
            return;
        }
        this.port.flush(this);
    }

    public AdvInputOutputCable nextLine() {
        this.ensureCableNotDestroyed();
        this.os.add("\r\n");
        return this;
    }

    public AdvInputOutputCable print(String a) {
        this.ensureCableNotDestroyed();
        this.os.add(a);
        return this;
    }

    public AdvInputOutputCable print(byte b) {
        return this.print(String.valueOf(b));
    }

    public AdvInputOutputCable print(short s) {
        return this.print(String.valueOf(s));
    }

    public AdvInputOutputCable print(int i) {
        return this.print(String.valueOf(i));
    }

    public AdvInputOutputCable print(long l) {
        return this.print(String.valueOf(l));
    }

    public AdvInputOutputCable print(float f) {
        return this.print(String.valueOf(f));
    }

    public AdvInputOutputCable print(double d) {
        return this.print(String.valueOf(d));
    }

    public AdvInputOutputCable print(boolean b) {
        return this.print(String.valueOf(b));
    }

    public AdvInputOutputCable print(char c) {
        return this.print(String.valueOf(c));
    }

    public AdvInputOutputCable print(char[] c) {
        return this.print(String.valueOf(c));
    }

    public AdvInputOutputCable print(Object o) {
        return this.print(o.toString());
    }

    public AdvInputOutputCable println(String i) {
        this.ensureCableNotDestroyed();
        this.print(i).nextLine();
        return this;
    }

    public AdvInputOutputCable println(byte v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(short v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(int v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(long v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(float v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(double v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(boolean v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(char v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(char[] v) {
        return this.println(String.valueOf(v));
    }

    public AdvInputOutputCable println(Object v) {
        return this.println(v.toString());
    }

    public AdvInputOutputCable w(byte v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(short v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(int v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(long v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(float v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(double v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(boolean v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(char v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(char[] v) {
        return this.print(v);
    }

    public AdvInputOutputCable w(Object v) {
        return this.print(v);
    }

    public AdvInputOutputCable color(int r, int g, int b) {
        this.os.add(AnsiString.Color.True((int)r, (int)g, (int)b).toString());
        return this;
    }

    public static void main(String[] args) {
        AnsiString aTrue = AnsiString.Color.True((int)127, (int)0, (int)85).overlay((CharSequence)"HGFHGFH");
        System.out.println(aTrue.toString());
    }

    public long getId() {
        return this.id;
    }

    public AdvancedInputOutputPort getPort() {
        return this.port;
    }

    public boolean isConnect(ConnectMode t) {
        return this.port != null && this.port.isConnect(this, t);
    }

    public int getReadLen() {
        return this.rl;
    }

    public char[] getReadChars() {
        return this.rb;
    }

    public String getReadString() {
        return String.valueOf(this.rb, 0, this.rl);
    }

    public void printDebugText() {
        StringBuilder sb = new StringBuilder();
        sb.append("CABLE(").append(this.id).append(")->");
        sb.append("[ ");
        for (int i = 0; i < this.rl; ++i) {
            sb.append((int)this.rb[i]).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        System.out.println("VK_PRINT:: " + sb.toString());
    }

    public void destroy() {
        this.disconnect();
        this.is.clear();
        this.os.clear();
        this.port = null;
        this.destroyed = true;
    }

    public void ensureCableNotDestroyed() {
        if (this.port == null || this.destroyed) {
            throw new RuntimeException("this cable unavailable");
        }
    }
}

