/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.utils.aio;

import com.ksptooi.psm.utils.aio.BufferedAndMatcher;
import com.ksptooi.psm.utils.aio.ForwardStream;
import com.ksptooi.psm.utils.aio.NotAttachedException;
import com.ksptooi.psm.vk.NotSupportOperationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.server.Environment;
import xyz.downgoon.snowflake.Snowflake;

public class AdvInputOutputStream
extends BufferedAndMatcher {
    private static final Snowflake snowflake = new Snowflake(1L, 30L);
    private InputStream is;
    private OutputStream os;
    private Environment env;
    private BufferedReader b;
    private final PrintWriter p;
    private final Map<Long, ForwardStream> subStreamMap = new ConcurrentHashMap<Long, ForwardStream>();
    private boolean offline = false;
    private final Long subStreamId;
    private AdvInputOutputStream parent = null;
    private Queue<String> subOs;
    private long subStreamInput = -1L;
    private long subStreamOutput = -1L;

    public AdvInputOutputStream(InputStream is, OutputStream os, Environment env) {
        this.is = is;
        this.os = os;
        this.env = env;
        this.b = new BufferedReader(new InputStreamReader(this.is));
        this.p = new PrintWriter(this.os);
        this.subStreamId = -1L;
    }

    public AdvInputOutputStream(Long id, AdvInputOutputStream parent, InputStream is, Queue<String> os, Environment env) {
        this.is = is;
        this.os = null;
        this.env = env;
        this.b = new BufferedReader(new InputStreamReader(is));
        this.subOs = os;
        this.p = null;
        this.subStreamId = id;
        this.parent = parent;
    }

    public AdvInputOutputStream createSubStream() {
        long id = snowflake.nextId();
        ForwardStream subForwardStream = new ForwardStream(id, this, this.env);
        this.subStreamMap.put(id, subForwardStream);
        return subForwardStream.getInstance();
    }

    public AdvInputOutputStream joinSubStream(AdvInputOutputStream aio) {
        if (!aio.isSubStream()) {
            throw new RuntimeException("\u65e0\u6cd5\u5c06\u4e00\u4e2a\u9876\u5c42AIO\u52a0\u5165\u5230\u9876\u5c42AIO\u4e2d.");
        }
        aio.removeForParent();
        aio.detachInput();
        aio.detachOutput();
        Long id = aio.getId();
        ForwardStream sub = new ForwardStream(aio, this, this.env);
        this.subStreamMap.put(id, sub);
        return sub.getInstance();
    }

    public Queue<String> rebuild(InputStream is, AdvInputOutputStream parent, Environment env) {
        if (!this.isSubStream()) {
            throw new RuntimeException("\u65e0\u6cd5\u5728\u9876\u5c42AIO\u4e0a\u6267\u884cRebuild.");
        }
        this.is = is;
        this.parent = parent;
        this.env = env;
        this.offline = false;
        return this.subOs;
    }

    public void removeSubStream(Long id) {
        if (!this.subStreamMap.containsKey(id)) {
            return;
        }
        ForwardStream fs = this.subStreamMap.get(id);
        fs.destroy();
        this.subStreamMap.remove(id);
    }

    public void read() throws IOException {
        if (this.isSubStream() && !this.parent.isHeldInput(this.subStreamId)) {
            throw new NotAttachedException("The SubStream is not attached to the InputStream");
        }
        this.rl = this.b.read(this.rb);
        if (this.subStreamInput != -1L) {
            this.subStreamMap.get(this.subStreamInput).getForwardCharOut().write(this.rb, 0, this.rl);
            this.subStreamMap.get(this.subStreamInput).getForwardCharOut().flush();
            this.rl = 0;
            return;
        }
        if (this.rl < 1) {
            throw new IOException();
        }
    }

    public AdvInputOutputStream nextLine() {
        if (this.isSubStream()) {
            this.subOs.add("\r\n");
            return this;
        }
        this.p.print("\r\n");
        return this;
    }

    public AdvInputOutputStream print(String a) {
        if (this.isSubStream()) {
            this.subOs.add(a);
            return this;
        }
        this.p.print(a);
        return this;
    }

    public AdvInputOutputStream print(int i) {
        return this.print("" + i);
    }

    public AdvInputOutputStream println(String a) {
        if (this.isSubStream()) {
            this.subOs.add(a);
            this.subOs.add("\r\n");
            return this;
        }
        this.p.println(a);
        return this;
    }

    public AdvInputOutputStream println(int i) {
        return this.println("" + i);
    }

    public AdvInputOutputStream flush() {
        if (this.isSubStream()) {
            this.parent.notifyFlush(this.subStreamId);
            return this;
        }
        this.p.flush();
        return this;
    }

    private void notifyFlush(long subStreamId) {
        this.ensureNotSubStream();
        if (!this.subStreamMap.containsKey(subStreamId)) {
            return;
        }
        Queue<String> forwardIn = this.subStreamMap.get(subStreamId).getForwardIn();
        if (this.subStreamOutput != subStreamId) {
            forwardIn.clear();
            return;
        }
        if (!forwardIn.isEmpty()) {
            assert (this.p != null);
            forwardIn.forEach(this.p::print);
            this.p.flush();
            forwardIn.clear();
        }
    }

    public int directRead(char[] c) throws IOException {
        return this.b.read(c);
    }

    public int directRead() throws IOException {
        return this.b.read();
    }

    public int getReadLen() {
        return this.rl;
    }

    public char[] getReadChars() {
        return this.rb;
    }

    public Long getId() {
        return this.subStreamId;
    }

    public boolean isSubStream() {
        return this.parent != null;
    }

    public boolean isHeldInput(long subStreamId) {
        if (this.isSubStream()) {
            return this.parent.isHeldInput(subStreamId);
        }
        return this.subStreamInput == subStreamId;
    }

    public boolean isHeldOutput(long subStreamId) {
        if (this.isSubStream()) {
            return this.parent.isHeldOutput(subStreamId);
        }
        return this.subStreamOutput == subStreamId;
    }

    public void attachInput() {
        this.ensureIsSubStream();
        this.parent.notifyAttachInput(this.subStreamId);
    }

    public void attachOutput() {
        if (!this.isSubStream()) {
            this.ensureNotSubStream();
            this.subStreamOutput = -1L;
            return;
        }
        this.ensureIsSubStream();
        this.parent.notifyAttachOutput(this.subStreamId);
    }

    public void detachInput() {
        if (!this.isSubStream()) {
            this.ensureNotSubStream();
            this.subStreamInput = -1L;
            return;
        }
        this.ensureIsSubStream();
        this.parent.notifyDetachInput(this.subStreamId);
    }

    public void detachOutput() {
        if (!this.isSubStream()) {
            this.ensureNotSubStream();
            this.subStreamOutput = -1L;
            return;
        }
        this.ensureIsSubStream();
        this.parent.notifyDetachOutput(this.subStreamId);
    }

    public void destroy() {
        if (this.isSubStream()) {
            this.parent.removeSubStream(this.subStreamId);
            return;
        }
        this.detachInput();
        this.detachOutput();
        this.is.close();
        this.os.close();
        this.offline = true;
    }

    private void notifyAttachInput(long subStreamId) {
        this.ensureNotSubStream();
        this.subStreamInput = subStreamId;
    }

    private void notifyAttachOutput(long subStreamId) {
        this.ensureNotSubStream();
        this.subStreamOutput = subStreamId;
    }

    private void notifyDetachInput(long subStreamId) {
        this.ensureNotSubStream();
        if (!this.isHeldInput(subStreamId)) {
            return;
        }
        this.subStreamInput = -1L;
    }

    private void notifyDetachOutput(long subStreamId) {
        this.ensureNotSubStream();
        if (!this.isHeldOutput(subStreamId)) {
            return;
        }
        this.subStreamOutput = -1L;
    }

    private void notifyRemoveSubStream(long subStreamId) {
        this.ensureNotSubStream();
        ForwardStream fs = this.subStreamMap.get(subStreamId);
        if (fs == null) {
            return;
        }
        if (this.subStreamInput == subStreamId) {
            this.subStreamInput = -1L;
        }
        if (this.subStreamOutput == subStreamId) {
            this.subStreamOutput = -1L;
        }
        try {
            fs.getForwardCharOut().close();
            fs.getForwardOut().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.subStreamMap.remove(subStreamId);
    }

    private void ensureIsSubStream() {
        if (!this.isSubStream()) {
            throw new NotSupportOperationException("the TopLayerStream not support this operation");
        }
    }

    private void ensureNotSubStream() {
        if (this.isSubStream()) {
            throw new NotSupportOperationException("the subStream not support this operation");
        }
    }

    private void removeForParent() {
        this.ensureIsSubStream();
        this.parent.notifyRemoveSubStream(this.subStreamId);
    }

    public void printDebugText() {
        StringBuilder sb = new StringBuilder();
        if (!this.isSubStream()) {
            sb.append("AIO->");
        } else {
            sb.append("AIO(").append(this.subStreamId).append(")->");
        }
        sb.append("[ ");
        for (int i = 0; i < this.rl; ++i) {
            sb.append((int)this.rb[i]).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(" ]");
        System.out.println("VK_PRINT:: " + sb.toString());
    }

    public boolean isOffline() {
        return this.offline;
    }
}

