/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.utils.aio;

import com.ksptooi.psm.utils.aio.AdvInputOutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.sshd.server.Environment;

public class ForwardStream {
    private final PipedOutputStream forwardOut;
    private final PrintWriter forwardCharOut;
    private final Queue<String> forwardIn;
    private final AdvInputOutputStream instance;

    public ForwardStream(Long id, AdvInputOutputStream parent, Environment env) {
        PipedInputStream subIn = new PipedInputStream(2048);
        this.forwardOut = new PipedOutputStream(subIn);
        this.forwardCharOut = new PrintWriter(this.forwardOut);
        this.forwardIn = new ConcurrentLinkedQueue<String>();
        this.instance = new AdvInputOutputStream(id, parent, subIn, this.forwardIn, env);
    }

    public ForwardStream(AdvInputOutputStream subStream, AdvInputOutputStream parent, Environment env) {
        if (!subStream.isSubStream()) {
            throw new RuntimeException("\u65e0\u6cd5\u5c06\u4e00\u4e2a\u9876\u5c42AIO\u52a0\u5165\u5230\u9876\u5c42AIO\u4e2d.");
        }
        PipedInputStream subIn = new PipedInputStream(2048);
        this.forwardOut = new PipedOutputStream(subIn);
        this.forwardCharOut = new PrintWriter(this.forwardOut);
        this.instance = subStream;
        this.forwardIn = subStream.rebuild(subIn, parent, env);
    }

    public void destroy() {
        this.instance.detachInput();
        this.instance.detachOutput();
        this.forwardOut.close();
    }

    public PipedOutputStream getForwardOut() {
        return this.forwardOut;
    }

    public PrintWriter getForwardCharOut() {
        return this.forwardCharOut;
    }

    public Queue<String> getForwardIn() {
        return this.forwardIn;
    }

    public AdvInputOutputStream getInstance() {
        return this.instance;
    }
}

