/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.psm.vk;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.sshd.server.Environment;

public class ShellVK {
    private OutputStream os;
    private PrintWriter pw;
    private StringBuffer sb = new StringBuffer();
    private Environment env;

    public ShellVK(OutputStream os, Environment env) {
        this.os = os;
        this.pw = new PrintWriter(os);
        this.env = env;
    }

    public void press(char[] c, int len) throws IOException {
        this.sb.append(c, 0, len);
        this.pw.write(this.sb.toString());
        this.pw.flush();
        this.sb.setLength(0);
    }

    public void replaceCurrentLine(String str) {
        this.pw.write("\r");
        this.pw.write("\u001b[K");
        this.pw.write(str);
        this.pw.flush();
    }

    public void replaceCurrentLine(String str, int cursor) {
        this.pw.write("\r");
        this.pw.write("\u001b[K");
        this.pw.write("\u001b[2K");
        int columns = Integer.parseInt((String)this.env.getEnv().get("COLUMNS"));
        Object print = str;
        if (((String)print).length() >= columns - 11) {
            int more = ((String)print).length() - (columns - 11);
            print = ((String)print).substring(0, columns - 11);
            print = (String)print + ">>more(" + more + ")";
        }
        this.pw.write((String)print);
        this.pw.write("\r");
        for (int i = 0; i < cursor; ++i) {
            char c = str.charAt(i);
            if (this.isDoubleWidth(c)) {
                this.pw.write("\u001b[C\u001b[C");
                continue;
            }
            this.pw.write("\u001b[C");
        }
        this.pw.flush();
    }

    public void nextLine() {
        this.pw.write("\r\n");
        this.pw.flush();
    }

    public void backspace() {
        this.pw.print("\b \b");
        this.pw.flush();
    }

    public void deleteDoubleWidth() {
        this.pw.print("\b \b");
        this.pw.print("\b \b");
        this.pw.flush();
    }

    public void cursorLeft() {
        this.pw.print("\u001b[D");
        this.pw.flush();
    }

    public void cursorRight() {
        this.pw.print("\u001b[C");
        this.pw.flush();
    }

    public void synCursor(String text, int vCursor) {
        this.pw.write("\r");
        for (int i = 0; i < vCursor; ++i) {
            char c = text.charAt(i);
            if (this.isDoubleWidth(c)) {
                this.pw.write("\u001b[C\u001b[C");
                continue;
            }
            this.pw.write("\u001b[C");
        }
        this.pw.flush();
    }

    public boolean isDoubleWidth(char c) {
        return c > '\u007f';
    }
}

