/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.commons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CommandLineTable {
    private static final String HORIZONTAL_SEP = "-";
    private String verticalSep;
    private String joinSep;
    private String[] headers;
    private List<String[]> rows = new ArrayList<String[]>();
    private boolean rightAlign;

    public CommandLineTable() {
        this.setShowVerticalLines(false);
    }

    public void setRightAlign(boolean rightAlign) {
        this.rightAlign = rightAlign;
    }

    public void setShowVerticalLines(boolean showVerticalLines) {
        this.verticalSep = showVerticalLines ? "|" : "";
        this.joinSep = showVerticalLines ? "+" : " ";
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    public void addRow(String ... cells) {
        this.rows.add(cells);
    }

    public void print() {
        int[] maxWidths = this.headers != null ? Arrays.stream(this.headers).mapToInt(String::length).toArray() : null;
        for (String[] cells : this.rows) {
            if (maxWidths == null) {
                maxWidths = new int[cells.length];
            }
            if (cells.length != maxWidths.length) {
                throw new IllegalArgumentException("Number of row-cells and headers should be consistent");
            }
            for (int i = 0; i < cells.length; ++i) {
                try {
                    maxWidths[i] = Math.max(maxWidths[i], cells[i].length());
                    continue;
                }
                catch (Exception e) {
                    maxWidths[i] = maxWidths[i];
                }
            }
        }
        if (this.headers != null) {
            this.printLine(maxWidths);
            this.printRow(this.headers, maxWidths);
            this.printLine(maxWidths);
        }
        for (String[] cells : this.rows) {
            this.printRow(cells, maxWidths);
        }
        if (this.headers != null) {
            this.printLine(maxWidths);
        }
    }

    private void printLine(int[] columnWidths) {
        for (int i = 0; i < columnWidths.length; ++i) {
            String line = String.join((CharSequence)"", Collections.nCopies(columnWidths[i] + this.verticalSep.length() + 1, HORIZONTAL_SEP));
            System.out.print(this.joinSep + line + (i == columnWidths.length - 1 ? this.joinSep : ""));
        }
        System.out.println();
    }

    private void printRow(String[] cells, int[] maxWidths) {
        for (int i = 0; i < cells.length; ++i) {
            String verStrTemp;
            String s = cells[i];
            String string = verStrTemp = i == cells.length - 1 ? this.verticalSep : "";
            if (this.rightAlign) {
                System.out.printf("%s %" + maxWidths[i] + "s %s", this.verticalSep, s, verStrTemp);
                continue;
            }
            System.out.printf("%s %-" + maxWidths[i] + "s %s", this.verticalSep, s, verStrTemp);
        }
        System.out.println();
    }

    public static void main(String[] args) {
        CommandLineTable st = new CommandLineTable();
        st.setShowVerticalLines(true);
        st.setHeaders("one", "two", "three");
        st.addRow("super", "broccoli", "flexible");
        st.addRow("assumptiHJJHJHJHon", "anJHJHJHGnouncement", "reflection");
        st.addRow("logJGHJic", "pleaJGHGHJsant", "wild");
        st.print();
    }
}

