/*
 * Decompiled with CFR 0.152.
 */
package com.ksptooi.uac.commons;

import com.ksptooi.uac.commons.CliProgressBar;
import com.ksptooi.uac.commons.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipCompress {
    private Logger logger = LoggerFactory.getLogger(ZipCompress.class);
    private DecimalFormat decFmt = new DecimalFormat("0.0");
    private Path source = null;
    private long sourceSize = 0L;
    private long readSize = 0L;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final AtomicBoolean streamIsReady = new AtomicBoolean(false);
    private final int buffSize = 524288;

    public ZipCompress(Path path) {
        this.source = path;
    }

    public InputStream getInputStream() {
        if (!Files.isDirectory(this.source, new LinkOption[0])) {
            throw new RuntimeException("\u6253\u5305\u64cd\u4f5c\u5931\u8d25,\u76ee\u6807\u4e0d\u662f\u6587\u4ef6\u5939! source:" + this.source.toString());
        }
        this.sourceSize = FileUtils.sizeOfDirectory((File)this.source.toFile());
        PipedInputStream pis = new PipedInputStream(524288);
        this.executorService.submit(() -> {
            try {
                PipedOutputStream os = new PipedOutputStream(pis);
                ZipOutputStream zos = new ZipOutputStream(os);
                this.addFolderToZip(this.source, this.source, zos);
                System.out.print("\r\n");
                zos.close();
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("\u6587\u4ef6\u5939\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6d41\u5931\u8d25!");
            }
        });
        while (!this.streamIsReady.get()) {
        }
        return pis;
    }

    public byte[] compress() {
        if (!Files.isDirectory(this.source, new LinkOption[0])) {
            throw new RuntimeException("\u6253\u5305\u64cd\u4f5c\u5931\u8d25,\u76ee\u6807\u4e0d\u662f\u6587\u4ef6\u5939! source:" + this.source.toString());
        }
        this.sourceSize = FileUtils.sizeOfDirectory((File)this.source.toFile());
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(os);
            this.addFolderToZip(this.source, this.source, zos);
            System.out.print("\r\n");
            zos.close();
            os.close();
            return os.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u6587\u4ef6\u5939\u8f6c\u6362\u4e3a\u4e8c\u8fdb\u5236\u6d41\u5931\u8d25!");
        }
    }

    private void addFolderToZip(Path path, Path sourceFolder, ZipOutputStream zos) throws IOException {
        File folder = path.toFile();
        File[] subFolder = folder.listFiles();
        if (subFolder == null) {
            return;
        }
        for (File item : subFolder) {
            String filePath = String.valueOf(path) + File.separator + item.getName();
            if (item.isDirectory()) {
                this.addFolderToZip(Paths.get(filePath, new String[0]), sourceFolder, zos);
            }
            if (item.isDirectory()) continue;
            String entryPath = filePath.replace(String.valueOf(sourceFolder) + File.separator, "");
            ZipEntry zipEntry = new ZipEntry(entryPath);
            zos.putNextEntry(zipEntry);
            FileInputStream is = new FileInputStream(item);
            byte[] buffer = new byte[524288];
            while (true) {
                int read = is.read(buffer);
                this.readSize += (long)read;
                if (read < 1) break;
                zos.write(buffer, 0, read);
                if (!this.streamIsReady.get()) {
                    this.streamIsReady.set(true);
                }
                CliProgressBar.updateProgressBar("\u5f52\u6863\u4e2d", this.readSize / 1024L / 1024L, this.sourceSize / 1024L / 1024L);
            }
            is.close();
            zos.closeEntry();
        }
    }

    private String toMb(long bytes) {
        return this.decFmt.format((double)bytes / 1024.0 / 1024.0);
    }
}

